/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.concurrent.IContext;
import cn.wjybxx.concurrent.TaskBuilder;
import cn.wjybxx.concurrent.TimeSharingTask;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ScheduledTaskBuilder<V>
extends TaskBuilder<V> {
    public static final byte SCHEDULE_ONCE = 0;
    public static final byte SCHEDULE_FIXED_DELAY = 1;
    public static final byte SCHEDULE_FIXED_RATE = 2;
    public static final byte SCHEDULE_DYNAMIC_DELAY = 3;
    private byte scheduleType = 0;
    private long initialDelay;
    private long period;
    private long timeout = -1L;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

    private ScheduledTaskBuilder(int type, Object task) {
        super(type, task);
    }

    private ScheduledTaskBuilder(int type, Object task, IContext ctx) {
        super(type, task, ctx);
    }

    public ScheduledTaskBuilder(TaskBuilder<? extends V> taskBuilder) {
        super(taskBuilder);
    }

    public static ScheduledTaskBuilder<?> newAction(Runnable task) {
        return new ScheduledTaskBuilder(0, task);
    }

    public static <V> ScheduledTaskBuilder<V> newAction(Consumer<IContext> task, IContext ctx) {
        return new ScheduledTaskBuilder<V>(1, task, ctx);
    }

    public static <V> ScheduledTaskBuilder<V> newFunc(Callable<? extends V> task) {
        return new ScheduledTaskBuilder<V>(2, task);
    }

    public static <V> ScheduledTaskBuilder<V> newFunc(Function<IContext, ? extends V> task, IContext ctx) {
        return new ScheduledTaskBuilder<V>(3, task, ctx);
    }

    public static <V> ScheduledTaskBuilder<V> newTimeSharing(TimeSharingTask<? super V> task) {
        return new ScheduledTaskBuilder<V>(4, task, IContext.NONE);
    }

    public static <V> ScheduledTaskBuilder<V> newTimeSharing(TimeSharingTask<? super V> task, IContext ctx) {
        return new ScheduledTaskBuilder<V>(4, task, ctx);
    }

    public static void validateInitialDelay(long initialDelay) {
        if (initialDelay < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", initialDelay));
        }
    }

    public static void validatePeriod(long period) {
        if (period == 0L) {
            throw new IllegalArgumentException("period: 0 (expected: != 0)");
        }
    }

    public int getScheduleType() {
        return this.scheduleType;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public long getPeriod() {
        return this.period;
    }

    public boolean isPeriodic() {
        return this.scheduleType != 0;
    }

    public boolean isOnlyOnce() {
        return this.scheduleType == 0;
    }

    public ScheduledTaskBuilder<V> setOnlyOnce(long delay) {
        this.scheduleType = 0;
        this.initialDelay = delay;
        this.period = 0L;
        return this;
    }

    public ScheduledTaskBuilder<V> setOnlyOnce(long delay, TimeUnit unit) {
        this.setOnlyOnce(delay);
        this.timeUnit = Objects.requireNonNull(unit);
        return this;
    }

    public boolean isFixedDelay() {
        return this.scheduleType == 1;
    }

    public ScheduledTaskBuilder<V> setFixedDelay(long initialDelay, long period) {
        ScheduledTaskBuilder.validatePeriod(period);
        this.scheduleType = 1;
        this.initialDelay = initialDelay;
        this.period = period;
        return this;
    }

    public ScheduledTaskBuilder<V> setFixedDelay(long initialDelay, long period, TimeUnit unit) {
        this.setFixedDelay(initialDelay, period);
        this.timeUnit = Objects.requireNonNull(unit);
        return this;
    }

    public boolean isFixedRate() {
        return this.scheduleType == 2;
    }

    public ScheduledTaskBuilder<V> setFixedRate(long initialDelay, long period) {
        ScheduledTaskBuilder.validateInitialDelay(initialDelay);
        ScheduledTaskBuilder.validatePeriod(period);
        this.scheduleType = (byte)2;
        this.initialDelay = initialDelay;
        this.period = period;
        return this;
    }

    public ScheduledTaskBuilder<V> setFixedRate(long initialDelay, long period, TimeUnit unit) {
        this.setFixedRate(initialDelay, period);
        this.timeUnit = Objects.requireNonNull(unit);
        return this;
    }

    public ScheduledTaskBuilder<V> setTimeout(long timeout) {
        if (timeout < -1L) {
            throw new IllegalArgumentException("invalid timeout " + timeout);
        }
        this.timeout = timeout;
        return this;
    }

    public ScheduledTaskBuilder<V> setTimeoutByCount(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("invalid count " + count);
        }
        this.timeout = count == 1 ? Math.max(0L, this.initialDelay) : Math.max(0L, this.initialDelay + (long)(count - 1) * this.period);
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean hasTimeout() {
        return this.timeout != -1L;
    }

    public ScheduledTaskBuilder<V> setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = Objects.requireNonNull(timeUnit);
        return this;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public ScheduledTaskBuilder<V> enable(int taskOption) {
        super.enable(taskOption);
        return this;
    }

    @Override
    public ScheduledTaskBuilder<V> disable(int taskOption) {
        super.disable(taskOption);
        return this;
    }

    @Override
    public ScheduledTaskBuilder<V> setSchedulePhase(int phase) {
        super.setSchedulePhase(phase);
        return this;
    }

    @Override
    public ScheduledTaskBuilder<V> setPriority(int priority) {
        super.setPriority(priority);
        return this;
    }

    @Override
    public ScheduledTaskBuilder<V> setOptions(int options) {
        super.setOptions(options);
        return this;
    }

    @Override
    public TaskBuilder<V> setCtx(IContext ctx) {
        super.setCtx(ctx);
        return this;
    }
}

