/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class TimeoutContext {
    private long timeLeft;
    private long lastTriggerTime;

    public TimeoutContext(long timeout, long timeCreate) {
        this.timeLeft = timeout;
        this.lastTriggerTime = timeCreate;
    }

    public void beforeCall(long realTriggerTime, long logicTriggerTime, boolean isFixedRate) {
        if (isFixedRate) {
            this.timeLeft -= logicTriggerTime - this.lastTriggerTime;
            this.lastTriggerTime = logicTriggerTime;
        } else {
            this.timeLeft -= realTriggerTime - this.lastTriggerTime;
            this.lastTriggerTime = realTriggerTime;
        }
    }

    public long getTimeLeft() {
        return this.timeLeft;
    }

    public boolean isTimeout() {
        return this.timeLeft <= 0L;
    }
}

