/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.sequential;

import cn.wjybxx.concurrent.BlockingOperationException;
import cn.wjybxx.concurrent.FutureUtils;
import cn.wjybxx.concurrent.IContext;
import cn.wjybxx.concurrent.IFuture;
import cn.wjybxx.concurrent.PromiseTask;
import cn.wjybxx.concurrent.TaskBuilder;
import cn.wjybxx.sequential.UniExecutorService;
import cn.wjybxx.sequential.UniPromise;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUniExecutor
implements UniExecutorService {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractUniExecutor.class);

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        if (this.isTerminated()) {
            return true;
        }
        throw new BlockingOperationException("awaitTermination");
    }

    @Override
    public abstract void execute(Runnable var1);

    @Override
    public void execute(Runnable command, int options) {
        this.execute(FutureUtils.toTask(command, options));
    }

    @Override
    public void execute(Consumer<? super IContext> action, IContext ctx) {
        this.execute(FutureUtils.toTask(action, ctx, 0));
    }

    @Override
    public void execute(Consumer<? super IContext> action, IContext ctx, int options) {
        this.execute(FutureUtils.toTask(action, ctx, options));
    }

    public <V> UniPromise<V> newPromise() {
        return new UniPromise(this);
    }

    @Override
    public <T> IFuture<T> submit(@Nonnull TaskBuilder<T> builder) {
        PromiseTask<T> futureTask = PromiseTask.ofBuilder(builder, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    @Override
    public <T> IFuture<T> submit(Callable<T> task) {
        PromiseTask<T> futureTask = PromiseTask.ofFunction(task, null, 0, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    public <V> IFuture<V> submitFunc(Callable<? extends V> task) {
        PromiseTask<V> futureTask = PromiseTask.ofFunction(task, null, 0, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    public <V> IFuture<V> submitFunc(Callable<? extends V> task, int options) {
        PromiseTask<V> futureTask = PromiseTask.ofFunction(task, null, options, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    public <V> IFuture<V> submitFunc(Function<? super IContext, ? extends V> task, IContext ctx) {
        PromiseTask<V> futureTask = PromiseTask.ofFunction(task, ctx, 0, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    public <V> IFuture<V> submitFunc(Function<? super IContext, ? extends V> task, IContext ctx, int options) {
        PromiseTask<V> futureTask = PromiseTask.ofFunction(task, ctx, options, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    @Override
    public IFuture<?> submitAction(Runnable task) {
        PromiseTask<?> futureTask = PromiseTask.ofAction(task, null, 0, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    @Override
    public IFuture<?> submitAction(Runnable task, int options) {
        PromiseTask<?> futureTask = PromiseTask.ofAction(task, null, options, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    @Override
    public IFuture<?> submitAction(Consumer<? super IContext> task, IContext ctx) {
        PromiseTask<?> futureTask = PromiseTask.ofAction(task, ctx, 0, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    @Override
    public IFuture<?> submitAction(Consumer<? super IContext> task, IContext ctx, int options) {
        PromiseTask<?> futureTask = PromiseTask.ofAction(task, ctx, options, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    protected static void safeExecute(Runnable task) {
        try {
            task.run();
        }
        catch (Throwable t) {
            if (t instanceof VirtualMachineError) {
                logger.error("A task raised an exception. Task: {}", (Object)task, (Object)t);
            }
            logger.warn("A task raised an exception. Task: {}", (Object)task, (Object)t);
        }
    }

    protected static void logCause(Throwable t) {
        if (t instanceof VirtualMachineError) {
            logger.error("A task raised an exception.", t);
        } else {
            logger.warn("A task raised an exception.", t);
        }
    }
}

