/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.sequential;

import cn.wjybxx.concurrent.IContext;
import cn.wjybxx.concurrent.IFuture;
import cn.wjybxx.concurrent.IScheduledFuture;
import cn.wjybxx.concurrent.IScheduledPromise;
import cn.wjybxx.concurrent.ScheduledTaskBuilder;
import cn.wjybxx.concurrent.TaskBuilder;
import cn.wjybxx.sequential.AbstractUniExecutor;
import cn.wjybxx.sequential.UniScheduledExecutor;
import cn.wjybxx.sequential.UniScheduledPromise;
import cn.wjybxx.sequential.UniScheduledPromiseTask;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

public abstract class AbstractUniScheduledExecutor
extends AbstractUniExecutor
implements UniScheduledExecutor {
    @Override
    public <V> IScheduledPromise<V> newScheduledPromise() {
        return new UniScheduledPromise(this);
    }

    @Override
    public <V> IScheduledFuture<V> schedule(ScheduledTaskBuilder<V> builder) {
        UniScheduledPromiseTask<V> promiseTask = UniScheduledPromiseTask.ofBuilder(builder, this.newScheduledPromise(), 0L, this.tickTime());
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public <V> IScheduledFuture<V> scheduleFunc(Function<? super IContext, V> task, IContext ctx, long delay, TimeUnit unit) {
        long triggerTime = UniScheduledPromiseTask.triggerTime(delay, unit, this.tickTime());
        UniScheduledPromiseTask<V> promiseTask = UniScheduledPromiseTask.ofFunction(task, ctx, 0, this.newScheduledPromise(), 0L, triggerTime);
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public IScheduledFuture<?> scheduleAction(Consumer<? super IContext> task, IContext ctx, long delay, TimeUnit unit) {
        long triggerTime = UniScheduledPromiseTask.triggerTime(delay, unit, this.tickTime());
        UniScheduledPromiseTask promiseTask = UniScheduledPromiseTask.ofAction(task, ctx, 0, this.newScheduledPromise(), 0L, triggerTime);
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public IScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) {
        long triggerTime = UniScheduledPromiseTask.triggerTime(delay, unit, this.tickTime());
        UniScheduledPromiseTask promiseTask = UniScheduledPromiseTask.ofAction(task, 0, this.newScheduledPromise(), 0L, triggerTime);
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public <V> IScheduledFuture<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
        long triggerTime = UniScheduledPromiseTask.triggerTime(delay, unit, this.tickTime());
        UniScheduledPromiseTask<V> promiseTask = UniScheduledPromiseTask.ofFunction(task, 0, this.newScheduledPromise(), 0L, triggerTime);
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public IScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        ScheduledTaskBuilder<?> builder = ScheduledTaskBuilder.newAction(task).setFixedRate(initialDelay, period, unit);
        UniScheduledPromiseTask<?> promiseTask = UniScheduledPromiseTask.ofBuilder(builder, this.newScheduledPromise(), 0L, this.tickTime());
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public IScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        ScheduledTaskBuilder<?> builder = ScheduledTaskBuilder.newAction(task).setFixedDelay(initialDelay, delay, unit);
        UniScheduledPromiseTask<?> promiseTask = UniScheduledPromiseTask.ofBuilder(builder, this.newScheduledPromise(), 0L, this.tickTime());
        this.execute(promiseTask);
        return promiseTask.future();
    }

    public <V> IFuture<V> submit(@Nonnull TaskBuilder<V> builder) {
        UniScheduledPromiseTask<V> promiseTask = UniScheduledPromiseTask.ofBuilder(builder, this.newScheduledPromise(), 0L, this.tickTime());
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public void execute(Consumer<? super IContext> action, IContext ctx) {
        UniScheduledPromiseTask promiseTask = UniScheduledPromiseTask.ofAction(action, ctx, 0, this.newScheduledPromise(), 0L, this.tickTime());
        this.execute(promiseTask);
    }

    @Override
    public void execute(Consumer<? super IContext> action, IContext ctx, int options) {
        UniScheduledPromiseTask promiseTask = UniScheduledPromiseTask.ofAction(action, ctx, options, this.newScheduledPromise(), 0L, this.tickTime());
        this.execute(promiseTask);
    }

    @Override
    public <T> IFuture<T> submit(Callable<T> task) {
        UniScheduledPromiseTask<T> promiseTask = UniScheduledPromiseTask.ofFunction(task, 0, this.newScheduledPromise(), 0L, this.tickTime());
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public <V> IFuture<V> submitFunc(Callable<? extends V> task) {
        UniScheduledPromiseTask<V> promiseTask = UniScheduledPromiseTask.ofFunction(task, 0, this.newScheduledPromise(), 0L, this.tickTime());
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public <V> IFuture<V> submitFunc(Callable<? extends V> task, int options) {
        UniScheduledPromiseTask<V> promiseTask = UniScheduledPromiseTask.ofFunction(task, options, this.newScheduledPromise(), 0L, this.tickTime());
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public <V> IFuture<V> submitFunc(Function<? super IContext, ? extends V> task, IContext ctx) {
        UniScheduledPromiseTask<V> promiseTask = UniScheduledPromiseTask.ofFunction(task, ctx, 0, this.newScheduledPromise(), 0L, this.tickTime());
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public <V> IFuture<V> submitFunc(Function<? super IContext, ? extends V> task, IContext ctx, int options) {
        UniScheduledPromiseTask<V> promiseTask = UniScheduledPromiseTask.ofFunction(task, ctx, options, this.newScheduledPromise(), 0L, this.tickTime());
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public IFuture<?> submitAction(Runnable task) {
        UniScheduledPromiseTask promiseTask = UniScheduledPromiseTask.ofAction(task, 0, this.newScheduledPromise(), 0L, this.tickTime());
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public IFuture<?> submitAction(Runnable task, int options) {
        UniScheduledPromiseTask promiseTask = UniScheduledPromiseTask.ofAction(task, options, this.newScheduledPromise(), 0L, this.tickTime());
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public IFuture<?> submitAction(Consumer<? super IContext> task, IContext ctx) {
        UniScheduledPromiseTask promiseTask = UniScheduledPromiseTask.ofAction(task, ctx, 0, this.newScheduledPromise(), 0L, this.tickTime());
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public IFuture<?> submitAction(Consumer<? super IContext> task, IContext ctx, int options) {
        UniScheduledPromiseTask promiseTask = UniScheduledPromiseTask.ofAction(task, ctx, options, this.newScheduledPromise(), 0L, this.tickTime());
        this.execute(promiseTask);
        return promiseTask.future();
    }

    protected abstract long tickTime();

    protected abstract void reSchedulePeriodic(UniScheduledPromiseTask<?> var1, boolean var2);

    protected abstract void removeScheduled(UniScheduledPromiseTask<?> var1);
}

