/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.sequential;

import cn.wjybxx.concurrent.BetterCancellationException;
import cn.wjybxx.concurrent.CancelCodes;
import cn.wjybxx.concurrent.CancelTokenListener;
import cn.wjybxx.concurrent.FutureLogger;
import cn.wjybxx.concurrent.ICancelToken;
import cn.wjybxx.concurrent.ICancelTokenSource;
import cn.wjybxx.concurrent.IContext;
import cn.wjybxx.concurrent.IExecutor;
import cn.wjybxx.concurrent.IRegistration;
import cn.wjybxx.concurrent.ITask;
import cn.wjybxx.concurrent.ReadonlyCancelToken;
import cn.wjybxx.concurrent.SingleThreadExecutor;
import cn.wjybxx.concurrent.TaskOption;
import cn.wjybxx.sequential.UniExecutorService;
import cn.wjybxx.sequential.UniPromise;
import cn.wjybxx.sequential.UniScheduledExecutor;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class UniCancelTokenSource
implements ICancelTokenSource {
    private int code;
    private Completion head;
    private Completion tail;
    private UniScheduledExecutor executor;
    private static final int SYNC = 0;
    private static final int ASYNC = 1;
    private static final int NESTED = -1;
    private static final Executor CLAIMED = UniPromise.CLAIMED;
    private static final Completion TOMBSTONE = new Completion(){

        @Override
        public UniCancelTokenSource tryFire(int mode) {
            return null;
        }
    };

    public UniCancelTokenSource() {
    }

    public UniCancelTokenSource(int code) {
        this(null, code);
    }

    public UniCancelTokenSource(UniScheduledExecutor executor) {
        this(executor, 0);
    }

    public UniCancelTokenSource(UniScheduledExecutor executor, int code) {
        this.executor = executor;
        if (code != 0) {
            this.code = CancelCodes.checkCode(code);
        }
    }

    public UniScheduledExecutor getExecutor() {
        return this.executor;
    }

    public UniCancelTokenSource setExecutor(UniScheduledExecutor executor) {
        this.executor = executor;
        return this;
    }

    public boolean unregister(Object action) {
        return this.unregister(action, false);
    }

    public boolean unregister(Object action, boolean firstOccurrence) {
        if (firstOccurrence) {
            Completion node = this.head;
            while (node != null) {
                if (node.action == action) {
                    node.close();
                    return true;
                }
                node = node.next;
            }
        } else {
            Completion node = this.tail;
            while (node != null) {
                if (node.action == action) {
                    node.close();
                    return true;
                }
                node = node.prev;
            }
        }
        return false;
    }

    public void reset() {
        Completion node;
        this.code = 0;
        while ((node = this.head) != null) {
            this.head = node.next;
            node.action = TOMBSTONE;
            node.clear();
        }
        this.tail = null;
    }

    @Override
    public ICancelToken asReadonly() {
        return new ReadonlyCancelToken(this);
    }

    @Override
    public boolean canBeCancelled() {
        return true;
    }

    @Override
    public UniCancelTokenSource newInstance(boolean copyCode) {
        return new UniCancelTokenSource(this.executor, copyCode ? this.code : 0);
    }

    public UniCancelTokenSource newChild() {
        UniCancelTokenSource child = new UniCancelTokenSource(this.executor, this.code);
        if (this.code == 0) {
            this.thenTransferTo(child);
        }
        return child;
    }

    @Override
    public int cancel(int cancelCode) {
        CancelCodes.checkCode(cancelCode);
        int preCode = this.internalCancel(cancelCode);
        if (preCode != 0) {
            return preCode;
        }
        UniCancelTokenSource.postComplete(this);
        return 0;
    }

    @Override
    public int cancel() {
        return this.cancel(1);
    }

    @Override
    public void cancelAfter(int cancelCode, long millisecondsDelay) {
        this.cancelAfter(cancelCode, millisecondsDelay, TimeUnit.MILLISECONDS, this.executor);
    }

    @Override
    public void cancelAfter(int cancelCode, long delay, TimeUnit timeUnit) {
        this.cancelAfter(cancelCode, delay, timeUnit, this.executor);
    }

    public void cancelAfter(int cancelCode, long delay, TimeUnit timeUnit, UniScheduledExecutor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("delayer is null");
        }
        if (this.code == 0) {
            Canceller canceller = new Canceller(this, cancelCode);
            executor.scheduleAction(canceller, canceller, delay, timeUnit);
        }
    }

    @Override
    public int cancelCode() {
        return this.code;
    }

    @Override
    public boolean isCancelling() {
        return this.code != 0;
    }

    @Override
    public int reason() {
        return CancelCodes.getReason(this.code);
    }

    @Override
    public int degree() {
        return CancelCodes.getDegree(this.code);
    }

    @Override
    public boolean isInterruptible() {
        return CancelCodes.isInterruptible(this.code);
    }

    @Override
    public boolean isWithoutRemove() {
        return CancelCodes.isWithoutRemove(this.code);
    }

    @Override
    public void checkCancel() {
        int code = this.code;
        if (code != 0) {
            throw new BetterCancellationException(code);
        }
    }

    @Override
    public IRegistration thenAccept(Consumer<? super ICancelToken> action, int options) {
        return this.uniAccept(null, action, options);
    }

    @Override
    public IRegistration thenAccept(Consumer<? super ICancelToken> action) {
        return this.uniAccept(null, action, 0);
    }

    @Override
    public IRegistration thenAcceptAsync(Executor executor, Consumer<? super ICancelToken> action) {
        Objects.requireNonNull(executor, "executor");
        return this.uniAccept(executor, action, 0);
    }

    @Override
    public IRegistration thenAcceptAsync(Executor executor, Consumer<? super ICancelToken> action, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniAccept(executor, action, options);
    }

    private IRegistration uniAccept(Executor executor, Consumer<? super ICancelToken> action, int options) {
        Objects.requireNonNull(action);
        if (this.isCancelling() && executor == null) {
            UniAccept.fireNow(this, action);
            return TOMBSTONE;
        }
        UniAccept completion = new UniAccept(executor, options, this, action);
        return this.pushCompletion(completion) ? completion : TOMBSTONE;
    }

    @Override
    public IRegistration thenAccept(BiConsumer<? super ICancelToken, Object> action, Object ctx, int options) {
        return this.uniAcceptCtx(null, action, ctx, options);
    }

    @Override
    public IRegistration thenAccept(BiConsumer<? super ICancelToken, Object> action, Object ctx) {
        return this.uniAcceptCtx(null, action, ctx, 0);
    }

    @Override
    public IRegistration thenAcceptAsync(Executor executor, BiConsumer<? super ICancelToken, Object> action, Object ctx) {
        Objects.requireNonNull(executor, "executor");
        return this.uniAcceptCtx(executor, action, ctx, 0);
    }

    @Override
    public IRegistration thenAcceptAsync(Executor executor, BiConsumer<? super ICancelToken, Object> action, Object ctx, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniAcceptCtx(executor, action, ctx, options);
    }

    private IRegistration uniAcceptCtx(Executor executor, BiConsumer<? super ICancelToken, Object> action, Object ctx, int options) {
        Objects.requireNonNull(action);
        if (this.isCancelling() && executor == null) {
            UniAcceptCtx.fireNow(this, action, ctx);
            return TOMBSTONE;
        }
        UniAcceptCtx completion = new UniAcceptCtx(executor, options, this, action, ctx);
        return this.pushCompletion(completion) ? completion : TOMBSTONE;
    }

    @Override
    public IRegistration thenRun(Runnable action, int options) {
        return this.uniRun(null, action, options);
    }

    @Override
    public IRegistration thenRun(Runnable action) {
        return this.uniRun(null, action, 0);
    }

    @Override
    public IRegistration thenRunAsync(Executor executor, Runnable action) {
        Objects.requireNonNull(executor, "executor");
        return this.uniRun(executor, action, 0);
    }

    @Override
    public IRegistration thenRunAsync(Executor executor, Runnable action, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniRun(executor, action, options);
    }

    private IRegistration uniRun(Executor executor, Runnable action, int options) {
        Objects.requireNonNull(action);
        if (this.isCancelling() && executor == null) {
            UniRun.fireNow(action);
            return TOMBSTONE;
        }
        UniRun completion = new UniRun(executor, options, this, action);
        return this.pushCompletion(completion) ? completion : TOMBSTONE;
    }

    @Override
    public IRegistration thenRun(Consumer<Object> action, Object ctx, int options) {
        return this.uniRunCtx(null, action, ctx, options);
    }

    @Override
    public IRegistration thenRun(Consumer<Object> action, Object ctx) {
        return this.uniRunCtx(null, action, ctx, 0);
    }

    @Override
    public IRegistration thenRunAsync(Executor executor, Consumer<Object> action, Object ctx) {
        Objects.requireNonNull(executor, "executor");
        return this.uniRunCtx(executor, action, ctx, 0);
    }

    @Override
    public IRegistration thenRunAsync(Executor executor, Consumer<Object> action, Object ctx, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniRunCtx(executor, action, ctx, options);
    }

    private IRegistration uniRunCtx(Executor executor, Consumer<Object> action, Object ctx, int options) {
        Objects.requireNonNull(action);
        if (this.isCancelling() && executor == null) {
            UniRunCtx.fireNow(action, ctx);
            return TOMBSTONE;
        }
        UniRunCtx completion = new UniRunCtx(executor, options, this, action, ctx);
        return this.pushCompletion(completion) ? completion : TOMBSTONE;
    }

    @Override
    public IRegistration thenNotify(CancelTokenListener action, int options) {
        return this.uniNotify(null, action, options);
    }

    @Override
    public IRegistration thenNotify(CancelTokenListener action) {
        return this.uniNotify(null, action, 0);
    }

    @Override
    public IRegistration thenNotifyAsync(Executor executor, CancelTokenListener action) {
        Objects.requireNonNull(executor, "executor");
        return this.uniNotify(executor, action, 0);
    }

    @Override
    public IRegistration thenNotifyAsync(Executor executor, CancelTokenListener action, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniNotify(executor, action, options);
    }

    private IRegistration uniNotify(Executor executor, CancelTokenListener action, int options) {
        if (this.isCancelling() && executor == null) {
            UniNotify.fireNow(this, action);
            return TOMBSTONE;
        }
        UniNotify completion = new UniNotify(executor, options, this, action);
        return this.pushCompletion(completion) ? completion : TOMBSTONE;
    }

    @Override
    public IRegistration thenTransferTo(ICancelTokenSource child) {
        return this.uniTransferTo(null, child, 0);
    }

    @Override
    public IRegistration thenTransferTo(ICancelTokenSource child, int options) {
        return this.uniTransferTo(null, child, options);
    }

    @Override
    public IRegistration thenTransferToAsync(Executor executor, ICancelTokenSource child) {
        Objects.requireNonNull(executor, "executor");
        return this.uniTransferTo(executor, child, 0);
    }

    @Override
    public IRegistration thenTransferToAsync(Executor executor, ICancelTokenSource child, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniTransferTo(executor, child, options);
    }

    private IRegistration uniTransferTo(Executor executor, ICancelTokenSource child, int options) {
        Objects.requireNonNull(child, "child");
        if (this.isCancelling() && executor == null) {
            UniTransferTo.fireNow(this, 0, child);
            return TOMBSTONE;
        }
        UniTransferTo completion = new UniTransferTo(executor, options, this, child);
        return this.pushCompletion(completion) ? completion : TOMBSTONE;
    }

    private int internalCancel(int cancelCode) {
        int preCode = this.code;
        if (preCode == 0) {
            this.code = cancelCode;
            return 0;
        }
        return preCode;
    }

    private void removeNode(Completion node) {
        if (this.head == this.tail) {
            assert (this.head == node);
            this.tail = null;
            this.head = null;
        } else if (node == this.head) {
            this.head = node.next;
            this.head.prev = null;
        } else if (node == this.tail) {
            this.tail = node.prev;
            this.tail.next = null;
        } else {
            Completion next;
            Completion prev = node.prev;
            prev.next = next = node.next;
            next.prev = prev;
        }
    }

    private Completion popListener() {
        Completion head = this.head;
        if (head == null) {
            return null;
        }
        if (head == this.tail) {
            this.tail = null;
            this.head = null;
        } else {
            this.head = head.next;
            this.head.prev = null;
        }
        return head;
    }

    private boolean pushCompletion(Completion node) {
        if (this.isCancelling()) {
            node.tryFire(0);
            return false;
        }
        Completion tail = this.tail;
        if (tail == null) {
            this.head = this.tail = node;
        } else {
            tail.next = node;
            node.prev = tail;
            this.tail = node;
        }
        return true;
    }

    private static void postComplete(UniCancelTokenSource source) {
        Completion next;
        while ((next = source.popListener()) != null) {
            UniCancelTokenSource child = next.tryFire(-1);
            if (child == null) continue;
            UniCancelTokenSource.postComplete(child);
        }
    }

    private static boolean tryInline(Completion completion, Executor e, int options) {
        if (TaskOption.isEnabled(options, 524288)) {
            SingleThreadExecutor eventLoop;
            if (e instanceof UniExecutorService) {
                return true;
            }
            if (e instanceof SingleThreadExecutor && (eventLoop = (SingleThreadExecutor)e).inEventLoop()) {
                return true;
            }
        }
        if (options != 0 && !TaskOption.isEnabled(options, 0x100000) && e instanceof IExecutor) {
            IExecutor exe = (IExecutor)e;
            exe.execute(completion);
        } else {
            completion.setOptions(0);
            e.execute(completion);
        }
        return false;
    }

    private static abstract class Completion
    implements IRegistration,
    ITask {
        UniCancelTokenSource source;
        Completion next;
        Completion prev;
        Executor executor;
        int options;
        Object action;

        public Completion() {
            this.source = null;
        }

        public Completion(Executor executor, int options, UniCancelTokenSource source, Object action) {
            this.executor = executor;
            this.options = options;
            this.source = source;
            this.action = action;
        }

        @Override
        public int getOptions() {
            return this.options;
        }

        public void setOptions(int options) {
            this.options = options;
        }

        @Override
        public final void run() {
            this.tryFire(1);
        }

        public abstract UniCancelTokenSource tryFire(int var1);

        public final boolean claim() {
            Executor e = this.executor;
            if (e == CLAIMED) {
                return true;
            }
            this.executor = CLAIMED;
            if (e == null) {
                return true;
            }
            return UniCancelTokenSource.tryInline(this, e, this.options);
        }

        @Nullable
        protected final Object popAction() {
            Object action = this.action;
            if (action == TOMBSTONE) {
                return null;
            }
            this.action = TOMBSTONE;
            return action;
        }

        @Override
        public final void close() {
            Object action = this.popAction();
            if (action == null) {
                return;
            }
            this.source.removeNode(this);
            this.clear();
        }

        protected void clear() {
            this.source = null;
            this.prev = null;
            this.next = null;
            this.executor = null;
        }

        protected boolean isCancelling(Object ctx) {
            IContext ctx2;
            return TaskOption.isEnabled(this.options, 0x200000) && ctx instanceof IContext && (ctx2 = (IContext)ctx).cancelToken().isCancelling();
        }
    }

    private static class Canceller
    implements Consumer<Object>,
    IContext {
        final UniCancelTokenSource source;
        final int cancelCode;

        private Canceller(UniCancelTokenSource source, int cancelCode) {
            this.source = source;
            this.cancelCode = cancelCode;
        }

        @Override
        public void accept(Object tokenOrSelf) {
            if (tokenOrSelf == this) {
                this.source.cancel(this.cancelCode);
            }
        }

        @Override
        public Object state() {
            return null;
        }

        @Override
        @Nonnull
        public ICancelToken cancelToken() {
            return this.source;
        }

        @Override
        public Object blackboard() {
            return null;
        }

        @Override
        public Object sharedProps() {
            return null;
        }
    }

    private static class UniAccept
    extends Completion {
        public UniAccept(Executor executor, int options, UniCancelTokenSource source, Consumer<? super ICancelToken> action) {
            super(executor, options, source, action);
        }

        @Override
        public UniCancelTokenSource tryFire(int mode) {
            try {
                if (mode <= 0 && !this.claim()) {
                    return null;
                }
                Consumer action = (Consumer)this.popAction();
                if (action == null) {
                    return null;
                }
                action.accept(this.source);
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniAccept caught an exception");
            }
            this.clear();
            return null;
        }

        static void fireNow(UniCancelTokenSource source, Consumer<? super ICancelToken> action) {
            try {
                action.accept(source);
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniAccept caught an exception");
            }
        }
    }

    private static class UniAcceptCtx
    extends Completion {
        Object ctx;

        public UniAcceptCtx(Executor executor, int options, UniCancelTokenSource source, BiConsumer<? super ICancelToken, Object> action, Object ctx) {
            super(executor, options, source, action);
            this.ctx = ctx;
        }

        @Override
        protected void clear() {
            super.clear();
            this.ctx = null;
        }

        @Override
        public UniCancelTokenSource tryFire(int mode) {
            try {
                if (mode <= 0 && !this.claim()) {
                    return null;
                }
                BiConsumer action = (BiConsumer)this.popAction();
                if (action == null) {
                    return null;
                }
                if (!this.isCancelling(this.ctx)) {
                    action.accept(this.source, this.ctx);
                }
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniAcceptCtx caught an exception");
            }
            this.clear();
            return null;
        }

        static void fireNow(UniCancelTokenSource source, BiConsumer<? super ICancelToken, Object> action, Object ctx) {
            try {
                action.accept(source, ctx);
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniAcceptCtx caught an exception");
            }
        }
    }

    private static class UniRun
    extends Completion {
        public UniRun(Executor executor, int options, UniCancelTokenSource source, Runnable action) {
            super(executor, options, source, action);
        }

        @Override
        public UniCancelTokenSource tryFire(int mode) {
            try {
                if (mode <= 0 && !this.claim()) {
                    return null;
                }
                Runnable action = (Runnable)this.popAction();
                if (action == null) {
                    return null;
                }
                action.run();
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniRun caught an exception");
            }
            this.clear();
            return null;
        }

        static void fireNow(Runnable action) {
            try {
                action.run();
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniRun caught an exception");
            }
        }
    }

    private static class UniRunCtx
    extends Completion {
        Object ctx;

        public UniRunCtx(Executor executor, int options, UniCancelTokenSource source, Consumer<Object> action, Object ctx) {
            super(executor, options, source, action);
            this.ctx = ctx;
        }

        @Override
        protected void clear() {
            super.clear();
            this.ctx = null;
        }

        @Override
        public UniCancelTokenSource tryFire(int mode) {
            try {
                if (mode <= 0 && !this.claim()) {
                    return null;
                }
                Consumer action = (Consumer)this.popAction();
                if (action == null) {
                    return null;
                }
                if (!this.isCancelling(this.ctx)) {
                    action.accept(this.ctx);
                }
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniRunCtx caught an exception");
            }
            this.clear();
            return null;
        }

        static void fireNow(Consumer<Object> action, Object ctx) {
            try {
                action.accept(ctx);
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniRunCtx caught an exception");
            }
        }
    }

    private static class UniNotify
    extends Completion {
        public UniNotify(Executor executor, int options, UniCancelTokenSource source, CancelTokenListener action) {
            super(executor, options, source, action);
        }

        @Override
        public UniCancelTokenSource tryFire(int mode) {
            try {
                if (mode <= 0 && !this.claim()) {
                    return null;
                }
                CancelTokenListener action = (CancelTokenListener)this.popAction();
                if (action == null) {
                    return null;
                }
                action.onCancelRequested(this.source);
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniNotify caught an exception");
            }
            this.clear();
            return null;
        }

        static void fireNow(UniCancelTokenSource source, CancelTokenListener action) {
            try {
                action.onCancelRequested(source);
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniNotify caught an exception");
            }
        }
    }

    private static class UniTransferTo
    extends Completion {
        public UniTransferTo(Executor executor, int options, UniCancelTokenSource source, ICancelTokenSource action) {
            super(executor, options, source, action);
        }

        @Override
        public UniCancelTokenSource tryFire(int mode) {
            UniCancelTokenSource output;
            try {
                if (mode <= 0 && !this.claim()) {
                    return null;
                }
                ICancelTokenSource child = (ICancelTokenSource)this.popAction();
                if (child == null) {
                    return null;
                }
                output = UniTransferTo.fireNow(this.source, mode, child);
            }
            catch (Throwable ex) {
                output = null;
                FutureLogger.logCause(ex, "UniTransferTo caught an exception");
            }
            this.clear();
            return output;
        }

        static UniCancelTokenSource fireNow(UniCancelTokenSource source, int mode, ICancelTokenSource child) {
            if (!(child instanceof UniCancelTokenSource)) {
                child.cancel(source.code);
                return null;
            }
            UniCancelTokenSource childSource = (UniCancelTokenSource)child;
            if (childSource.internalCancel(source.code) == 0) {
                if (mode < 0) {
                    return childSource;
                }
                UniCancelTokenSource.postComplete(childSource);
                return null;
            }
            return null;
        }
    }
}

