/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.concurrent.ForwardFuture;
import cn.wjybxx.concurrent.IExecutorService;
import cn.wjybxx.concurrent.IPromise;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;

public final class ExecutorServiceAdapter
extends AbstractExecutorService {
    public final IExecutorService eventLoop;

    public ExecutorServiceAdapter(IExecutorService eventLoop) {
        this.eventLoop = eventLoop;
    }

    @Override
    public void execute(Runnable command) {
        this.eventLoop.execute(command);
    }

    @Override
    public void shutdown() {
        this.eventLoop.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.eventLoop.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.eventLoop.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.eventLoop.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.eventLoop.awaitTermination(timeout, unit);
    }

    @Override
    public void close() {
        this.eventLoop.close();
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new RunnableFutureAdapter(this.eventLoop.newPromise(), Executors.callable(runnable, value));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new RunnableFutureAdapter(this.eventLoop.newPromise(), callable);
    }

    private static class RunnableFutureAdapter<V>
    extends ForwardFuture<V>
    implements RunnableFuture<V> {
        final IPromise<V> promise;
        final Callable<? extends V> task;

        public RunnableFutureAdapter(IPromise<V> promise, Callable<? extends V> task) {
            super(promise);
            this.promise = promise;
            this.task = task;
        }

        @Override
        public void run() {
            IPromise<V> promise = this.promise;
            if (promise.trySetComputing()) {
                try {
                    V result = this.task.call();
                    promise.trySetResult(result);
                }
                catch (Throwable e) {
                    promise.trySetException(e);
                }
            }
        }
    }
}

