/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.base.ex.NoLogRequiredException;
import cn.wjybxx.concurrent.Promise;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public final class FutureLogger {
    private static final Logger logger = LoggerFactory.getLogger(Promise.class);
    private static volatile Level logLevel = Level.INFO;
    private static volatile LogHandler handler;
    private static final Set<Class<?>> noLogRequiredExceptions;

    public static Level getLogLevel() {
        return logLevel;
    }

    public static void setLogLevel(Level logLevel) {
        FutureLogger.logLevel = Objects.requireNonNull(logLevel);
    }

    public static LogHandler getHandler() {
        return handler;
    }

    public static void setHandler(LogHandler handler) {
        FutureLogger.handler = handler;
    }

    public static void addNoLogRequiredException(Class<? extends Throwable> ex) {
        FutureLogger.checkExceptionClass(ex);
        noLogRequiredExceptions.add(ex);
    }

    public static void addNoLogRequiredExceptions(Collection<? extends Class<? extends Throwable>> classes) {
        Objects.requireNonNull(classes);
        for (Class<? extends Throwable> clazz : classes) {
            FutureLogger.checkExceptionClass(clazz);
        }
        noLogRequiredExceptions.addAll(classes);
    }

    public static boolean removeNoLogRequiredException(Class<? extends Throwable> ex) {
        Objects.requireNonNull(ex);
        return noLogRequiredExceptions.remove(ex);
    }

    private static void checkExceptionClass(Class<? extends Throwable> ex) {
        Objects.requireNonNull(ex);
        if (!Throwable.class.isAssignableFrom(ex)) {
            throw new IllegalArgumentException();
        }
    }

    private static boolean testException(Throwable x) {
        if (x == null) {
            return false;
        }
        return !(x instanceof CancellationException) && !(x instanceof TimeoutException) && !(x instanceof NoLogRequiredException) && !noLogRequiredExceptions.contains(x.getClass());
    }

    public static void logCause(Throwable ex) {
        FutureLogger.logCause(ex, null);
    }

    public static void logCause(Throwable ex, String message) {
        Level logLevel;
        Objects.requireNonNull(ex);
        if (message == null) {
            message = "future completed with exception";
        }
        Level level = logLevel = ex instanceof VirtualMachineError ? Level.ERROR : FutureLogger.logLevel;
        if (!logger.isEnabledForLevel(logLevel) || !FutureLogger.testException(ex)) {
            return;
        }
        try {
            LogHandler handler = FutureLogger.handler;
            if (handler != null) {
                handler.logCause(logLevel, ex, message);
                return;
            }
            switch (logLevel) {
                case TRACE: {
                    logger.trace(message, ex);
                    break;
                }
                case DEBUG: {
                    logger.debug(message, ex);
                    break;
                }
                case INFO: {
                    logger.info(message, ex);
                    break;
                }
                case WARN: {
                    logger.warn(message, ex);
                    break;
                }
                case ERROR: {
                    logger.error(message, ex);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        noLogRequiredExceptions = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    @FunctionalInterface
    public static interface LogHandler {
        public void logCause(Level var1, Throwable var2, String var3);
    }
}

