/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.base.IRegistration;
import cn.wjybxx.base.concurrent.BetterCancellationException;
import cn.wjybxx.base.concurrent.CancelCodes;
import cn.wjybxx.concurrent.CancelTokenListener;
import cn.wjybxx.concurrent.ICancelTokenSource;
import cn.wjybxx.concurrent.UncancellableToken;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public interface ICancelToken {
    public static final ICancelToken NONE = UncancellableToken.INST;

    public ICancelToken asReadonly();

    public boolean canBeCancelled();

    public int cancelCode();

    default public boolean isCancelling() {
        return this.cancelCode() != 0;
    }

    default public int reason() {
        return CancelCodes.getReason((int)this.cancelCode());
    }

    default public int degree() {
        return CancelCodes.getDegree((int)this.cancelCode());
    }

    default public boolean isInterruptible() {
        return CancelCodes.isInterruptible((int)this.cancelCode());
    }

    default public boolean isWithoutRemove() {
        return CancelCodes.isWithoutRemove((int)this.cancelCode());
    }

    default public void checkCancel() {
        int code = this.cancelCode();
        if (code != 0) {
            throw new BetterCancellationException(code);
        }
    }

    public IRegistration thenAccept(Consumer<? super ICancelToken> var1, int var2);

    public IRegistration thenAccept(Consumer<? super ICancelToken> var1);

    public IRegistration thenAcceptAsync(Executor var1, Consumer<? super ICancelToken> var2);

    public IRegistration thenAcceptAsync(Executor var1, Consumer<? super ICancelToken> var2, int var3);

    public IRegistration thenAccept(BiConsumer<? super ICancelToken, Object> var1, Object var2, int var3);

    public IRegistration thenAccept(BiConsumer<? super ICancelToken, Object> var1, Object var2);

    public IRegistration thenAcceptAsync(Executor var1, BiConsumer<? super ICancelToken, Object> var2, Object var3);

    public IRegistration thenAcceptAsync(Executor var1, BiConsumer<? super ICancelToken, Object> var2, Object var3, int var4);

    public IRegistration thenRun(Runnable var1, int var2);

    public IRegistration thenRun(Runnable var1);

    public IRegistration thenRunAsync(Executor var1, Runnable var2);

    public IRegistration thenRunAsync(Executor var1, Runnable var2, int var3);

    public IRegistration thenRun(Consumer<Object> var1, Object var2, int var3);

    public IRegistration thenRun(Consumer<Object> var1, Object var2);

    public IRegistration thenRunAsync(Executor var1, Consumer<Object> var2, Object var3);

    public IRegistration thenRunAsync(Executor var1, Consumer<Object> var2, Object var3, int var4);

    public IRegistration thenNotify(CancelTokenListener var1, int var2);

    public IRegistration thenNotify(CancelTokenListener var1);

    public IRegistration thenNotifyAsync(Executor var1, CancelTokenListener var2);

    public IRegistration thenNotifyAsync(Executor var1, CancelTokenListener var2, int var3);

    public IRegistration thenTransferTo(ICancelTokenSource var1, int var2);

    public IRegistration thenTransferTo(ICancelTokenSource var1);

    public IRegistration thenTransferToAsync(Executor var1, ICancelTokenSource var2);

    public IRegistration thenTransferToAsync(Executor var1, ICancelTokenSource var2, int var3);
}

