/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.concurrent.IContext;
import cn.wjybxx.concurrent.IExecutor;
import cn.wjybxx.concurrent.IFuture;
import cn.wjybxx.concurrent.IPromise;
import cn.wjybxx.concurrent.Promise;
import cn.wjybxx.concurrent.TaskBuilder;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

public interface IExecutorService
extends ExecutorService,
IExecutor {
    public boolean isShuttingDown();

    @Override
    public boolean isShutdown();

    @Override
    public boolean isTerminated();

    public IFuture<?> terminationFuture();

    @Override
    public boolean awaitTermination(long var1, TimeUnit var3) throws InterruptedException;

    @Override
    public void shutdown();

    @Override
    public List<Runnable> shutdownNow();

    default public <T> IPromise<T> newPromise() {
        return new Promise(this);
    }

    public <T> IFuture<T> submit(@Nonnull TaskBuilder<T> var1);

    public <T> IFuture<T> submit(@Nonnull Callable<T> var1);

    public <T> IFuture<T> submitFunc(Callable<? extends T> var1);

    public <T> IFuture<T> submitFunc(Callable<? extends T> var1, int var2);

    public <T> IFuture<T> submitFunc(Function<? super IContext, ? extends T> var1, IContext var2);

    public <T> IFuture<T> submitFunc(Function<? super IContext, ? extends T> var1, IContext var2, int var3);

    public IFuture<?> submitAction(Runnable var1);

    public IFuture<?> submitAction(Runnable var1, int var2);

    public IFuture<?> submitAction(Consumer<? super IContext> var1, IContext var2);

    public IFuture<?> submitAction(Consumer<? super IContext> var1, IContext var2, int var3);

    @Deprecated
    default public IFuture<?> submit(@Nonnull Runnable task) {
        return this.submitAction(task);
    }

    @Deprecated
    default public <T> IFuture<T> submit(@Nonnull Runnable task, T result) {
        return this.submitFunc(Executors.callable(task, result));
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> var1) throws InterruptedException;

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> var1, long var2, TimeUnit var4) throws InterruptedException;

    @Override
    @Nonnull
    public <T> T invokeAny(Collection<? extends Callable<T>> var1) throws InterruptedException, ExecutionException;

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> var1, long var2, TimeUnit var4) throws InterruptedException, ExecutionException, TimeoutException;
}

