/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RejectedExecutionHandlers {
    private static final Logger logger = LoggerFactory.getLogger(RejectedExecutionHandlers.class);
    private static final RejectedExecutionHandler ABORT_POLICY = (r, eventLoop) -> {
        throw new RejectedExecutionException();
    };
    private static final RejectedExecutionHandler CALLER_RUNS_POLICY = (r, eventLoop) -> {
        if (!eventLoop.isShuttingDown()) {
            r.run();
        }
    };
    private static final RejectedExecutionHandler DISCARD_POLICY = (r, eventLoop) -> {};
    private static final RejectedExecutionHandler RECORD_POLICY = (r, eventLoop) -> logger.info("task {} is reject by {}.", (Object)r.getClass().getCanonicalName(), (Object)eventLoop.getClass().getCanonicalName());

    private RejectedExecutionHandlers() {
    }

    public static RejectedExecutionHandler abort() {
        return ABORT_POLICY;
    }

    public static RejectedExecutionHandler callerRuns() {
        return CALLER_RUNS_POLICY;
    }

    public static RejectedExecutionHandler discard() {
        return DISCARD_POLICY;
    }

    public static RejectedExecutionHandler record() {
        return RECORD_POLICY;
    }
}

