/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.base.IRegistration;
import cn.wjybxx.base.ThreadUtils;
import cn.wjybxx.base.collection.IndexedElement;
import cn.wjybxx.base.concurrent.StacklessCancellationException;
import cn.wjybxx.concurrent.AbstractScheduledEventLoop;
import cn.wjybxx.concurrent.CancelTokenListener;
import cn.wjybxx.concurrent.FutureLogger;
import cn.wjybxx.concurrent.ICancelToken;
import cn.wjybxx.concurrent.IContext;
import cn.wjybxx.concurrent.IPromise;
import cn.wjybxx.concurrent.IScheduledFutureTask;
import cn.wjybxx.concurrent.IScheduledPromise;
import cn.wjybxx.concurrent.PromiseTask;
import cn.wjybxx.concurrent.ScheduledTaskBuilder;
import cn.wjybxx.concurrent.TaskBuilder;
import cn.wjybxx.concurrent.TaskOption;
import cn.wjybxx.concurrent.TimeoutContext;
import cn.wjybxx.disruptor.StacklessTimeoutException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

public final class ScheduledPromiseTask<V>
extends PromiseTask<V>
implements IScheduledFutureTask<V>,
IndexedElement,
Consumer<Object>,
CancelTokenListener {
    private long id;
    private long nextTriggerTime;
    private long period;
    private TimeoutContext timeoutContext;
    private int queueIndex = -1;
    private IRegistration cancelRegistration;

    private ScheduledPromiseTask(ScheduledTaskBuilder<V> builder, IScheduledPromise<V> promise, long id, long nextTriggerTime, long period, TimeoutContext timeoutContext) {
        super(builder, promise);
        this.id = id;
        this.nextTriggerTime = nextTriggerTime;
        this.period = period;
        this.timeoutContext = timeoutContext;
        this.setScheduleType(builder.getScheduleType());
        promise.setTask(this);
    }

    private ScheduledPromiseTask(Object action, IContext ctx, int options, IScheduledPromise<V> promise, int taskType, long id, long nextTriggerTime) {
        super(action, ctx, options, promise, taskType);
        this.id = id;
        this.nextTriggerTime = nextTriggerTime;
        this.period = 0L;
        promise.setTask(this);
    }

    public static ScheduledPromiseTask<?> ofAction(Runnable action, IContext ctx, int options, IScheduledPromise<?> promise, long id, long nextTriggerTime) {
        return new ScheduledPromiseTask(action, ctx, options, promise, 0, id, nextTriggerTime);
    }

    public static ScheduledPromiseTask<?> ofAction(Consumer<? super IContext> action, IContext ctx, int options, IScheduledPromise<?> promise, long id, long nextTriggerTime) {
        return new ScheduledPromiseTask(action, ctx, options, promise, 1, id, nextTriggerTime);
    }

    public static <V> ScheduledPromiseTask<V> ofFunction(Callable<? extends V> action, IContext ctx, int options, IScheduledPromise<V> promise, long id, long nextTriggerTime) {
        return new ScheduledPromiseTask<V>(action, ctx, options, promise, 2, id, nextTriggerTime);
    }

    public static <V> ScheduledPromiseTask<V> ofFunction(Function<? super IContext, ? extends V> action, IContext ctx, int options, IScheduledPromise<V> promise, long id, long nextTriggerTime) {
        return new ScheduledPromiseTask<V>(action, ctx, options, promise, 3, id, nextTriggerTime);
    }

    public static <V> ScheduledPromiseTask<V> ofBuilder(TaskBuilder<V> builder, IScheduledPromise<V> promise, long id, long tickTime) {
        if (builder instanceof ScheduledTaskBuilder) {
            ScheduledTaskBuilder sb = (ScheduledTaskBuilder)builder;
            return ScheduledPromiseTask.ofBuilder(sb, promise, id, tickTime);
        }
        return new ScheduledPromiseTask<V>(builder.getTask(), builder.getCtx(), builder.getOptions(), promise, builder.getType(), id, tickTime);
    }

    public static <V> ScheduledPromiseTask<V> ofBuilder(ScheduledTaskBuilder<V> builder, IScheduledPromise<V> promise, long id, long tickTime) {
        TimeoutContext timeoutContext;
        TimeUnit timeUnit = builder.getTimeUnit();
        long initialDelay = Math.max(0L, timeUnit.toNanos(builder.getInitialDelay()));
        long period = Math.max(1L, timeUnit.toNanos(builder.getPeriod()));
        long triggerTime = tickTime + initialDelay;
        if (builder.isPeriodic() && builder.getTimeout() != -1L) {
            long timeout = timeUnit.toNanos(builder.getTimeout());
            timeoutContext = new TimeoutContext(timeout, tickTime);
        } else {
            timeoutContext = null;
        }
        return new ScheduledPromiseTask<V>(builder, promise, id, triggerTime, period, timeoutContext);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getNextTriggerTime() {
        return this.nextTriggerTime;
    }

    public void setNextTriggerTime(long nextTriggerTime) {
        this.nextTriggerTime = nextTriggerTime;
    }

    public int getScheduleType() {
        return (this.ctl & 0xF00) >> 8;
    }

    private void setScheduleType(int scheduleType) {
        this.ctl |= scheduleType << 8;
    }

    private boolean isClaimed() {
        return (this.ctl & 0x10000) != 0;
    }

    private void setClaimed() {
        this.ctl |= 0x10000;
    }

    public int getPriority() {
        return this.ctl & 0xF;
    }

    public void setPriority(int priority) {
        if (priority < 0 || priority > 15) {
            throw new IllegalArgumentException("priority: 15");
        }
        this.ctl &= 0xFFFFFFF0;
        this.ctl |= priority;
    }

    public void setTriggered() {
        this.ctl |= 0x200000;
    }

    public boolean isTriggered() {
        return (this.ctl & 0x200000) != 0;
    }

    public int collectionIndex(Object collection) {
        return this.queueIndex;
    }

    public void collectionIndex(Object collection, int index) {
        this.queueIndex = index;
    }

    @Override
    public IScheduledPromise<V> future() {
        return (IScheduledPromise)this.promise;
    }

    @Override
    public boolean isPeriodic() {
        return this.getScheduleType() != 0;
    }

    @Override
    public void clear() {
        super.clear();
        this.timeoutContext = null;
        this.closeRegistration();
    }

    private AbstractScheduledEventLoop eventLoop() {
        return (AbstractScheduledEventLoop)this.promise.executor();
    }

    @Override
    public void run() {
        AbstractScheduledEventLoop eventLoop = this.eventLoop();
        IPromise promise = this.promise;
        if (promise.isDone() || this.ctx.cancelToken().isCancelling()) {
            this.cancelWithoutRemove(1);
            return;
        }
        long tickTime = eventLoop.tickTime();
        if (tickTime < this.nextTriggerTime) {
            eventLoop.reschedulePeriodic(this, false);
            return;
        }
        if (this.trigger(tickTime)) {
            eventLoop.reschedulePeriodic(this, true);
        }
    }

    public boolean trigger(long tickTime) {
        this.setTriggered();
        int scheduleType = this.getScheduleType();
        if (scheduleType == 0) {
            super.run();
            return false;
        }
        IPromise promise = this.promise;
        IContext ctx = this.ctx;
        if (ctx.cancelToken().isCancelling()) {
            ScheduledPromiseTask.trySetCancelled(promise, ctx);
            this.clear();
            return false;
        }
        if (!this.isClaimed()) {
            if (!promise.trySetComputing()) {
                this.clear();
                return false;
            }
            this.setClaimed();
        } else if (!promise.isComputing()) {
            this.clear();
            return false;
        }
        TimeoutContext timeoutContext = this.timeoutContext;
        try {
            if (timeoutContext != null) {
                timeoutContext.beforeCall(tickTime, this.nextTriggerTime, scheduleType == 2);
                if (TaskOption.isEnabled(this.options, 65536) && timeoutContext.isTimeout()) {
                    promise.trySetException((Throwable)StacklessTimeoutException.INST);
                    this.clear();
                    return false;
                }
            }
            if (this.getTaskType() == 4) {
                this.runTimeSharing();
                if (promise.isDone()) {
                    this.clear();
                    return false;
                }
            } else {
                this.runTask();
            }
            if (ctx.cancelToken().isCancelling() || !promise.isComputing()) {
                ScheduledPromiseTask.trySetCancelled(promise, ctx);
                this.clear();
                return false;
            }
            if (timeoutContext != null && timeoutContext.isTimeout()) {
                promise.trySetException((Throwable)StacklessTimeoutException.INST);
                this.clear();
                return false;
            }
            this.setNextRunTime(tickTime, timeoutContext, scheduleType);
            return true;
        }
        catch (Throwable ex) {
            ThreadUtils.recoveryInterrupted((Throwable)ex);
            if (this.canCaughtException(ex)) {
                FutureLogger.logCause(ex, "periodic task caught exception");
                this.setNextRunTime(tickTime, timeoutContext, scheduleType);
                return true;
            }
            promise.trySetException(ex);
            this.clear();
            return false;
        }
    }

    private boolean canCaughtException(Throwable ex) {
        if (this.getScheduleType() == 0) {
            return false;
        }
        if (this.getTaskType() == 4) {
            return false;
        }
        return TaskOption.isEnabled(this.options, 32768);
    }

    private void setNextRunTime(long tickTime, TimeoutContext timeoutContext, int scheduleType) {
        long maxDelay;
        long l = maxDelay = timeoutContext != null ? timeoutContext.getTimeLeft() : Long.MAX_VALUE;
        this.nextTriggerTime = scheduleType == 2 ? (this.nextTriggerTime += Math.min(maxDelay, this.period)) : tickTime + Math.min(maxDelay, this.period);
    }

    public void cancelWithoutRemove() {
        this.cancelWithoutRemove(3);
    }

    public void cancelWithoutRemove(int code) {
        ScheduledPromiseTask.trySetCancelled(this.promise, this.ctx, code);
        this.clear();
    }

    public void registerCancellation() {
        if (!TaskOption.isEnabled(this.options, 131072)) {
            this.promise.onCompleted(this, 0);
        }
        ICancelToken cancelToken = this.ctx.cancelToken();
        if (this.cancelRegistration == null && cancelToken.canBeCancelled()) {
            this.cancelRegistration = cancelToken.thenNotify(this);
        }
    }

    @Override
    public void accept(Object futureOrToken) {
        CancellationException ex;
        if (this.promise.isCancelled() && !((ex = (CancellationException)this.promise.exceptionNow(false)) instanceof StacklessCancellationException)) {
            this.eventLoop().removeScheduled(this);
        }
    }

    @Override
    public void onCancelRequested(ICancelToken cancelToken) {
        if (this.promise.trySetCancelled(cancelToken.cancelCode()) && !cancelToken.isWithoutRemove()) {
            this.eventLoop().removeScheduled(this);
        }
    }

    private void closeRegistration() {
        IRegistration cancelRegistration = this.cancelRegistration;
        if (cancelRegistration != null) {
            this.cancelRegistration = null;
            cancelRegistration.close();
        }
    }

    public static long triggerTime(long delay, TimeUnit timeUnit, long tickTime) {
        long initialDelay = Math.max(0L, delay);
        return tickTime + timeUnit.toNanos(initialDelay);
    }

    @Override
    public long getDelay(@Nonnull TimeUnit unit) {
        long delay = Math.max(0L, this.nextTriggerTime - this.eventLoop().tickTime());
        return unit.convert(delay, TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(@Nonnull Delayed o) {
        return this.compareToExplicitly((ScheduledPromiseTask)o);
    }

    public int compareToExplicitly(ScheduledPromiseTask<?> other) {
        if (other == this) {
            return 0;
        }
        int r = Long.compare(this.nextTriggerTime, other.nextTriggerTime);
        if (r != 0) {
            return r;
        }
        r = Boolean.compare(this.isTriggered(), other.isTriggered());
        if (r != 0) {
            return r;
        }
        r = Long.compare(this.id, other.id);
        if (r == 0) {
            throw new IllegalStateException("lhs.id: %d, rhs.id: %d".formatted(this.id, other.id));
        }
        return r;
    }
}

