/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.base.ThreadUtils;
import cn.wjybxx.concurrent.WatcherMgr;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SimpleWatcherMgr<E>
implements WatcherMgr<E> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleWatcherMgr.class);
    private long p1;
    private long p2;
    private long p3;
    private long p4;
    private long p5;
    private long p6;
    private long p7;
    private long p8;
    private volatile WatcherMgr.Watcher<? super E> watcher;
    private long p9;
    private long p10;
    private long p11;
    private long p12;
    private long p13;
    private long p14;
    private long p15;
    private long p16;

    public WatcherMgr.Watcher<? super E> getWatcher() {
        return this.watcher;
    }

    @Override
    public synchronized void watch(WatcherMgr.Watcher<? super E> watcher) {
        this.watcher = Objects.requireNonNull(watcher);
    }

    @Override
    public synchronized boolean cancelWatch(WatcherMgr.Watcher<?> watcher) {
        if (watcher != null && watcher == this.watcher) {
            this.watcher = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean onEvent(@Nonnull E event) {
        WatcherMgr.Watcher<E> watcher = this.watcher;
        if (watcher == null) {
            return false;
        }
        boolean r = false;
        try {
            if (watcher.test(event) && this.cancelWatch(watcher)) {
                r = true;
                watcher.onEvent(event);
            }
        }
        catch (Throwable ex) {
            ThreadUtils.recoveryInterrupted((Throwable)ex);
            if (!r) {
                logger.error("Fatal Error! watcher.test caught exception", ex);
            }
            if (ex instanceof VirtualMachineError) {
                logger.error("watcher.onEvent caught exception", ex);
            }
            logger.warn("watcher.onEvent caught exception", ex);
        }
        return r;
    }
}

