/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.concurrent.IContext;
import cn.wjybxx.concurrent.ScheduledTaskBuilder;
import cn.wjybxx.concurrent.TaskOptionBuilder;
import cn.wjybxx.concurrent.TimeSharingTask;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public sealed class TaskBuilder<V>
extends TaskOptionBuilder
permits ScheduledTaskBuilder {
    public static final int TYPE_ACTION = 0;
    public static final int TYPE_ACTION_CTX = 1;
    public static final int TYPE_FUNC = 2;
    public static final int TYPE_FUNC_CTX = 3;
    public static final int TYPE_TIMESHARING = 4;
    @Deprecated
    public static final int TYPE_TASK = 5;
    private final int type;
    private final Object task;
    private IContext ctx;

    protected TaskBuilder(int type, Object task) {
        this.task = Objects.requireNonNull(task);
        this.type = type;
        this.ctx = IContext.NONE;
    }

    protected TaskBuilder(int type, Object task, IContext ctx) {
        this.task = Objects.requireNonNull(task);
        this.type = type;
        this.ctx = ctx == null ? IContext.NONE : ctx;
    }

    protected TaskBuilder(TaskBuilder<? extends V> taskBuilder) {
        super.setOptions(taskBuilder.getOptions());
        this.task = taskBuilder.task;
        this.type = taskBuilder.type;
        this.ctx = taskBuilder.ctx;
    }

    public static TaskBuilder<?> newAction(Runnable task) {
        return new TaskBuilder(0, task);
    }

    public static <V> TaskBuilder<V> newAction(Consumer<IContext> task, IContext ctx) {
        return new TaskBuilder<V>(1, task, ctx);
    }

    public static <V> TaskBuilder<V> newFunc(Callable<? extends V> task) {
        return new TaskBuilder<V>(2, task);
    }

    public static <V> TaskBuilder<V> newFunc(Function<IContext, ? extends V> task, IContext ctx) {
        return new TaskBuilder<V>(3, task, ctx);
    }

    public static <V> TaskBuilder<V> newTimeSharing(TimeSharingTask<? super V> task) {
        return new TaskBuilder<V>(4, task, IContext.NONE);
    }

    public static <V> TaskBuilder<V> newTimeSharing(TimeSharingTask<? super V> task, IContext ctx) {
        return new TaskBuilder<V>(4, task, ctx);
    }

    public static int taskType(Object task) {
        Objects.requireNonNull(task);
        if (task instanceof Runnable) {
            return 0;
        }
        if (task instanceof Consumer) {
            return 1;
        }
        if (task instanceof Callable) {
            return 2;
        }
        if (task instanceof Function) {
            return 3;
        }
        if (task instanceof TimeSharingTask) {
            return 4;
        }
        throw new IllegalArgumentException("unsupported task type: " + String.valueOf(task.getClass()));
    }

    public int getType() {
        return this.type;
    }

    public Object getTask() {
        return this.task;
    }

    public IContext getCtx() {
        return this.ctx;
    }

    public TaskBuilder<V> setCtx(IContext ctx) {
        this.ctx = ctx == null ? IContext.NONE : ctx;
        return this;
    }

    @Override
    public TaskBuilder<V> enable(int taskOption) {
        super.enable(taskOption);
        return this;
    }

    @Override
    public TaskBuilder<V> disable(int taskOption) {
        super.disable(taskOption);
        return this;
    }

    @Override
    public TaskBuilder<V> setSchedulePhase(int phase) {
        super.setSchedulePhase(phase);
        return this;
    }

    @Override
    public TaskBuilder<V> setPriority(int priority) {
        super.setPriority(priority);
        return this;
    }

    @Override
    public TaskBuilder<V> setOptions(int options) {
        super.setOptions(options);
        return this;
    }

    public ScheduledTaskBuilder<V> toScheduledBuilder() {
        TaskBuilder taskBuilder = this;
        if (taskBuilder instanceof ScheduledTaskBuilder) {
            ScheduledTaskBuilder sb = (ScheduledTaskBuilder)taskBuilder;
            return sb;
        }
        return new ScheduledTaskBuilder(this);
    }
}

