/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.sequential;

import cn.wjybxx.base.collection.DefaultIndexedPriorityQueue;
import cn.wjybxx.base.collection.IndexedPriorityQueue;
import cn.wjybxx.base.time.TimeProvider;
import cn.wjybxx.concurrent.IFuture;
import cn.wjybxx.concurrent.IFutureTask;
import cn.wjybxx.sequential.AbstractUniScheduledExecutor;
import cn.wjybxx.sequential.UniPromise;
import cn.wjybxx.sequential.UniScheduledExecutor;
import cn.wjybxx.sequential.UniScheduledPromiseTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class DefaultUniScheduledExecutor
extends AbstractUniScheduledExecutor
implements UniScheduledExecutor {
    private static final Comparator<UniScheduledPromiseTask<?>> queueTaskComparator = UniScheduledPromiseTask::compareToExplicitly;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final TimeProvider timeProvider;
    private final IndexedPriorityQueue<UniScheduledPromiseTask<?>> taskQueue;
    private final UniPromise<Void> terminationPromise = new UniPromise(this);
    private final IFuture<Void> terminationFuture = this.terminationPromise.asReadonly();
    private int state = 0;
    private long sequencer = 0L;
    private long tickTime;

    public DefaultUniScheduledExecutor(TimeProvider timeProvider) {
        this(timeProvider, 16);
    }

    public DefaultUniScheduledExecutor(TimeProvider timeProvider, int initCapacity) {
        this.timeProvider = Objects.requireNonNull(timeProvider, "timeProvider");
        this.taskQueue = new DefaultIndexedPriorityQueue(queueTaskComparator, initCapacity);
        this.tickTime = timeProvider.getTime();
    }

    @Override
    public void update() {
        UniScheduledPromiseTask queueTask;
        long curTime;
        this.tickTime = curTime = this.timeProvider.getTime();
        long barrierTaskId = this.sequencer;
        IndexedPriorityQueue<UniScheduledPromiseTask<?>> taskQueue = this.taskQueue;
        while ((queueTask = (UniScheduledPromiseTask)taskQueue.peek()) != null) {
            if (curTime < queueTask.getNextTriggerTime()) {
                return;
            }
            if (queueTask.getId() > barrierTaskId) {
                return;
            }
            taskQueue.poll();
            if (!queueTask.trigger(this.tickTime)) continue;
            if (this.isShutdown()) {
                queueTask.cancelWithoutRemove();
                continue;
            }
            taskQueue.offer((Object)queueTask);
        }
    }

    @Override
    public boolean needMoreUpdate() {
        UniScheduledPromiseTask queueTask = (UniScheduledPromiseTask)this.taskQueue.peek();
        return queueTask != null && queueTask.getNextTriggerTime() <= this.tickTime;
    }

    @Override
    public void execute(@Nonnull Runnable command) {
        if (this.isShuttingDown()) {
            if (command instanceof IFutureTask) {
                IFutureTask promiseTask = (IFutureTask)command;
                promiseTask.future().trySetCancelled(3);
            }
            return;
        }
        if (command instanceof UniScheduledPromiseTask) {
            UniScheduledPromiseTask promiseTask = (UniScheduledPromiseTask)command;
            promiseTask.setId(++this.sequencer);
            if (this.delayExecute(promiseTask)) {
                promiseTask.registerCancellation();
            }
        } else {
            UniScheduledPromiseTask promiseTask = UniScheduledPromiseTask.ofAction(command, 0, this.newScheduledPromise(), ++this.sequencer, this.tickTime);
            if (this.delayExecute(promiseTask)) {
                promiseTask.registerCancellation();
            }
        }
    }

    private boolean delayExecute(UniScheduledPromiseTask<?> futureTask) {
        if (this.isShuttingDown()) {
            futureTask.cancelWithoutRemove();
            return false;
        }
        this.taskQueue.add(futureTask);
        return true;
    }

    @Override
    public void shutdown() {
        if (this.state < 3) {
            this.state = 3;
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        ArrayList<Runnable> result = new ArrayList<Runnable>((Collection<Runnable>)this.taskQueue);
        this.taskQueue.clearIgnoringIndexes();
        this.state = 5;
        this.terminationPromise.trySetResult(null);
        return result;
    }

    @Override
    public boolean isShuttingDown() {
        return this.state >= 3;
    }

    @Override
    public boolean isShutdown() {
        return this.state >= 4;
    }

    @Override
    public boolean isTerminated() {
        return this.state == 5;
    }

    @Override
    public IFuture<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    protected long tickTime() {
        return this.tickTime;
    }

    @Override
    protected void reSchedulePeriodic(UniScheduledPromiseTask<?> futureTask, boolean triggered) {
        this.delayExecute(futureTask);
    }

    @Override
    protected void removeScheduled(UniScheduledPromiseTask<?> futureTask) {
        this.taskQueue.removeTyped(futureTask);
    }
}

