/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.concurrent.BlockingOperationException;
import cn.wjybxx.concurrent.EventLoop;
import cn.wjybxx.concurrent.EventLoopGroup;
import cn.wjybxx.concurrent.ExecutorServiceAdapter;
import cn.wjybxx.concurrent.FutureUtils;
import cn.wjybxx.concurrent.GuardedOperationException;
import cn.wjybxx.concurrent.IContext;
import cn.wjybxx.concurrent.IFuture;
import cn.wjybxx.concurrent.IPromise;
import cn.wjybxx.concurrent.Promise;
import cn.wjybxx.concurrent.PromiseTask;
import cn.wjybxx.concurrent.TaskBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventLoop
implements EventLoop {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractEventLoop.class);
    protected final EventLoopGroup parent;
    protected final Collection<EventLoop> selfCollection = Collections.singleton(this);
    private final ExecutorServiceAdapter adapter;

    protected AbstractEventLoop(@Nullable EventLoopGroup parent) {
        this.parent = parent;
        this.adapter = new ExecutorServiceAdapter(this);
    }

    @Override
    public abstract void execute(Runnable var1);

    @Override
    public void execute(Runnable command, int options) {
        this.execute(FutureUtils.toTask(command, options));
    }

    @Override
    public void execute(Consumer<? super IContext> action, IContext ctx) {
        this.execute(FutureUtils.toTask(action, ctx, 0));
    }

    @Override
    public void execute(Consumer<? super IContext> action, IContext ctx, int options) {
        this.execute(FutureUtils.toTask(action, ctx, options));
    }

    @Override
    @Nullable
    public EventLoopGroup parent() {
        return this.parent;
    }

    @Override
    @Nonnull
    public EventLoop select() {
        return this;
    }

    @Override
    @Nonnull
    public EventLoop select(int key) {
        return this;
    }

    @Override
    public int childCount() {
        return 1;
    }

    @Override
    public final void ensureInEventLoop() {
        if (!this.inEventLoop()) {
            throw new GuardedOperationException();
        }
    }

    @Override
    public final void ensureInEventLoop(String method) {
        Objects.requireNonNull(method);
        if (!this.inEventLoop()) {
            throw new GuardedOperationException("Calling " + method + " must in the EventLoop");
        }
    }

    public final void throwIfInEventLoop(String method) {
        if (this.inEventLoop()) {
            throw new BlockingOperationException("Calling " + method + " from within the EventLoop is not allowed");
        }
    }

    @Override
    public <T> IPromise<T> newPromise() {
        return new Promise(this);
    }

    @Override
    public <T> IFuture<T> submit(@Nonnull TaskBuilder<T> builder) {
        PromiseTask<T> futureTask = PromiseTask.ofBuilder(builder, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    @Override
    public <T> IFuture<T> submit(Callable<T> task) {
        PromiseTask<T> futureTask = PromiseTask.ofFunction(task, null, 0, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    public <V> IFuture<V> submitFunc(Callable<? extends V> task) {
        PromiseTask<V> futureTask = PromiseTask.ofFunction(task, null, 0, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    public <V> IFuture<V> submitFunc(Callable<? extends V> task, int options) {
        PromiseTask<V> futureTask = PromiseTask.ofFunction(task, null, options, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    public <V> IFuture<V> submitFunc(Function<? super IContext, ? extends V> task, IContext ctx) {
        PromiseTask<V> futureTask = PromiseTask.ofFunction(task, ctx, 0, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    public <V> IFuture<V> submitFunc(Function<? super IContext, ? extends V> task, IContext ctx, int options) {
        PromiseTask<V> futureTask = PromiseTask.ofFunction(task, ctx, options, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    @Override
    public IFuture<?> submitAction(Runnable task) {
        PromiseTask futureTask = PromiseTask.ofAction(task, null, 0, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    @Override
    public IFuture<?> submitAction(Runnable task, int options) {
        PromiseTask futureTask = PromiseTask.ofAction(task, null, options, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    @Override
    public IFuture<?> submitAction(Consumer<? super IContext> task, IContext ctx) {
        PromiseTask futureTask = PromiseTask.ofAction(task, ctx, 0, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    @Override
    public IFuture<?> submitAction(Consumer<? super IContext> task, IContext ctx, int options) {
        PromiseTask futureTask = PromiseTask.ofAction(task, ctx, options, this.newPromise());
        this.execute(futureTask);
        return futureTask.future();
    }

    @Override
    @Nonnull
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        this.throwIfInEventLoop("invokeAny");
        return this.adapter.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.throwIfInEventLoop("invokeAny");
        return this.adapter.invokeAny(tasks, timeout, unit);
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.throwIfInEventLoop("invokeAll");
        return this.adapter.invokeAll(tasks);
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        this.throwIfInEventLoop("invokeAll");
        return this.adapter.invokeAll(tasks, timeout, unit);
    }

    @Override
    @Nonnull
    public final Iterator<EventLoop> iterator() {
        return this.selfCollection.iterator();
    }

    @Override
    public final void forEach(Consumer<? super EventLoop> action) {
        this.selfCollection.forEach(action);
    }

    @Override
    public final Spliterator<EventLoop> spliterator() {
        return this.selfCollection.spliterator();
    }

    protected static void logCause(Throwable t) {
        if (t instanceof VirtualMachineError) {
            logger.error("A task raised an exception.", t);
        } else {
            logger.warn("A task raised an exception.", t);
        }
    }
}

