/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.concurrent.AbstractEventLoop;
import cn.wjybxx.concurrent.EventLoopGroup;
import cn.wjybxx.concurrent.IContext;
import cn.wjybxx.concurrent.IScheduledFuture;
import cn.wjybxx.concurrent.IScheduledPromise;
import cn.wjybxx.concurrent.ScheduledPromise;
import cn.wjybxx.concurrent.ScheduledPromiseTask;
import cn.wjybxx.concurrent.ScheduledTaskBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

abstract class AbstractScheduledEventLoop
extends AbstractEventLoop {
    public AbstractScheduledEventLoop(@Nullable EventLoopGroup parent) {
        super(parent);
    }

    @Override
    public <V> IScheduledPromise<V> newScheduledPromise() {
        return new ScheduledPromise(this);
    }

    @Override
    public <V> IScheduledFuture<V> schedule(ScheduledTaskBuilder<V> builder) {
        ScheduledPromiseTask<V> promiseTask = ScheduledPromiseTask.ofBuilder(builder, this.newScheduledPromise(), 0L, this.tickTime());
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public <V> IScheduledFuture<V> scheduleFunc(Function<? super IContext, V> task, IContext ctx, long delay, TimeUnit unit) {
        long triggerTime = ScheduledPromiseTask.triggerTime(delay, unit, this.tickTime());
        ScheduledPromiseTask<V> promiseTask = ScheduledPromiseTask.ofFunction(task, ctx, 0, this.newScheduledPromise(), 0L, triggerTime);
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public IScheduledFuture<?> scheduleAction(Consumer<? super IContext> task, IContext ctx, long delay, TimeUnit unit) {
        long triggerTime = ScheduledPromiseTask.triggerTime(delay, unit, this.tickTime());
        ScheduledPromiseTask promiseTask = ScheduledPromiseTask.ofAction(task, ctx, 0, this.newScheduledPromise(), 0L, triggerTime);
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public IScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) {
        long triggerTime = ScheduledPromiseTask.triggerTime(delay, unit, this.tickTime());
        ScheduledPromiseTask promiseTask = ScheduledPromiseTask.ofAction(task, null, 0, this.newScheduledPromise(), 0L, triggerTime);
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public <V> IScheduledFuture<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
        long triggerTime = ScheduledPromiseTask.triggerTime(delay, unit, this.tickTime());
        ScheduledPromiseTask<V> promiseTask = ScheduledPromiseTask.ofFunction(task, null, 0, this.newScheduledPromise(), 0L, triggerTime);
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public IScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        ScheduledTaskBuilder<?> builder = ScheduledTaskBuilder.newAction(task).setFixedDelay(initialDelay, delay, unit);
        ScheduledPromiseTask<?> promiseTask = ScheduledPromiseTask.ofBuilder(builder, this.newScheduledPromise(), 0L, this.tickTime());
        this.execute(promiseTask);
        return promiseTask.future();
    }

    @Override
    public IScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        ScheduledTaskBuilder<?> builder = ScheduledTaskBuilder.newAction(task).setFixedRate(initialDelay, period, unit);
        ScheduledPromiseTask<?> promiseTask = ScheduledPromiseTask.ofBuilder(builder, this.newScheduledPromise(), 0L, this.tickTime());
        this.execute(promiseTask);
        return promiseTask.future();
    }

    abstract long tickTime();

    abstract void reschedulePeriodic(ScheduledPromiseTask<?> var1, boolean var2);

    abstract void removeScheduled(ScheduledPromiseTask<?> var1);
}

