/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.base.ObjectUtils;
import cn.wjybxx.concurrent.ICancelToken;
import cn.wjybxx.concurrent.IContext;
import java.util.Objects;
import javax.annotation.Nonnull;

public class Context<T>
implements IContext {
    private final Context<T> parent;
    private final Object state;
    private final ICancelToken cancelToken;
    private final T blackboard;
    private final Object sharedProps;

    public Context(T blackboard) {
        this(null, null, null, blackboard, null);
    }

    public Context(T blackboard, Object sharedProps) {
        this(null, null, null, blackboard, sharedProps);
    }

    public Context(Context<T> parent, Object state, ICancelToken cancelToken, T blackboard, Object sharedProps) {
        this.parent = parent;
        this.state = state;
        this.cancelToken = (ICancelToken)ObjectUtils.nullToDef((Object)cancelToken, (Object)ICancelToken.NONE);
        this.blackboard = blackboard;
        this.sharedProps = sharedProps;
    }

    public Context<T> root() {
        Context<T> root = this;
        while (root.parent != null) {
            root = root.parent;
        }
        return root;
    }

    public Context<T> parent() {
        return this.parent;
    }

    @Override
    public Object state() {
        return this.state;
    }

    @Override
    @Nonnull
    public ICancelToken cancelToken() {
        return this.cancelToken;
    }

    public T blackboard() {
        return this.blackboard;
    }

    @Override
    public Object sharedProps() {
        return this.sharedProps;
    }

    public static <U> Context<U> ofBlackboard(U blackboard) {
        return new Context<U>(null, null, null, blackboard, null);
    }

    public static <U> Context<U> ofBlackboard(U blackboard, Object sharedProps) {
        return new Context<U>(null, null, null, blackboard, sharedProps);
    }

    public static <U> Context<U> ofState(Object state) {
        return new Context<Object>(null, state, null, null, null);
    }

    public static <U> Context<U> ofState(Object state, ICancelToken cancelToken) {
        return new Context<Object>(null, state, cancelToken, null, null);
    }

    public static <U> Context<U> ofState(Object state, ICancelToken cancelToken, U blackboard, Object sharedProps) {
        return new Context<U>(null, state, cancelToken, blackboard, sharedProps);
    }

    public static <U> Context<U> ofCancelToken(ICancelToken cancelToken) {
        Objects.requireNonNull(cancelToken);
        return new Context<Object>(null, null, cancelToken, null, null);
    }

    protected Context<T> newContext(Context<T> parent, Object state, ICancelToken cancelToken, T blackboard, Object sharedProps) {
        return new Context<T>(parent, state, cancelToken, blackboard, sharedProps);
    }

    public Context<T> childWithState(Object state) {
        return this.newContext(this, state, null, this.blackboard, this.sharedProps);
    }

    public Context<T> childWithState(Object state, ICancelToken cancelToken) {
        return this.newContext(this, state, cancelToken, this.blackboard, this.sharedProps);
    }

    public Context<T> childWithBlackboard(T blackboard) {
        return this.newContext(this, null, null, blackboard, this.sharedProps);
    }

    public Context<T> childWithBlackboard(T blackboard, Object sharedProps) {
        return this.newContext(this, null, null, blackboard, sharedProps);
    }

    public Context<T> childWith(Object state, ICancelToken cancelToken, T blackboard, Object sharedProps) {
        return this.newContext(this, state, cancelToken, blackboard, sharedProps);
    }

    public Context<T> withState(Object state) {
        return this.withState(state, null);
    }

    public Context<T> withState(Object state, ICancelToken cancelToken) {
        if (cancelToken == null) {
            cancelToken = ICancelToken.NONE;
        }
        if (state == this.state && cancelToken == this.cancelToken) {
            return this;
        }
        return this.newContext(this.parent, state, cancelToken, this.blackboard, this.sharedProps);
    }

    public Context<T> withBlackboard(T blackboard) {
        return this.newContext(this.parent, null, null, blackboard, this.sharedProps);
    }

    public Context<T> withBlackboard(T blackboard, Object sharedProps) {
        return this.newContext(this.parent, null, null, blackboard, sharedProps);
    }

    public Context<T> with(Object state, ICancelToken cancelToken, T blackboard, Object sharedProps) {
        return this.newContext(this.parent, state, cancelToken, blackboard, sharedProps);
    }
}

