/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultThreadFactory
implements ThreadFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultThreadFactory.class);
    private static final int UNASSIGNED_PRIORITY = -1;
    private static final AtomicInteger poolId = new AtomicInteger();
    private final AtomicInteger nextId = new AtomicInteger();
    private final String prefix;
    private final boolean daemon;
    private final int priority;

    public DefaultThreadFactory(String poolName) {
        this(poolName, false);
    }

    public DefaultThreadFactory(String poolName, boolean daemon) {
        this(poolName, daemon, -1);
    }

    public DefaultThreadFactory(String poolName, boolean daemon, int priority) {
        if (poolName == null) {
            throw new NullPointerException("poolName");
        }
        if (priority != -1 && (priority < 1 || priority > 10)) {
            throw new IllegalArgumentException("priority: " + priority + " (expected: Thread.MIN_PRIORITY <= priority <= Thread.MAX_PRIORITY)");
        }
        this.prefix = "Pool-" + poolId.incrementAndGet() + ":" + poolName + "-";
        this.daemon = daemon;
        this.priority = priority;
    }

    @Override
    public Thread newThread(@Nonnull Runnable r) {
        Thread t = new Thread(r, this.prefix + this.nextId.getAndIncrement());
        try {
            if (t.isDaemon() != this.daemon) {
                t.setDaemon(this.daemon);
            }
            if (this.priority != -1 && t.getPriority() != this.priority) {
                t.setPriority(this.priority);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (t.getUncaughtExceptionHandler() == null) {
            t.setUncaughtExceptionHandler(DefaultUncaughtExceptionHandler.INSTANCE);
        }
        return t;
    }

    public static void checkUncaughtExceptionHandler(Thread thread) {
        if (thread.getUncaughtExceptionHandler() == null) {
            thread.setUncaughtExceptionHandler(DefaultUncaughtExceptionHandler.INSTANCE);
        }
    }

    public String toString() {
        return "DefaultThreadFactory{prefix='" + this.prefix + "', daemon=" + this.daemon + ", priority=" + this.priority + "}";
    }

    private static class DefaultUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private static final DefaultUncaughtExceptionHandler INSTANCE = new DefaultUncaughtExceptionHandler();

        private DefaultUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            logger.warn("thread exited due to uncaughtException, threadName {}", (Object)t.getName(), (Object)e);
        }
    }
}

