/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.concurrent.AggregateOptions;
import cn.wjybxx.concurrent.ICompletionStage;
import cn.wjybxx.concurrent.IFuture;
import cn.wjybxx.concurrent.IPromise;
import cn.wjybxx.concurrent.Promise;
import cn.wjybxx.concurrent.TaskInsufficientException;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class FutureCombiner {
    private ChildListener childrenListener = new ChildListener();
    private IPromise<Object> aggregatePromise;
    private int futureCount;
    private static final Object NIL = new Object();

    public FutureCombiner add(ICompletionStage<?> future) {
        Objects.requireNonNull(future);
        ChildListener childrenListener = this.childrenListener;
        if (childrenListener == null) {
            throw new IllegalStateException("Adding futures is not allowed after finished adding");
        }
        ++this.futureCount;
        future.toFuture().onCompleted(childrenListener, 0);
        return this;
    }

    public FutureCombiner addAll(ICompletionStage<?> ... futures) {
        for (ICompletionStage<?> future : futures) {
            this.add(future);
        }
        return this;
    }

    public FutureCombiner addAll(Collection<? extends ICompletionStage<?>> futures) {
        for (ICompletionStage<?> future : futures) {
            this.add(future);
        }
        return this;
    }

    public int futureCount() {
        return this.futureCount;
    }

    public FutureCombiner setAggregatePromise(IPromise<Object> aggregatePromise) {
        this.aggregatePromise = aggregatePromise;
        return this;
    }

    public void clear() {
        this.childrenListener = new ChildListener();
        this.aggregatePromise = null;
        this.futureCount = 0;
    }

    public IPromise<Object> anyOf() {
        return this.finish(AggregateOptions.anyOf());
    }

    public IPromise<Object> selectN(int successRequire, boolean failFast) {
        return this.finish(AggregateOptions.selectN(successRequire, failFast));
    }

    public IPromise<Object> selectAll() {
        return this.selectN(this.futureCount(), true);
    }

    public IPromise<Object> selectAll(boolean failFast) {
        return this.selectN(this.futureCount(), failFast);
    }

    private IPromise<Object> finish(AggregateOptions options) {
        Objects.requireNonNull(options);
        ChildListener childrenListener = this.childrenListener;
        if (childrenListener == null) {
            throw new IllegalStateException("Already finished");
        }
        this.childrenListener = null;
        IPromise<Object> aggregatePromise = this.aggregatePromise;
        if (aggregatePromise == null) {
            aggregatePromise = new Promise<Object>();
        } else {
            this.aggregatePromise = null;
        }
        childrenListener.futureCount = this.futureCount;
        childrenListener.options = options;
        childrenListener.aggregatePromise = aggregatePromise;
        childrenListener.checkComplete();
        return aggregatePromise;
    }

    private static Object encodeValue(Object val) {
        return val == null ? NIL : val;
    }

    private static Object decodeValue(Object r) {
        return r == NIL ? null : r;
    }

    private static class ChildListener
    implements Consumer<IFuture<?>> {
        private final AtomicInteger succeedCount = new AtomicInteger();
        private final AtomicInteger doneCount = new AtomicInteger();
        private Object result;
        private Throwable cause;
        private int futureCount;
        private AggregateOptions options;
        private volatile IPromise<Object> aggregatePromise;

        private ChildListener() {
        }

        @Override
        public void accept(IFuture<?> future) {
            if (future.isFailed()) {
                this.accept(null, future.exceptionNow(false));
            } else {
                this.accept(future.resultNow(), null);
            }
        }

        public void accept(Object r, Throwable throwable) {
            if (throwable == null) {
                this.result = FutureCombiner.encodeValue(r);
                this.succeedCount.incrementAndGet();
            } else {
                this.cause = throwable;
            }
            this.doneCount.incrementAndGet();
            IPromise<Object> aggregatePromise = this.aggregatePromise;
            if (aggregatePromise != null && !aggregatePromise.isDone() && this.checkComplete()) {
                this.result = null;
                this.cause = null;
            }
        }

        boolean checkComplete() {
            int succeedCount;
            int doneCount = this.doneCount.get();
            if (doneCount < (succeedCount = this.succeedCount.get())) {
                return false;
            }
            if (this.futureCount == 0) {
                return this.aggregatePromise.trySetResult(null);
            }
            if (this.options.isAnyOf()) {
                if (doneCount == 0) {
                    return false;
                }
                if (this.result != null) {
                    return this.aggregatePromise.trySetResult(FutureCombiner.decodeValue(this.result));
                }
                return this.aggregatePromise.trySetException(this.cause);
            }
            if (!this.options.failFast && doneCount < this.futureCount) {
                return false;
            }
            int successRequire = this.options.successRequire;
            if (succeedCount >= successRequire) {
                return this.aggregatePromise.trySetResult(null);
            }
            if (succeedCount + (this.futureCount - doneCount) < successRequire) {
                if (this.cause == null) {
                    this.cause = TaskInsufficientException.create(this.futureCount, doneCount, succeedCount, successRequire);
                }
                return this.aggregatePromise.trySetException(this.cause);
            }
            return false;
        }
    }
}

