/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.concurrent.AggregateOptions;
import cn.wjybxx.concurrent.TaskInsufficientException;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class JDKFutureCombiner {
    private ChildListener childrenListener = new ChildListener();
    private CompletableFuture<Object> aggregatePromise;
    private int futureCount;
    private static final Object NIL = new Object();

    public JDKFutureCombiner add(CompletionStage<?> future) {
        Objects.requireNonNull(future);
        ChildListener childrenListener = this.childrenListener;
        if (childrenListener == null) {
            throw new IllegalStateException("Adding futures is not allowed after finished adding");
        }
        ++this.futureCount;
        future.whenComplete(childrenListener);
        return this;
    }

    public JDKFutureCombiner addAll(CompletionStage<?> ... futures) {
        for (CompletionStage<?> future : futures) {
            this.add(future);
        }
        return this;
    }

    public JDKFutureCombiner addAll(Collection<? extends CompletionStage<?>> futures) {
        for (CompletionStage<?> future : futures) {
            this.add(future);
        }
        return this;
    }

    public int futureCount() {
        return this.futureCount;
    }

    public JDKFutureCombiner setAggregatePromise(CompletableFuture<Object> aggregatePromise) {
        this.aggregatePromise = aggregatePromise;
        return this;
    }

    public void clear() {
        this.childrenListener = new ChildListener();
        this.aggregatePromise = null;
        this.futureCount = 0;
    }

    public CompletableFuture<Object> anyOf() {
        return this.finish(AggregateOptions.anyOf());
    }

    public CompletableFuture<Object> selectN(int successRequire, boolean failFast) {
        return this.finish(AggregateOptions.selectN(successRequire, failFast));
    }

    public CompletableFuture<Object> selectAll() {
        return this.selectN(this.futureCount(), true);
    }

    public CompletableFuture<Object> selectAll(boolean failFast) {
        return this.selectN(this.futureCount(), failFast);
    }

    private CompletableFuture<Object> finish(AggregateOptions options) {
        Objects.requireNonNull(options);
        ChildListener childrenListener = this.childrenListener;
        if (childrenListener == null) {
            throw new IllegalStateException("Already finished");
        }
        this.childrenListener = null;
        CompletableFuture<Object> aggregatePromise = this.aggregatePromise;
        if (aggregatePromise == null) {
            aggregatePromise = new CompletableFuture();
        } else {
            this.aggregatePromise = null;
        }
        childrenListener.futureCount = this.futureCount;
        childrenListener.options = options;
        childrenListener.aggregatePromise = aggregatePromise;
        childrenListener.checkComplete();
        return aggregatePromise;
    }

    private static Object encodeValue(Object val) {
        return val == null ? NIL : val;
    }

    private static Object decodeValue(Object r) {
        return r == NIL ? null : r;
    }

    private static class ChildListener
    implements BiConsumer<Object, Throwable> {
        private final AtomicInteger succeedCount = new AtomicInteger();
        private final AtomicInteger doneCount = new AtomicInteger();
        private Object result;
        private Throwable cause;
        private int futureCount;
        private AggregateOptions options;
        private volatile CompletableFuture<Object> aggregatePromise;

        private ChildListener() {
        }

        @Override
        public void accept(Object r, Throwable throwable) {
            if (throwable == null) {
                this.result = JDKFutureCombiner.encodeValue(r);
                this.succeedCount.incrementAndGet();
            } else {
                this.cause = throwable;
            }
            this.doneCount.incrementAndGet();
            CompletableFuture<Object> aggregatePromise = this.aggregatePromise;
            if (aggregatePromise != null && !aggregatePromise.isDone() && this.checkComplete()) {
                this.result = null;
                this.cause = null;
            }
        }

        boolean checkComplete() {
            int succeedCount;
            int doneCount = this.doneCount.get();
            if (doneCount < (succeedCount = this.succeedCount.get())) {
                return false;
            }
            if (this.futureCount == 0) {
                return this.aggregatePromise.complete(null);
            }
            if (this.options.isAnyOf()) {
                if (doneCount == 0) {
                    return false;
                }
                if (this.result != null) {
                    return this.aggregatePromise.complete(JDKFutureCombiner.decodeValue(this.result));
                }
                return this.aggregatePromise.completeExceptionally(this.cause);
            }
            if (!this.options.failFast && doneCount < this.futureCount) {
                return false;
            }
            int successRequire = this.options.successRequire;
            if (succeedCount >= successRequire) {
                return this.aggregatePromise.complete(null);
            }
            if (succeedCount + (this.futureCount - doneCount) < successRequire) {
                if (this.cause == null) {
                    this.cause = TaskInsufficientException.create(this.futureCount, doneCount, succeedCount, successRequire);
                }
                return this.aggregatePromise.completeExceptionally(this.cause);
            }
            return false;
        }
    }
}

