/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.base.ThreadUtils;
import cn.wjybxx.base.concurrent.StacklessCancellationException;
import cn.wjybxx.base.function.TriConsumer;
import cn.wjybxx.base.function.TriFunction;
import cn.wjybxx.concurrent.BlockingOperationException;
import cn.wjybxx.concurrent.FutureLogger;
import cn.wjybxx.concurrent.ICompletionStage;
import cn.wjybxx.concurrent.IContext;
import cn.wjybxx.concurrent.IExecutor;
import cn.wjybxx.concurrent.IFuture;
import cn.wjybxx.concurrent.IPromise;
import cn.wjybxx.concurrent.ITask;
import cn.wjybxx.concurrent.ReadOnlyFuture;
import cn.wjybxx.concurrent.SingleThreadExecutor;
import cn.wjybxx.concurrent.TaskOption;
import cn.wjybxx.concurrent.TaskStatus;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class Promise<T>
implements IPromise<T>,
IFuture<T> {
    private static final long NANO_PER_MILLISECOND = 1000000L;
    private static final Object COMPUTING = new Object();
    private static final Object NIL = new Object();
    private volatile Object result;
    private volatile Completion stack;
    private final Executor _executor;
    private static final VarHandle VH_RESULT;
    private static final VarHandle VH_STACK;
    static final int SYNC = 0;
    static final int ASYNC = 1;
    static final int NESTED = -1;
    static final Executor CLAIMED;
    private static final Completion TOMBSTONE;

    public Promise() {
        this._executor = null;
    }

    public Promise(Executor executor) {
        this._executor = executor;
    }

    private Promise(Executor executor, Object result) {
        this._executor = executor;
        VH_RESULT.setRelease(this, result);
    }

    public static <V> Promise<V> completedPromise(V result) {
        return new Promise(null, result == null ? NIL : result);
    }

    public static <V> Promise<V> completedPromise(V result, Executor executor) {
        return new Promise(executor, Promise.encodeValue(result));
    }

    public static <V> Promise<V> failedPromise(Throwable cause) {
        Objects.requireNonNull(cause);
        return new Promise(null, new AltResult(cause));
    }

    public static <V> Promise<V> failedPromise(Throwable cause, Executor executor) {
        Objects.requireNonNull(cause);
        return new Promise(executor, new AltResult(cause));
    }

    private static Object encodeValue(Object value) {
        return value == null ? NIL : value;
    }

    private T decodeValue(Object result) {
        return (T)(result == NIL ? null : result);
    }

    private static AltResult encodeThrowable(Throwable x) {
        return new AltResult(x instanceof CompletionException ? x : new CompletionException(x));
    }

    private boolean internalComplete(Object result) {
        Object preResult = VH_RESULT.compareAndExchange(this, null, result);
        if (preResult == null) {
            return true;
        }
        if (preResult == COMPUTING) {
            return VH_RESULT.compareAndSet(this, COMPUTING, result);
        }
        return false;
    }

    @Override
    @Nullable
    public Executor executor() {
        return this._executor;
    }

    @Override
    public IFuture<T> asReadonly() {
        return new ReadOnlyFuture(this);
    }

    @Override
    @Nonnull
    public IFuture<T> toFuture() {
        return this;
    }

    private static boolean isDone0(Object result) {
        return result != null && result != COMPUTING;
    }

    private static boolean isSucceeded0(Object result) {
        if (result == null || result == COMPUTING) {
            return false;
        }
        return result == NIL || !(result instanceof AltResult);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isFailed0(Object result) {
        if (result == null) return false;
        if (result == COMPUTING) return false;
        if (result == NIL) {
            return false;
        }
        if (!(result instanceof AltResult)) return false;
        AltResult altResult = (AltResult)result;
        if (altResult.cause instanceof CancellationException) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isCancelled0(Object result) {
        if (result == null) return false;
        if (result == COMPUTING) return false;
        if (result == NIL) {
            return false;
        }
        if (!(result instanceof AltResult)) return false;
        AltResult altResult = (AltResult)result;
        if (!(altResult.cause instanceof CancellationException)) return false;
        return true;
    }

    @Override
    @Deprecated
    public final Future.State state() {
        Object r = this.result;
        if (r == null || r == COMPUTING) {
            return Future.State.RUNNING;
        }
        if (r == NIL) {
            return Future.State.SUCCESS;
        }
        if (r instanceof AltResult) {
            AltResult altResult = (AltResult)r;
            if (altResult.cause instanceof CancellationException) {
                return Future.State.CANCELLED;
            }
            return Future.State.FAILED;
        }
        return Future.State.SUCCESS;
    }

    @Override
    public final TaskStatus status() {
        return Promise.futureState(this.result);
    }

    private static TaskStatus futureState(Object r) {
        if (r == null) {
            return TaskStatus.PENDING;
        }
        if (r == COMPUTING) {
            return TaskStatus.COMPUTING;
        }
        if (r == NIL) {
            return TaskStatus.SUCCESS;
        }
        if (r instanceof AltResult) {
            AltResult altResult = (AltResult)r;
            if (altResult.cause instanceof CancellationException) {
                return TaskStatus.CANCELLED;
            }
            return TaskStatus.FAILED;
        }
        return TaskStatus.SUCCESS;
    }

    @Override
    public final boolean isPending() {
        return this.result == null;
    }

    @Override
    public final boolean isComputing() {
        return this.result == COMPUTING;
    }

    @Override
    public boolean isSucceeded() {
        return Promise.isSucceeded0(this.result);
    }

    @Override
    public final boolean isFailed() {
        return Promise.isFailed0(this.result);
    }

    @Override
    public final boolean isCancelled() {
        return Promise.isCancelled0(this.result);
    }

    @Override
    public final boolean isDone() {
        return Promise.isDone0(this.result);
    }

    @Override
    public final boolean isFailedOrCancelled() {
        return this.result instanceof AltResult;
    }

    @Override
    public final boolean trySetComputing() {
        Object preResult = VH_RESULT.compareAndExchange(this, null, COMPUTING);
        return preResult == null;
    }

    @Override
    public final TaskStatus trySetComputing2() {
        Object preResult = VH_RESULT.compareAndExchange(this, null, COMPUTING);
        return Promise.futureState(preResult);
    }

    @Override
    public final void setComputing() {
        if (!this.trySetComputing()) {
            throw new IllegalStateException("Already computing");
        }
    }

    @Override
    public final boolean trySetResult(T result) {
        if (this.internalComplete(Promise.encodeValue(result))) {
            Promise.postComplete(this);
            return true;
        }
        return false;
    }

    @Override
    public final void setResult(T result) {
        if (!this.trySetResult(result)) {
            throw new IllegalStateException("Already complete");
        }
    }

    @Override
    public final boolean trySetException(@Nonnull Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        if (this.internalComplete(new AltResult(cause))) {
            FutureLogger.logCause(cause);
            Promise.postComplete(this);
            return true;
        }
        return false;
    }

    @Override
    public final void setException(@Nonnull Throwable cause) {
        if (!this.trySetException(cause)) {
            throw new IllegalStateException("Already complete");
        }
    }

    @Override
    public boolean trySetCancelled(int cancelCode) {
        StacklessCancellationException cause = StacklessCancellationException.instOf((int)cancelCode);
        if (this.internalComplete(new AltResult((Throwable)cause))) {
            Promise.postComplete(this);
            return true;
        }
        return false;
    }

    @Override
    public void setCancelled(int cancelCode) {
        if (!this.trySetCancelled(cancelCode)) {
            throw new IllegalStateException("Already complete");
        }
    }

    @Override
    @Deprecated
    public final boolean cancel(boolean mayInterruptIfRunning) {
        Object r = this.result;
        if (Promise.isDone0(r)) {
            return Promise.isCancelled0(r);
        }
        if (this.trySetException(new CancellationException())) {
            return true;
        }
        return this.isCancelled();
    }

    @Override
    public final boolean tryTransferFrom(IFuture<? extends T> input) {
        Objects.requireNonNull(input);
        if (this.isDone()) {
            return false;
        }
        if (Promise.tryTransferTo(input, this)) {
            Promise.postComplete(this);
            return true;
        }
        return false;
    }

    @Override
    public final T getNow() {
        Object r = this.result;
        if (Promise.isDone0(r)) {
            return Promise.reportJoin(r);
        }
        return null;
    }

    @Override
    public final T getNow(T valueIfAbsent) {
        Object r = this.result;
        if (Promise.isDone0(r)) {
            return Promise.reportJoin(r);
        }
        return valueIfAbsent;
    }

    @Override
    public final T resultNow() {
        Object r = this.result;
        if (!Promise.isDone0(r)) {
            throw new IllegalStateException("Task has not completed");
        }
        if (r == NIL) {
            return null;
        }
        if (r instanceof AltResult) {
            AltResult altResult = (AltResult)r;
            if (altResult.cause instanceof CancellationException) {
                throw new IllegalStateException("Task was cancelled");
            }
            throw new IllegalStateException("Task completed with exception");
        }
        Object value = r;
        return (T)value;
    }

    @Override
    public final Throwable exceptionNow() {
        return this.exceptionNow(true);
    }

    @Override
    public final Throwable exceptionNow(boolean throwIfCancelled) {
        Object r = this.result;
        if (r instanceof AltResult) {
            AltResult altResult = (AltResult)r;
            if (throwIfCancelled && altResult.cause instanceof CancellationException) {
                throw new IllegalStateException("Task was cancelled");
            }
            return altResult.cause;
        }
        if (!Promise.isDone0(r)) {
            throw new IllegalStateException("Task has not completed");
        }
        throw new IllegalStateException("Task completed with a result");
    }

    private static <T> T reportJoin(Object r) {
        if (r == NIL) {
            return null;
        }
        if (r instanceof AltResult) {
            AltResult altResult = (AltResult)r;
            Throwable cause = altResult.cause;
            if (cause instanceof CancellationException) {
                throw (CancellationException)cause;
            }
            throw new CompletionException(cause);
        }
        return (T)r;
    }

    private static <T> T reportGet(Object r) throws ExecutionException {
        if (r == NIL) {
            return null;
        }
        if (r instanceof AltResult) {
            AltResult altResult = (AltResult)r;
            Throwable cause = altResult.cause;
            if (cause instanceof CancellationException) {
                throw (CancellationException)cause;
            }
            throw new ExecutionException(cause);
        }
        return (T)r;
    }

    protected final void checkDeadlock() {
        SingleThreadExecutor eventLoop;
        Executor executor = this.executor();
        if (executor instanceof SingleThreadExecutor && (eventLoop = (SingleThreadExecutor)executor).inEventLoop()) {
            throw new BlockingOperationException();
        }
    }

    @Override
    public final T get() throws InterruptedException, ExecutionException {
        Object r = this.result;
        if (Promise.isDone0(r)) {
            return Promise.reportGet(r);
        }
        this.await();
        return Promise.reportGet(this.result);
    }

    @Override
    public final T get(long timeout, @Nonnull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object r = this.result;
        if (Promise.isDone0(r)) {
            return Promise.reportGet(r);
        }
        if (this.await(timeout, unit)) {
            return Promise.reportGet(this.result);
        }
        throw new TimeoutException();
    }

    @Override
    public final T join() throws CompletionException {
        Object r = this.result;
        if (Promise.isDone0(r)) {
            return Promise.reportJoin(r);
        }
        this.awaitUninterruptibly();
        return Promise.reportJoin(this.result);
    }

    @Nullable
    private Awaiter tryPushAwaiter() {
        Completion head = this.stack;
        if (head instanceof Awaiter) {
            Awaiter awaiter = (Awaiter)head;
            return awaiter;
        }
        Awaiter awaiter = new Awaiter(this);
        return this.pushCompletion(awaiter) ? awaiter : null;
    }

    @Override
    public final Promise<T> await() throws InterruptedException {
        if (this.isDone()) {
            return this;
        }
        this.checkDeadlock();
        Awaiter awaiter = this.tryPushAwaiter();
        if (awaiter != null) {
            awaiter.await();
        }
        return this;
    }

    @Override
    public final Promise<T> awaitUninterruptibly() {
        if (this.isDone()) {
            return this;
        }
        this.checkDeadlock();
        Awaiter awaiter = this.tryPushAwaiter();
        if (awaiter != null) {
            awaiter.awaitUninterruptibly();
        }
        return this;
    }

    @Override
    public final boolean await(long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        if (timeout <= 0L) {
            return this.isDone();
        }
        if (this.isDone()) {
            return true;
        }
        this.checkDeadlock();
        Awaiter awaiter = this.tryPushAwaiter();
        if (awaiter != null) {
            return awaiter.await(timeout, unit);
        }
        return true;
    }

    @Override
    public final boolean awaitUninterruptibly(long timeout, @Nonnull TimeUnit unit) {
        if (timeout <= 0L) {
            return this.isDone();
        }
        if (this.isDone()) {
            return true;
        }
        this.checkDeadlock();
        Awaiter awaiter = this.tryPushAwaiter();
        if (awaiter != null) {
            return awaiter.awaitUninterruptibly(timeout, unit);
        }
        return true;
    }

    protected <U> Promise<U> newIncompletePromise(Executor exe) {
        return new Promise<T>(exe);
    }

    protected IContext inheritContext(int options) {
        return IContext.NONE;
    }

    @Override
    public <U> Promise<U> composeApply(BiFunction<? super IContext, ? super T, ? extends ICompletionStage<U>> fn, @Nullable IContext ctx, int options) {
        return this.uniComposeApply(null, fn, ctx, options);
    }

    @Override
    public <U> Promise<U> composeApply(BiFunction<? super IContext, ? super T, ? extends ICompletionStage<U>> fn) {
        return this.uniComposeApply(null, fn, null, 0);
    }

    @Override
    public <U> Promise<U> composeApplyAsync(Executor executor, BiFunction<? super IContext, ? super T, ? extends ICompletionStage<U>> fn) {
        Objects.requireNonNull(executor, "executor");
        return this.uniComposeApply(executor, fn, null, 0);
    }

    @Override
    public <U> Promise<U> composeApplyAsync(Executor executor, BiFunction<? super IContext, ? super T, ? extends ICompletionStage<U>> fn, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniComposeApply(executor, fn, ctx, options);
    }

    private <U> Promise<U> uniComposeApply(Executor executor, BiFunction<? super IContext, ? super T, ? extends ICompletionStage<U>> fn, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(fn);
        if (ctx == null) {
            ctx = this.inheritContext(options);
        }
        Promise<U> promise = this.newIncompletePromise(executor == null ? this.executor() : executor);
        this.pushCompletion(new UniComposeApply<T, U>(executor, ctx, options, this, promise, fn));
        return promise;
    }

    @Override
    public <U> Promise<U> composeCall(Function<? super IContext, ? extends ICompletionStage<U>> fn, @Nullable IContext ctx, int options) {
        return this.uniComposeCall(null, fn, ctx, options);
    }

    @Override
    public <U> Promise<U> composeCall(Function<? super IContext, ? extends ICompletionStage<U>> fn) {
        return this.uniComposeCall(null, fn, null, 0);
    }

    @Override
    public <U> Promise<U> composeCallAsync(Executor executor, Function<? super IContext, ? extends ICompletionStage<U>> fn) {
        Objects.requireNonNull(executor, "executor");
        return this.uniComposeCall(executor, fn, null, 0);
    }

    @Override
    public <U> Promise<U> composeCallAsync(Executor executor, Function<? super IContext, ? extends ICompletionStage<U>> fn, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniComposeCall(executor, fn, ctx, options);
    }

    private <U> Promise<U> uniComposeCall(Executor executor, Function<? super IContext, ? extends ICompletionStage<U>> fn, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(fn);
        if (ctx == null) {
            ctx = this.inheritContext(options);
        }
        Promise<U> promise = this.newIncompletePromise(executor == null ? this.executor() : executor);
        this.pushCompletion(new UniComposeCall(executor, ctx, options, this, promise, fn));
        return promise;
    }

    @Override
    public <X extends Throwable> Promise<T> composeCatching(Class<X> exceptionType, BiFunction<? super IContext, ? super X, ? extends ICompletionStage<T>> fallback, @Nullable IContext ctx, int options) {
        return this.uniComposeCatching(null, exceptionType, fallback, ctx, options);
    }

    @Override
    public <X extends Throwable> Promise<T> composeCatching(Class<X> exceptionType, BiFunction<? super IContext, ? super X, ? extends ICompletionStage<T>> fallback) {
        return this.uniComposeCatching(null, exceptionType, fallback, null, 0);
    }

    @Override
    public <X extends Throwable> Promise<T> composeCatchingAsync(Executor executor, Class<X> exceptionType, BiFunction<? super IContext, ? super X, ? extends ICompletionStage<T>> fallback) {
        Objects.requireNonNull(executor, "executor");
        return this.uniComposeCatching(executor, exceptionType, fallback, null, 0);
    }

    @Override
    public <X extends Throwable> Promise<T> composeCatchingAsync(Executor executor, Class<X> exceptionType, BiFunction<? super IContext, ? super X, ? extends ICompletionStage<T>> fallback, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniComposeCatching(executor, exceptionType, fallback, ctx, options);
    }

    private <X extends Throwable> Promise<T> uniComposeCatching(Executor executor, Class<X> exceptionType, BiFunction<? super IContext, ? super X, ? extends ICompletionStage<T>> fallback, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(exceptionType);
        Objects.requireNonNull(fallback);
        if (ctx == null) {
            ctx = this.inheritContext(options);
        }
        Promise promise = this.newIncompletePromise(executor == null ? this.executor() : executor);
        this.pushCompletion(new UniComposeCathing(executor, ctx, options, this, promise, exceptionType, fallback));
        return promise;
    }

    @Override
    public <U> Promise<U> composeHandle(TriFunction<? super IContext, ? super T, ? super Throwable, ? extends ICompletionStage<U>> fn, @Nullable IContext ctx, int options) {
        return this.uniComposeHandle(null, fn, ctx, options);
    }

    @Override
    public <U> Promise<U> composeHandle(TriFunction<? super IContext, ? super T, ? super Throwable, ? extends ICompletionStage<U>> fn) {
        return this.uniComposeHandle(null, fn, null, 0);
    }

    @Override
    public <U> Promise<U> composeHandleAsync(Executor executor, TriFunction<? super IContext, ? super T, ? super Throwable, ? extends ICompletionStage<U>> fn) {
        Objects.requireNonNull(executor, "executor");
        return this.uniComposeHandle(executor, fn, null, 0);
    }

    @Override
    public <U> Promise<U> composeHandleAsync(Executor executor, TriFunction<? super IContext, ? super T, ? super Throwable, ? extends ICompletionStage<U>> fn, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniComposeHandle(executor, fn, ctx, options);
    }

    private <U> Promise<U> uniComposeHandle(Executor executor, TriFunction<? super IContext, ? super T, ? super Throwable, ? extends ICompletionStage<U>> fn, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(fn);
        if (ctx == null) {
            ctx = this.inheritContext(options);
        }
        Promise<U> promise = this.newIncompletePromise(executor == null ? this.executor() : executor);
        this.pushCompletion(new UniComposeHandle<T, U>(executor, ctx, options, this, promise, fn));
        return promise;
    }

    @Override
    public <U> Promise<U> thenApply(BiFunction<? super IContext, ? super T, ? extends U> fn, @Nullable IContext ctx, int options) {
        return this.uniApply(null, fn, ctx, options);
    }

    @Override
    public <U> Promise<U> thenApply(BiFunction<? super IContext, ? super T, ? extends U> fn) {
        return this.uniApply(null, fn, null, 0);
    }

    @Override
    public <U> Promise<U> thenApplyAsync(Executor executor, BiFunction<? super IContext, ? super T, ? extends U> fn) {
        Objects.requireNonNull(executor, "executor");
        return this.uniApply(executor, fn, null, 0);
    }

    @Override
    public <U> Promise<U> thenApplyAsync(Executor executor, BiFunction<? super IContext, ? super T, ? extends U> fn, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniApply(executor, fn, ctx, options);
    }

    private <U> Promise<U> uniApply(Executor executor, BiFunction<? super IContext, ? super T, ? extends U> fn, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(fn);
        if (ctx == null) {
            ctx = this.inheritContext(options);
        }
        Promise<U> promise = this.newIncompletePromise(executor == null ? this.executor() : executor);
        this.pushCompletion(new UniApply<T, U>(executor, ctx, options, this, promise, fn));
        return promise;
    }

    public Promise<Void> thenAccept(BiConsumer<? super IContext, ? super T> action, @Nullable IContext ctx, int options) {
        return this.uniAccept(null, action, ctx, options);
    }

    public Promise<Void> thenAccept(BiConsumer<? super IContext, ? super T> action) {
        return this.uniAccept(null, action, null, 0);
    }

    public Promise<Void> thenAcceptAsync(Executor executor, BiConsumer<? super IContext, ? super T> action) {
        Objects.requireNonNull(executor, "executor");
        return this.uniAccept(executor, action, null, 0);
    }

    public Promise<Void> thenAcceptAsync(Executor executor, BiConsumer<? super IContext, ? super T> action, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniAccept(executor, action, ctx, options);
    }

    private Promise<Void> uniAccept(Executor executor, BiConsumer<? super IContext, ? super T> action, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(action);
        if (ctx == null) {
            ctx = this.inheritContext(options);
        }
        Promise<Void> promise = this.newIncompletePromise(executor == null ? this.executor() : executor);
        this.pushCompletion(new UniAccept<T>(executor, ctx, options, this, promise, action));
        return promise;
    }

    @Override
    public <U> Promise<U> thenCall(Function<? super IContext, ? extends U> fn, @Nullable IContext ctx, int options) {
        return this.uniCall(null, fn, ctx, options);
    }

    @Override
    public <U> Promise<U> thenCall(Function<? super IContext, ? extends U> fn) {
        return this.uniCall(null, fn, null, 0);
    }

    @Override
    public <U> Promise<U> thenCallAsync(Executor executor, Function<? super IContext, ? extends U> fn) {
        Objects.requireNonNull(executor, "executor");
        return this.uniCall(executor, fn, null, 0);
    }

    @Override
    public <U> Promise<U> thenCallAsync(Executor executor, Function<? super IContext, ? extends U> fn, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniCall(executor, fn, ctx, options);
    }

    private <U> Promise<U> uniCall(Executor executor, Function<? super IContext, ? extends U> fn, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(fn);
        if (ctx == null) {
            ctx = this.inheritContext(options);
        }
        Promise<U> promise = this.newIncompletePromise(executor == null ? this.executor() : executor);
        this.pushCompletion(new UniCall(executor, ctx, options, this, promise, fn));
        return promise;
    }

    public Promise<Void> thenRun(Consumer<? super IContext> action, @Nullable IContext ctx, int options) {
        return this.uniRun(null, action, ctx, options);
    }

    public Promise<Void> thenRun(Consumer<? super IContext> action) {
        return this.uniRun(null, action, null, 0);
    }

    public Promise<Void> thenRunAsync(Executor executor, Consumer<? super IContext> action) {
        Objects.requireNonNull(executor, "executor");
        return this.uniRun(executor, action, null, 0);
    }

    public Promise<Void> thenRunAsync(Executor executor, Consumer<? super IContext> action, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniRun(executor, action, ctx, options);
    }

    private Promise<Void> uniRun(Executor executor, Consumer<? super IContext> action, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(action);
        if (ctx == null) {
            ctx = this.inheritContext(options);
        }
        Promise<Void> promise = this.newIncompletePromise(executor == null ? this.executor() : executor);
        this.pushCompletion(new UniRun(executor, ctx, options, this, promise, action));
        return promise;
    }

    @Override
    public <X extends Throwable> Promise<T> catching(Class<X> exceptionType, BiFunction<? super IContext, ? super X, ? extends T> fallback, @Nullable IContext ctx, int options) {
        return this.uniCatching(null, exceptionType, fallback, ctx, options);
    }

    @Override
    public <X extends Throwable> Promise<T> catching(Class<X> exceptionType, BiFunction<? super IContext, ? super X, ? extends T> fallback) {
        return this.uniCatching(null, exceptionType, fallback, null, 0);
    }

    @Override
    public <X extends Throwable> Promise<T> catchingAsync(Executor executor, Class<X> exceptionType, BiFunction<? super IContext, ? super X, ? extends T> fallback) {
        Objects.requireNonNull(executor, "executor");
        return this.uniCatching(executor, exceptionType, fallback, null, 0);
    }

    @Override
    public <X extends Throwable> Promise<T> catchingAsync(Executor executor, Class<X> exceptionType, BiFunction<? super IContext, ? super X, ? extends T> fallback, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniCatching(executor, exceptionType, fallback, ctx, options);
    }

    private <X extends Throwable> Promise<T> uniCatching(Executor executor, Class<X> exceptionType, BiFunction<? super IContext, ? super X, ? extends T> fallback, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(exceptionType, "exceptionType");
        Objects.requireNonNull(fallback, "fallback");
        if (ctx == null) {
            ctx = this.inheritContext(options);
        }
        Promise promise = this.newIncompletePromise(executor == null ? this.executor() : executor);
        this.pushCompletion(new UniCathing<X, T>(executor, ctx, options, this, promise, exceptionType, fallback));
        return promise;
    }

    @Override
    public <U> Promise<U> handle(TriFunction<? super IContext, ? super T, Throwable, ? extends U> fn, @Nullable IContext ctx, int options) {
        return this.uniHandle(null, fn, ctx, options);
    }

    @Override
    public <U> Promise<U> handle(TriFunction<? super IContext, ? super T, Throwable, ? extends U> fn) {
        return this.uniHandle(null, fn, null, 0);
    }

    @Override
    public <U> Promise<U> handleAsync(Executor executor, TriFunction<? super IContext, ? super T, Throwable, ? extends U> fn) {
        return this.uniHandle(executor, fn, null, 0);
    }

    @Override
    public <U> Promise<U> handleAsync(Executor executor, TriFunction<? super IContext, ? super T, Throwable, ? extends U> fn, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniHandle(executor, fn, ctx, options);
    }

    private <U> Promise<U> uniHandle(Executor executor, TriFunction<? super IContext, ? super T, Throwable, ? extends U> fn, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(fn);
        if (ctx == null) {
            ctx = this.inheritContext(options);
        }
        Promise<U> promise = this.newIncompletePromise(executor == null ? this.executor() : executor);
        this.pushCompletion(new UniHandle<T, U>(executor, ctx, options, this, promise, fn));
        return promise;
    }

    @Override
    public Promise<T> whenComplete(TriConsumer<? super IContext, ? super T, ? super Throwable> action, @Nullable IContext ctx, int options) {
        return this.uniWhenComplete(null, action, ctx, options);
    }

    @Override
    public Promise<T> whenComplete(TriConsumer<? super IContext, ? super T, ? super Throwable> action) {
        return this.uniWhenComplete(null, action, null, 0);
    }

    @Override
    public Promise<T> whenCompleteAsync(Executor executor, TriConsumer<? super IContext, ? super T, ? super Throwable> action) {
        return this.uniWhenComplete(executor, action, null, 0);
    }

    @Override
    public Promise<T> whenCompleteAsync(Executor executor, TriConsumer<? super IContext, ? super T, ? super Throwable> action, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniWhenComplete(executor, action, ctx, options);
    }

    private Promise<T> uniWhenComplete(Executor executor, TriConsumer<? super IContext, ? super T, ? super Throwable> action, @Nullable IContext ctx, int options) {
        Objects.requireNonNull(action);
        if (ctx == null) {
            ctx = this.inheritContext(options);
        }
        Promise promise = this.newIncompletePromise(executor == null ? this.executor() : executor);
        this.pushCompletion(new UniWhenComplete<T>(executor, ctx, options, this, promise, action));
        return promise;
    }

    @Override
    public void onCompleted(Consumer<? super IFuture<T>> action, int options) {
        this.uniOnCompleted1(null, action, options);
    }

    @Override
    public void onCompleted(Consumer<? super IFuture<T>> action) {
        this.uniOnCompleted1(null, action, 0);
    }

    @Override
    public void onCompletedAsync(Executor executor, Consumer<? super IFuture<T>> action) {
        Objects.requireNonNull(executor);
        this.uniOnCompleted1(executor, action, 0);
    }

    @Override
    public void onCompletedAsync(Executor executor, Consumer<? super IFuture<T>> action, int options) {
        Objects.requireNonNull(executor);
        this.uniOnCompleted1(executor, action, options);
    }

    private void uniOnCompleted1(Executor executor, Consumer<? super IFuture<T>> action, int options) {
        Objects.requireNonNull(action, "action");
        if (action instanceof Completion) {
            Completion completion = (Completion)((Object)action);
            this.pushCompletion(completion);
            return;
        }
        if (this.isDone() && executor == null) {
            UniOnComplete1.fireNow(this, action, null);
        } else {
            this.pushCompletion(new UniOnComplete1(executor, options, this, action));
        }
    }

    @Override
    public void onCompleted(BiConsumer<? super IFuture<T>, ? super IContext> action, @Nonnull IContext context, int options) {
        this.uniOnCompleted2(null, action, context, options);
    }

    @Override
    public void onCompleted(BiConsumer<? super IFuture<T>, ? super IContext> action, @Nonnull IContext context) {
        this.uniOnCompleted2(null, action, context, 0);
    }

    @Override
    public void onCompletedAsync(Executor executor, BiConsumer<? super IFuture<T>, ? super IContext> action, @Nonnull IContext context) {
        Objects.requireNonNull(executor, "executor");
        this.uniOnCompleted2(executor, action, context, 0);
    }

    @Override
    public void onCompletedAsync(Executor executor, BiConsumer<? super IFuture<T>, ? super IContext> action, @Nonnull IContext context, int options) {
        Objects.requireNonNull(executor, "executor");
        this.uniOnCompleted2(executor, action, context, options);
    }

    private void uniOnCompleted2(Executor executor, BiConsumer<? super IFuture<T>, ? super IContext> action, @Nonnull IContext context, int options) {
        Objects.requireNonNull(action, "action");
        Objects.requireNonNull(context, "context");
        if (action instanceof Completion) {
            Completion completion = (Completion)((Object)action);
            this.pushCompletion(completion);
            return;
        }
        if (this.isDone() && executor == null) {
            UniOnComplete2.fireNow(this, action, context, null);
        } else {
            this.pushCompletion(new UniOnComplete2(executor, options, this, action, context));
        }
    }

    private boolean pushCompletion(Completion newHead) {
        if (this.isDone()) {
            newHead.tryFire(0);
            return false;
        }
        Completion expectedHead = this.stack;
        while (expectedHead != TOMBSTONE) {
            newHead.next = expectedHead;
            Completion realHead = VH_STACK.compareAndExchange(this, expectedHead, newHead);
            if (realHead == expectedHead) {
                return true;
            }
            expectedHead = realHead;
        }
        newHead.next = null;
        newHead.tryFire(0);
        return false;
    }

    private static void postComplete(Promise<?> future) {
        Completion next = null;
        block0: while (true) {
            next = Promise.clearListeners(future, next);
            while (next != null) {
                Completion curr = next;
                next = next.next;
                curr.next = null;
                future = curr.tryFire(-1);
                if (future == null) continue;
                continue block0;
            }
            break;
        }
    }

    private static <T> Completion clearListeners(Promise<T> promise, Completion onto) {
        Completion head;
        do {
            if ((head = promise.stack) != TOMBSTONE) continue;
            return onto;
        } while (!VH_STACK.compareAndSet(promise, head, TOMBSTONE));
        Completion ontoHead = onto;
        while (head != null) {
            Completion tmpHead = head;
            head = head.next;
            if (tmpHead instanceof Awaiter) {
                Awaiter awaiter = (Awaiter)tmpHead;
                awaiter.releaseWaiters();
                continue;
            }
            tmpHead.next = ontoHead;
            ontoHead = tmpHead;
        }
        return ontoHead;
    }

    private static <U> Promise<U> postFire(Promise<U> output, int mode, boolean setCompleted) {
        if (!setCompleted) {
            return null;
        }
        if (mode < 0) {
            return output;
        }
        Promise.postComplete(output);
        return null;
    }

    private static boolean tryInline(Completion completion, Executor e, int options) {
        SingleThreadExecutor eventLoop;
        if (TaskOption.isEnabled(options, 524288) && e instanceof SingleThreadExecutor && (eventLoop = (SingleThreadExecutor)e).inEventLoop()) {
            return true;
        }
        if (options != 0 && !TaskOption.isEnabled(options, 0x100000) && e instanceof IExecutor) {
            IExecutor exe = (IExecutor)e;
            exe.execute(completion);
        } else {
            completion.setOptions(0);
            e.execute(completion);
        }
        return false;
    }

    private boolean completeNull() {
        return this.internalComplete(NIL);
    }

    private boolean completeValue(T value) {
        return this.internalComplete(Promise.encodeValue(value));
    }

    private boolean completeCancelled(IContext ctx) {
        int cancelCode = ctx.cancelToken().cancelCode();
        return this.internalComplete(new AltResult((Throwable)StacklessCancellationException.instOf((int)cancelCode)));
    }

    private boolean completeThrowable(@Nonnull Throwable x) {
        FutureLogger.logCause(x);
        return this.internalComplete(Promise.encodeThrowable(x));
    }

    private boolean completeRelay(Object r) {
        return this.internalComplete(r);
    }

    private boolean completeRelayThrowable(AltResult r) {
        return this.internalComplete(r);
    }

    private static <U> boolean tryTransferTo(IFuture<? extends U> input, Promise<U> output) {
        if (input instanceof Promise) {
            Promise promise = (Promise)input;
            Object r = promise.result;
            if (Promise.isDone0(r)) {
                return output.completeRelay(r);
            }
            return false;
        }
        TaskStatus state = input.status();
        switch (state) {
            case PENDING: 
            case COMPUTING: {
                return false;
            }
            case SUCCESS: {
                return output.completeValue(input.resultNow());
            }
            case FAILED: 
            case CANCELLED: {
                Throwable ex = input.exceptionNow(false);
                return output.completeRelayThrowable(new AltResult(ex));
            }
        }
        throw new AssertionError();
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            VH_RESULT = l.findVarHandle(Promise.class, "result", Object.class);
            VH_STACK = l.findVarHandle(Promise.class, "stack", Completion.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
        CLAIMED = Runnable::run;
        TOMBSTONE = new Completion(){

            @Override
            public int getOptions() {
                return 0;
            }

            @Override
            public void setOptions(int options) {
            }

            Promise<Object> tryFire(int mode) {
                return null;
            }
        };
    }

    private static class AltResult {
        final Throwable cause;

        AltResult(Throwable cause) {
            this.cause = cause;
        }
    }

    private static abstract class Completion
    implements ITask {
        Completion next;

        private Completion() {
        }

        public abstract void setOptions(int var1);

        @Override
        public final void run() {
            this.tryFire(1);
        }

        abstract Promise<?> tryFire(int var1);
    }

    private static class Awaiter
    extends Completion {
        final IFuture<?> future;
        @GuardedBy(value="future")
        private int waiterCount;

        public Awaiter(IFuture<?> future) {
            this.future = future;
        }

        @Override
        public int getOptions() {
            return 0;
        }

        @Override
        public void setOptions(int options) {
        }

        @Override
        Promise<?> tryFire(int mode) {
            this.releaseWaiters();
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseWaiters() {
            IFuture<?> iFuture = this.future;
            synchronized (iFuture) {
                if (this.waiterCount > 0) {
                    this.future.notifyAll();
                }
            }
        }

        private void incWaiter() {
            ++this.waiterCount;
        }

        private void decWaiter() {
            --this.waiterCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void await() throws InterruptedException {
            ThreadUtils.checkInterrupted();
            IFuture<?> iFuture = this.future;
            synchronized (iFuture) {
                this.incWaiter();
                try {
                    while (!this.future.isDone()) {
                        this.future.wait();
                    }
                }
                finally {
                    this.decWaiter();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitUninterruptibly() {
            boolean interrupted = Thread.interrupted();
            IFuture<?> iFuture = this.future;
            synchronized (iFuture) {
                this.incWaiter();
                try {
                    while (!this.future.isDone()) {
                        try {
                            this.future.wait();
                        }
                        catch (InterruptedException ignore) {
                            interrupted = true;
                        }
                    }
                }
                finally {
                    this.decWaiter();
                }
            }
            if (interrupted) {
                ThreadUtils.recoveryInterrupted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
            ThreadUtils.checkInterrupted();
            long deadline = System.nanoTime() + timeUnit.toNanos(timeout);
            IFuture<?> iFuture = this.future;
            synchronized (iFuture) {
                this.incWaiter();
                try {
                    while (!this.future.isDone()) {
                        long remainNano = deadline - System.nanoTime();
                        if (remainNano <= 0L) {
                            boolean bl = false;
                            return bl;
                        }
                        this.future.wait(remainNano / 1000000L, (int)(remainNano % 1000000L));
                    }
                    return true;
                }
                finally {
                    this.decWaiter();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        boolean awaitUninterruptibly(long timeout, TimeUnit timeUnit) {
            boolean interrupted = Thread.interrupted();
            long deadline = System.nanoTime() + timeUnit.toNanos(timeout);
            IFuture<?> iFuture = this.future;
            synchronized (iFuture) {
                this.incWaiter();
                try {
                    while (true) {
                        if (!this.future.isDone()) {
                            long remainNano = deadline - System.nanoTime();
                            if (remainNano <= 0L) {
                                boolean bl = false;
                                return bl;
                            }
                            try {
                                this.future.wait(remainNano / 1000000L, (int)(remainNano % 1000000L));
                            }
                            catch (InterruptedException e) {
                                interrupted = true;
                            }
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    this.decWaiter();
                }
            }
            if (interrupted) {
                ThreadUtils.recoveryInterrupted();
            }
            return true;
        }
    }

    private static class UniComposeApply<V, U>
    extends UniCompletion<V, U> {
        BiFunction<? super IContext, ? super V, ? extends ICompletionStage<U>> fn;

        public UniComposeApply(Executor executor, IContext ctx, int options, Promise<V> input, Promise<U> output, BiFunction<? super IContext, ? super V, ? extends ICompletionStage<U>> fn) {
            super(executor, ctx, options, input, output);
            this.fn = fn;
        }

        @Override
        Promise<?> tryFire(int mode) {
            boolean setCompleted;
            Promise input = this.input;
            Promise output = this.output;
            IContext ctx = this.ctx;
            if (output.isDone()) {
                setCompleted = false;
            } else if (ctx.cancelToken().isCancelling()) {
                setCompleted = output.completeCancelled(ctx);
            } else {
                Object r = input.result;
                if (r instanceof AltResult) {
                    AltResult altResult = (AltResult)r;
                    setCompleted = output.completeRelayThrowable(altResult);
                } else {
                    try {
                        if (mode <= 0 && !this.claim()) {
                            return null;
                        }
                        IFuture<U> relay = this.fn.apply(ctx, input.decodeValue(r)).toFuture();
                        setCompleted = Promise.tryTransferTo(relay, output);
                        if (!setCompleted) {
                            relay.onCompleted(new UniRelay<U>(relay, output), 0);
                        }
                    }
                    catch (Throwable e) {
                        setCompleted = output.completeThrowable(e);
                    }
                }
            }
            this.ctx = null;
            this.input = null;
            this.output = null;
            this.fn = null;
            return Promise.postFire(output, mode, setCompleted);
        }
    }

    private static class UniComposeCall<V, U>
    extends UniCompletion<V, U> {
        Function<? super IContext, ? extends ICompletionStage<U>> fn;

        public UniComposeCall(Executor executor, IContext ctx, int options, Promise<V> input, Promise<U> output, Function<? super IContext, ? extends ICompletionStage<U>> fn) {
            super(executor, ctx, options, input, output);
            this.fn = fn;
        }

        @Override
        Promise<?> tryFire(int mode) {
            boolean setCompleted;
            Promise input = this.input;
            Promise output = this.output;
            IContext ctx = this.ctx;
            if (output.isDone()) {
                setCompleted = false;
            } else if (ctx.cancelToken().isCancelling()) {
                setCompleted = output.completeCancelled(ctx);
            } else {
                Object r = input.result;
                if (r instanceof AltResult) {
                    AltResult altResult = (AltResult)r;
                    setCompleted = output.completeRelayThrowable(altResult);
                } else {
                    try {
                        if (mode <= 0 && !this.claim()) {
                            return null;
                        }
                        IFuture<U> relay = this.fn.apply(ctx).toFuture();
                        setCompleted = Promise.tryTransferTo(relay, output);
                        if (!setCompleted) {
                            relay.onCompleted(new UniRelay<U>(relay, output), 0);
                        }
                    }
                    catch (Throwable e) {
                        setCompleted = output.completeThrowable(e);
                    }
                }
            }
            this.ctx = null;
            this.input = null;
            this.output = null;
            this.fn = null;
            return Promise.postFire(output, mode, setCompleted);
        }
    }

    private static class UniComposeCathing<X extends Throwable, V>
    extends UniCompletion<V, V> {
        Class<X> exceptionType;
        BiFunction<? super IContext, ? super X, ? extends ICompletionStage<V>> fallback;

        public UniComposeCathing(Executor executor, IContext ctx, int options, Promise<V> input, Promise<V> output, Class<X> exceptionType, BiFunction<? super IContext, ? super X, ? extends ICompletionStage<V>> fallback) {
            super(executor, ctx, options, input, output);
            this.exceptionType = exceptionType;
            this.fallback = fallback;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        Promise<?> tryFire(int mode) {
            block7: {
                block8: {
                    block6: {
                        input = this.input;
                        output = this.output;
                        ctx = this.ctx;
                        if (!output.isDone()) break block6;
                        setCompleted = false;
                        break block7;
                    }
                    if (!ctx.cancelToken().isCancelling()) break block8;
                    setCompleted = output.completeCancelled(ctx);
                    break block7;
                }
                r = input.result;
                if (!(r instanceof AltResult)) ** GOTO lbl-1000
                altResult = (AltResult)r;
                if (!this.exceptionType.isInstance(altResult.cause)) lbl-1000:
                // 2 sources

                {
                    setCompleted = output.completeRelay(r);
                } else {
                    try {
                        if (mode <= 0 && !this.claim()) {
                            return null;
                        }
                        relay = this.fallback.apply(ctx, this.exceptionType.cast(altResult.cause)).toFuture();
                        setCompleted = Promise.tryTransferTo(relay, output);
                        if (!setCompleted) {
                            relay.onCompleted(new UniRelay<V>(relay, output), 0);
                        }
                    }
                    catch (Throwable e) {
                        setCompleted = output.completeThrowable(e);
                    }
                }
            }
            this.ctx = null;
            this.input = null;
            this.output = null;
            this.exceptionType = null;
            this.fallback = null;
            return Promise.postFire(output, mode, setCompleted);
        }
    }

    private static class UniComposeHandle<V, U>
    extends UniCompletion<V, U> {
        TriFunction<? super IContext, ? super V, ? super Throwable, ? extends ICompletionStage<U>> fn;

        public UniComposeHandle(Executor executor, IContext ctx, int options, Promise<V> input, Promise<U> output, TriFunction<? super IContext, ? super V, ? super Throwable, ? extends ICompletionStage<U>> fn) {
            super(executor, ctx, options, input, output);
            this.fn = fn;
        }

        @Override
        Promise<?> tryFire(int mode) {
            boolean setCompleted;
            Promise input = this.input;
            Promise output = this.output;
            IContext ctx = this.ctx;
            if (output.isDone()) {
                setCompleted = false;
            } else if (ctx.cancelToken().isCancelling()) {
                setCompleted = output.completeCancelled(ctx);
            } else {
                try {
                    IFuture relay;
                    if (mode <= 0 && !this.claim()) {
                        return null;
                    }
                    Object r = input.result;
                    if (r instanceof AltResult) {
                        AltResult altResult = (AltResult)r;
                        relay = ((ICompletionStage)this.fn.apply((Object)ctx, null, (Object)altResult.cause)).toFuture();
                    } else {
                        relay = ((ICompletionStage)this.fn.apply((Object)ctx, input.decodeValue(r), null)).toFuture();
                    }
                    setCompleted = Promise.tryTransferTo(relay, output);
                    if (!setCompleted) {
                        relay.onCompleted(new UniRelay(relay, output), 0);
                    }
                }
                catch (Throwable e) {
                    setCompleted = output.completeThrowable(e);
                }
            }
            this.ctx = null;
            this.input = null;
            this.output = null;
            this.fn = null;
            return Promise.postFire(output, mode, setCompleted);
        }
    }

    private static class UniApply<V, U>
    extends UniCompletion<V, U> {
        BiFunction<? super IContext, ? super V, ? extends U> fn;

        public UniApply(Executor executor, IContext ctx, int options, Promise<V> input, Promise<U> output, BiFunction<? super IContext, ? super V, ? extends U> fn) {
            super(executor, ctx, options, input, output);
            this.fn = fn;
        }

        @Override
        Promise<?> tryFire(int mode) {
            boolean setCompleted;
            Promise input = this.input;
            Promise output = this.output;
            IContext ctx = this.ctx;
            if (output.isDone()) {
                setCompleted = false;
            } else if (ctx.cancelToken().isCancelling()) {
                setCompleted = output.completeCancelled(ctx);
            } else {
                Object r = input.result;
                if (r instanceof AltResult) {
                    AltResult altResult = (AltResult)r;
                    setCompleted = output.completeRelayThrowable(altResult);
                } else {
                    try {
                        if (mode <= 0 && !this.claim()) {
                            return null;
                        }
                        setCompleted = output.completeValue(this.fn.apply(ctx, input.decodeValue(r)));
                    }
                    catch (Throwable e) {
                        setCompleted = output.completeThrowable(e);
                    }
                }
            }
            this.ctx = null;
            this.input = null;
            this.output = null;
            this.fn = null;
            return Promise.postFire(output, mode, setCompleted);
        }
    }

    private static class UniAccept<V>
    extends UniCompletion<V, Void> {
        BiConsumer<? super IContext, ? super V> action;

        public UniAccept(Executor executor, IContext ctx, int options, Promise<V> input, Promise<Void> output, BiConsumer<? super IContext, ? super V> action) {
            super(executor, ctx, options, input, output);
            this.action = action;
        }

        @Override
        Promise<?> tryFire(int mode) {
            boolean setCompleted;
            Promise input = this.input;
            Promise output = this.output;
            IContext ctx = this.ctx;
            if (output.isDone()) {
                setCompleted = false;
            } else if (ctx.cancelToken().isCancelling()) {
                setCompleted = output.completeCancelled(ctx);
            } else {
                Object r = input.result;
                if (r instanceof AltResult) {
                    AltResult altResult = (AltResult)r;
                    setCompleted = output.completeRelayThrowable(altResult);
                } else {
                    try {
                        if (mode <= 0 && !this.claim()) {
                            return null;
                        }
                        this.action.accept(ctx, input.decodeValue(r));
                        setCompleted = output.completeNull();
                    }
                    catch (Throwable e) {
                        setCompleted = output.completeThrowable(e);
                    }
                }
            }
            this.ctx = null;
            this.input = null;
            this.output = null;
            this.action = null;
            return Promise.postFire(output, mode, setCompleted);
        }
    }

    private static class UniCall<V, U>
    extends UniCompletion<V, U> {
        Function<? super IContext, ? extends U> fn;

        public UniCall(Executor executor, IContext ctx, int options, Promise<V> input, Promise<U> output, Function<? super IContext, ? extends U> fn) {
            super(executor, ctx, options, input, output);
            this.fn = fn;
        }

        @Override
        Promise<?> tryFire(int mode) {
            boolean setCompleted;
            Promise input = this.input;
            Promise output = this.output;
            IContext ctx = this.ctx;
            if (output.isDone()) {
                setCompleted = false;
            } else if (ctx.cancelToken().isCancelling()) {
                setCompleted = output.completeCancelled(ctx);
            } else {
                Object r = input.result;
                if (r instanceof AltResult) {
                    AltResult altResult = (AltResult)r;
                    setCompleted = output.completeRelayThrowable(altResult);
                } else {
                    try {
                        if (mode <= 0 && !this.claim()) {
                            return null;
                        }
                        setCompleted = output.completeValue(this.fn.apply(ctx));
                    }
                    catch (Throwable e) {
                        setCompleted = output.completeThrowable(e);
                    }
                }
            }
            this.ctx = null;
            this.input = null;
            this.output = null;
            this.fn = null;
            return Promise.postFire(output, mode, setCompleted);
        }
    }

    private static class UniRun<V>
    extends UniCompletion<V, Void> {
        Consumer<? super IContext> action;

        public UniRun(Executor executor, IContext ctx, int options, Promise<V> input, Promise<Void> output, Consumer<? super IContext> action) {
            super(executor, ctx, options, input, output);
            this.action = action;
        }

        @Override
        Promise<?> tryFire(int mode) {
            boolean setCompleted;
            Promise input = this.input;
            Promise output = this.output;
            IContext ctx = this.ctx;
            if (output.isDone()) {
                setCompleted = false;
            } else if (ctx.cancelToken().isCancelling()) {
                setCompleted = output.completeCancelled(ctx);
            } else {
                Object r = input.result;
                if (r instanceof AltResult) {
                    AltResult altResult = (AltResult)r;
                    setCompleted = output.completeRelayThrowable(altResult);
                } else {
                    try {
                        if (mode <= 0 && !this.claim()) {
                            return null;
                        }
                        this.action.accept(ctx);
                        setCompleted = output.completeNull();
                    }
                    catch (Throwable e) {
                        setCompleted = output.completeThrowable(e);
                    }
                }
            }
            this.ctx = null;
            this.input = null;
            this.output = null;
            this.action = null;
            return Promise.postFire(output, mode, setCompleted);
        }
    }

    private static class UniCathing<X extends Throwable, V>
    extends UniCompletion<V, V> {
        Class<X> exceptionType;
        BiFunction<? super IContext, ? super X, ? extends V> fallback;

        public UniCathing(Executor executor, IContext ctx, int options, Promise<V> input, Promise<V> output, Class<X> exceptionType, BiFunction<? super IContext, ? super X, ? extends V> fallback) {
            super(executor, ctx, options, input, output);
            this.exceptionType = exceptionType;
            this.fallback = fallback;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        Promise<?> tryFire(int mode) {
            block6: {
                block7: {
                    block5: {
                        input = this.input;
                        output = this.output;
                        ctx = this.ctx;
                        if (!output.isDone()) break block5;
                        setCompleted = false;
                        break block6;
                    }
                    if (!ctx.cancelToken().isCancelling()) break block7;
                    setCompleted = output.completeCancelled(ctx);
                    break block6;
                }
                r = input.result;
                if (!(r instanceof AltResult)) ** GOTO lbl-1000
                altResult = (AltResult)r;
                if (!this.exceptionType.isInstance(altResult.cause)) lbl-1000:
                // 2 sources

                {
                    setCompleted = output.completeRelay(r);
                } else {
                    try {
                        if (mode <= 0 && !this.claim()) {
                            return null;
                        }
                        fr = this.fallback.apply(ctx, this.exceptionType.cast(altResult.cause));
                        setCompleted = output.completeValue(fr);
                    }
                    catch (Throwable e) {
                        setCompleted = output.completeThrowable(e);
                    }
                }
            }
            this.ctx = null;
            this.input = null;
            this.output = null;
            this.exceptionType = null;
            this.fallback = null;
            return Promise.postFire(output, mode, setCompleted);
        }
    }

    private static class UniHandle<V, U>
    extends UniCompletion<V, U> {
        TriFunction<? super IContext, ? super V, ? super Throwable, ? extends U> fn;

        public UniHandle(Executor executor, IContext ctx, int options, Promise<V> input, Promise<U> output, TriFunction<? super IContext, ? super V, ? super Throwable, ? extends U> fn) {
            super(executor, ctx, options, input, output);
            this.fn = fn;
        }

        @Override
        Promise<?> tryFire(int mode) {
            boolean setCompleted;
            Promise input = this.input;
            Promise output = this.output;
            IContext ctx = this.ctx;
            if (output.isDone()) {
                setCompleted = false;
            } else if (ctx.cancelToken().isCancelling()) {
                setCompleted = output.completeCancelled(ctx);
            } else {
                try {
                    Object relay;
                    if (mode <= 0 && !this.claim()) {
                        return null;
                    }
                    Object r = input.result;
                    if (r instanceof AltResult) {
                        AltResult altResult = (AltResult)r;
                        relay = this.fn.apply((Object)ctx, null, (Object)altResult.cause);
                    } else {
                        relay = this.fn.apply((Object)ctx, input.decodeValue(r), null);
                    }
                    setCompleted = output.completeValue(relay);
                }
                catch (Throwable e) {
                    setCompleted = output.completeThrowable(e);
                }
            }
            this.ctx = null;
            this.input = null;
            this.output = null;
            this.fn = null;
            return Promise.postFire(output, mode, setCompleted);
        }
    }

    private static class UniWhenComplete<V>
    extends UniCompletion<V, V> {
        TriConsumer<? super IContext, ? super V, ? super Throwable> action;

        public UniWhenComplete(Executor executor, IContext ctx, int options, Promise<V> input, Promise<V> output, TriConsumer<? super IContext, ? super V, ? super Throwable> action) {
            super(executor, ctx, options, input, output);
            this.action = action;
        }

        @Override
        Promise<?> tryFire(int mode) {
            boolean setCompleted;
            Promise output;
            block11: {
                Promise input = this.input;
                output = this.output;
                IContext ctx = this.ctx;
                if (output.isDone()) {
                    setCompleted = false;
                } else if (ctx.cancelToken().isCancelling()) {
                    setCompleted = output.completeCancelled(ctx);
                } else {
                    try {
                        if (mode <= 0 && !this.claim()) {
                            return null;
                        }
                    }
                    catch (Throwable ex) {
                        setCompleted = output.trySetException(ex);
                        break block11;
                    }
                    Object r = input.result;
                    try {
                        if (r instanceof AltResult) {
                            AltResult altResult = (AltResult)r;
                            this.action.accept((Object)ctx, null, (Object)altResult.cause);
                        } else {
                            this.action.accept((Object)ctx, input.decodeValue(r), null);
                        }
                        setCompleted = output.completeRelay(r);
                    }
                    catch (Throwable e) {
                        FutureLogger.logCause(e, "UniWhenComplete caught an exception");
                        setCompleted = output.completeRelay(r);
                    }
                }
            }
            this.ctx = null;
            this.input = null;
            this.output = null;
            this.action = null;
            return Promise.postFire(output, mode, setCompleted);
        }
    }

    private static class UniOnComplete1<T>
    extends UniOnComplete<T> {
        Consumer<? super IFuture<T>> action;

        public UniOnComplete1(Executor executor, int options, Promise<T> input, Consumer<? super IFuture<T>> action) {
            super(executor, options, input);
            this.action = action;
        }

        @Override
        Promise<?> tryFire(int mode) {
            Promise input = this.input;
            if (!UniOnComplete1.fireNow(input, this.action, mode > 0 ? null : this)) {
                return null;
            }
            this.executor = null;
            this.input = null;
            this.action = null;
            return null;
        }

        static <T> boolean fireNow(Promise<T> input, Consumer<? super IFuture<T>> action, UniOnComplete1<T> c) {
            try {
                if (c != null && !c.claim()) {
                    return false;
                }
                action.accept(input);
            }
            catch (Throwable e) {
                FutureLogger.logCause(e, "UniOnComplete1 caught an exception");
            }
            return true;
        }
    }

    private static class UniOnComplete2<T>
    extends UniOnComplete<T> {
        BiConsumer<? super IFuture<T>, ? super IContext> action;
        IContext ctx;

        public UniOnComplete2(Executor executor, int options, Promise<T> input, BiConsumer<? super IFuture<T>, ? super IContext> action, IContext ctx) {
            super(executor, options, input);
            this.action = action;
            this.ctx = ctx;
        }

        @Override
        Promise<?> tryFire(int mode) {
            Promise input = this.input;
            if (!this.ctx.cancelToken().isCancelling() && !UniOnComplete2.fireNow(input, this.action, this.ctx, mode > 0 ? null : this)) {
                return null;
            }
            this.executor = null;
            this.input = null;
            this.action = null;
            this.ctx = null;
            return null;
        }

        static <T> boolean fireNow(Promise<T> input, BiConsumer<? super IFuture<T>, ? super IContext> action, IContext ctx, UniOnComplete2<T> c) {
            try {
                if (c != null && !c.claim()) {
                    return false;
                }
                action.accept(input, ctx);
            }
            catch (Throwable e) {
                FutureLogger.logCause(e, "UniOnComplete2 caught an exception");
            }
            return true;
        }
    }

    private static abstract class UniOnComplete<T>
    extends Completion {
        Executor executor;
        int options;
        Promise<T> input;

        public UniOnComplete(Executor executor, int options, Promise<T> input) {
            this.options = options;
            this.executor = executor;
            this.input = input;
        }

        @Override
        public int getOptions() {
            return this.options;
        }

        @Override
        public void setOptions(int options) {
            this.options = options;
        }

        final boolean claim() {
            Executor e = this.executor;
            if (e == CLAIMED) {
                return true;
            }
            this.executor = CLAIMED;
            if (e != null) {
                return Promise.tryInline(this, e, this.options);
            }
            return true;
        }
    }

    private static class UniRelay<V>
    extends Completion
    implements Consumer<IFuture<? extends V>> {
        IFuture<? extends V> input;
        Promise<V> output;

        public UniRelay(IFuture<? extends V> input, Promise<V> output) {
            this.input = input;
            this.output = output;
        }

        @Override
        public int getOptions() {
            return 0;
        }

        @Override
        public void setOptions(int options) {
        }

        @Override
        public void accept(IFuture<? extends V> iFuture) {
            this.tryFire(0);
        }

        @Override
        Promise<?> tryFire(int mode) {
            IFuture<? extends V> input = this.input;
            Promise<V> output = this.output;
            boolean setCompleted = output.isDone() ? false : Promise.tryTransferTo(input, output);
            this.input = null;
            this.output = null;
            return Promise.postFire(output, mode, setCompleted);
        }
    }

    private static abstract class UniCompletion<V, U>
    extends Completion {
        Executor executor;
        IContext ctx;
        int options;
        Promise<V> input;
        Promise<U> output;

        public UniCompletion(Executor executor, IContext context, int options, Promise<V> input, Promise<U> output) {
            this.executor = executor;
            this.ctx = context;
            this.input = input;
            this.output = output;
            this.options = options;
        }

        @Override
        public int getOptions() {
            return this.options;
        }

        @Override
        public void setOptions(int options) {
            this.options = options;
        }

        final boolean claim() {
            Executor e = this.executor;
            if (e == CLAIMED) {
                return true;
            }
            if (!this.output.trySetComputing()) {
                throw StacklessCancellationException.INST1;
            }
            this.executor = CLAIMED;
            if (e != null) {
                return Promise.tryInline(this, e, this.options);
            }
            return true;
        }
    }
}

