/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.concurrent.FutureLogger;
import cn.wjybxx.concurrent.IContext;
import cn.wjybxx.concurrent.IFutureTask;
import cn.wjybxx.concurrent.IPromise;
import cn.wjybxx.concurrent.TaskBuilder;
import cn.wjybxx.concurrent.TaskOption;
import cn.wjybxx.concurrent.TimeSharingTask;
import cn.wjybxx.disruptor.StacklessTimeoutException;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;

public class PromiseTask<V>
implements IFutureTask<V> {
    protected static final int MASK_PRIORITY = 15;
    protected static final int MASK_TASK_TYPE = 240;
    protected static final int MASK_SCHEDULE_TYPE = 3840;
    protected static final int MASK_CLAIMED = 65536;
    protected static final int MASK_STARTED = 131072;
    protected static final int MASK_STOPPED = 262144;
    protected static final int MASK_TIMEOUT = 0x100000;
    protected static final int MASK_TRIGGERED = 0x200000;
    protected static final int OFFSET_PRIORITY = 0;
    protected static final int OFFSET_TASK_TYPE = 4;
    protected static final int OFFSET_SCHEDULE_TYPE = 8;
    protected static final int MAX_PRIORITY = 15;
    private Object task;
    protected IContext ctx;
    protected final int options;
    protected final IPromise<V> promise;
    protected int ctl;

    public PromiseTask(Object task, IContext ctx, int options, IPromise<V> promise) {
        this(task, ctx, options, promise, TaskBuilder.taskType(task));
    }

    public PromiseTask(TaskBuilder<V> builder, IPromise<V> promise) {
        this(builder.getTask(), builder.getCtx(), builder.getOptions(), promise, builder.getType());
    }

    public PromiseTask(Object task, IContext ctx, int options, IPromise<V> promise, int taskType) {
        this.task = Objects.requireNonNull(task, "action");
        this.ctx = ctx == null ? IContext.NONE : ctx;
        this.options = options;
        this.promise = Objects.requireNonNull(promise, "promise");
        this.ctl |= taskType << 4;
        if (taskType == 4) {
            TimeSharingTask timeSharingTask = (TimeSharingTask)task;
            timeSharingTask.inject(this.ctx, this.promise);
        }
    }

    public static PromiseTask<?> ofAction(Runnable action, IContext ctx, int options, IPromise<?> promise) {
        return new PromiseTask(action, ctx, options, promise, 0);
    }

    public static PromiseTask<?> ofAction(Consumer<? super IContext> action, IContext ctx, int options, IPromise<?> promise) {
        return new PromiseTask(action, ctx, options, promise, 1);
    }

    public static <V> PromiseTask<V> ofFunction(Callable<? extends V> action, IContext ctx, int options, IPromise<V> promise) {
        return new PromiseTask<V>(action, ctx, options, promise, 2);
    }

    public static <V> PromiseTask<V> ofFunction(Function<? super IContext, ? extends V> action, IContext ctx, int options, IPromise<V> promise) {
        return new PromiseTask<V>(action, ctx, options, promise, 3);
    }

    public static <V> PromiseTask<V> ofBuilder(TaskBuilder<V> builder, IPromise<V> promise) {
        return new PromiseTask<V>(builder, promise);
    }

    @Override
    public final int getOptions() {
        return this.options;
    }

    public final boolean isEnabled(int taskOption) {
        return TaskOption.isEnabled(this.options, taskOption);
    }

    public final Object getTask() {
        return this.task;
    }

    public final int getTaskType() {
        return (this.ctl & 0xF0) >> 4;
    }

    protected final boolean isStarted() {
        return (this.ctl & 0x20000) != 0;
    }

    protected final void setStarted() {
        this.ctl |= 0x20000;
    }

    protected final boolean getCtlBit(int mask) {
        return (this.ctl & mask) != 0;
    }

    protected final void setCtlBit(int mask, boolean value) {
        this.ctl = value ? (this.ctl |= mask) : (this.ctl &= ~mask);
    }

    @Override
    public IPromise<V> future() {
        return this.promise;
    }

    public void clear() {
        this.task = null;
        this.ctx = null;
    }

    protected final void runTimeSharing() throws Exception {
        TimeSharingTask task = (TimeSharingTask)this.task;
        if (!this.isStarted()) {
            IPromise<V> promise = this.promise;
            IContext ctx = this.ctx;
            task.start(ctx, promise);
            this.setStarted();
            if (promise.isDone()) {
                PromiseTask.stopTask(task, promise, ctx);
                return;
            }
            StopInvoker invoker = new StopInvoker(task, ctx);
            promise.onCompletedAsync(promise.executor(), invoker, 524288);
        }
        task.update(this.ctx, this.promise);
    }

    protected final V runTask() throws Exception {
        int type = (this.ctl & 0xF0) >> 4;
        switch (type) {
            case 0: {
                Runnable task = (Runnable)this.task;
                task.run();
                return null;
            }
            case 2: {
                Callable task = (Callable)this.task;
                return task.call();
            }
            case 3: {
                Function task = (Function)this.task;
                return (V)task.apply(this.ctx);
            }
            case 1: {
                Consumer task = (Consumer)this.task;
                task.accept(this.ctx);
                return null;
            }
        }
        throw new AssertionError((Object)("type: " + type));
    }

    @Override
    public void run() {
        IPromise<V> promise = this.promise;
        IContext ctx = this.ctx;
        if (ctx.cancelToken().isCancelling()) {
            PromiseTask.trySetCancelled(promise, ctx);
            this.clear();
            return;
        }
        if (promise.trySetComputing()) {
            try {
                if (this.getTaskType() == 4) {
                    this.runTimeSharing();
                    if (!promise.isDone()) {
                        promise.trySetException((Throwable)StacklessTimeoutException.INST);
                    }
                } else {
                    V result = this.runTask();
                    promise.trySetResult(result);
                }
            }
            catch (Throwable e) {
                promise.trySetException(e);
            }
        }
        this.clear();
    }

    protected static void trySetCancelled(IPromise<?> promise, IContext ctx) {
        int cancelCode = ctx.cancelToken().cancelCode();
        assert (cancelCode != 0);
        promise.trySetCancelled(cancelCode);
    }

    protected static void trySetCancelled(IPromise<?> promise, IContext ctx, int def) {
        int cancelCode = ctx.cancelToken().cancelCode();
        if (cancelCode == 0) {
            cancelCode = def;
        }
        promise.trySetCancelled(cancelCode);
    }

    private static <V> void stopTask(TimeSharingTask<V> task, IPromise<V> promise, IContext ctx) {
        try {
            task.stop(ctx, promise);
        }
        catch (Throwable ex) {
            FutureLogger.logCause(ex, "task.stop caught exception");
        }
    }

    private static class StopInvoker<V>
    implements Consumer<Future<?>> {
        TimeSharingTask<V> task;
        IContext ctx;

        public StopInvoker(TimeSharingTask<V> task, IContext ctx) {
            this.task = task;
            this.ctx = ctx;
        }

        @Override
        public void accept(Future<?> future) {
            IPromise promise = (IPromise)future;
            PromiseTask.stopTask(this.task, promise, this.ctx);
            this.task = null;
        }
    }
}

