/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

public final class TaskOption {
    public static final int MASK_SCHEDULE_PHASE = 63;
    public static final int MASK_PRIORITY = 960;
    public static final int SCHEDULE_BARRIER = 4096;
    public static final int LOCAL_ORDER = 8192;
    public static final int WAKEUP_THREAD = 16384;
    public static final int CAUGHT_EXCEPTION = 32768;
    public static final int TIMEOUT_BEFORE_RUN = 65536;
    public static final int IGNORE_FUTURE_CANCEL = 131072;
    public static final int STAGE_INHERIT_TOKEN = 18;
    public static final int STAGE_TRY_INLINE = 524288;
    public static final int STAGE_NON_TRANSITIVE = 0x100000;
    public static final int STAGE_CHECK_OBJECT_CTX = 0x200000;
    private static final int IGNORE_DEADLOCK = 0x400000;
    public static final int OFFSET_PRIORITY = 6;
    public static final int MAX_SCHEDULE_PHASE = 63;
    public static final int MAX_PRIORITY = 15;

    public static boolean isEnabled(int flags, int option) {
        return (flags & option) == option;
    }

    public static boolean isDisabled(int flags, int option) {
        return (flags & option) != option;
    }

    public static int enable(int flags, int option) {
        return flags | option;
    }

    public static int disable(int flags, int option) {
        return flags & ~option;
    }

    public static int setEnable(int flags, int option, boolean enable) {
        if (enable) {
            return flags | option;
        }
        return flags & ~option;
    }

    public static int getSchedulePhase(int options) {
        return options & 0x3F;
    }

    public static int setSchedulePhase(int options, int phase) {
        if (phase < 0 || phase > 63) {
            throw new IllegalArgumentException("phase: " + phase);
        }
        options &= 0xFFFFFFC0;
        return options |= phase;
    }

    public static int getPriority(int options) {
        return (options & 0x3C0) >> 6;
    }

    public static int setPriority(int options, int priority) {
        if (priority < 0 || priority > 15) {
            throw new IllegalArgumentException("priority: " + priority);
        }
        options &= 0xFFFFFC3F;
        return options |= priority << 6;
    }
}

