/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.sequential;

import cn.wjybxx.concurrent.IFuture;
import cn.wjybxx.concurrent.IFutureTask;
import cn.wjybxx.sequential.AbstractUniExecutor;
import cn.wjybxx.sequential.UniPromise;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class DefaultUniExecutor
extends AbstractUniExecutor {
    private final Deque<Runnable> taskQueue = new ArrayDeque<Runnable>();
    private final UniPromise<Void> terminationPromise = new UniPromise(this);
    private final IFuture<Void> terminationFuture = this.terminationPromise.asReadonly();
    private int state = 0;
    private final int countLimit;
    private final long nanoTimeLimit;

    public DefaultUniExecutor() {
        this(-1, -1L, TimeUnit.NANOSECONDS);
    }

    public DefaultUniExecutor(int countLimit) {
        this(countLimit, -1L, TimeUnit.NANOSECONDS);
    }

    public DefaultUniExecutor(int countLimit, long timeLimit, TimeUnit timeUnit) {
        DefaultUniExecutor.ensureNegativeOneOrPositive(countLimit, "countLimit");
        DefaultUniExecutor.ensureNegativeOneOrPositive(timeLimit, "timeLimit");
        this.countLimit = countLimit;
        this.nanoTimeLimit = timeLimit > 0L ? timeUnit.toNanos(timeLimit) : -1L;
    }

    private static void ensureNegativeOneOrPositive(long val, String name) {
        if (val != -1L && val <= 0L) {
            throw new IllegalArgumentException(name + " must be -1 or positive");
        }
    }

    @Override
    public void update() {
        int batchSize = this.countLimit;
        long nanosPerFrame = this.nanoTimeLimit;
        Deque<Runnable> taskQueue = this.taskQueue;
        int count = 0;
        if (nanosPerFrame <= 0L) {
            Runnable task;
            while ((task = taskQueue.pollFirst()) != null) {
                try {
                    task.run();
                }
                catch (Throwable e) {
                    DefaultUniExecutor.logCause(e);
                }
                if (batchSize <= 0 || ++count < batchSize) continue;
                break;
            }
        } else {
            Runnable task;
            long startTime = System.nanoTime();
            while ((task = taskQueue.pollFirst()) != null) {
                try {
                    task.run();
                }
                catch (Throwable e) {
                    DefaultUniExecutor.logCause(e);
                }
                if ((batchSize <= 0 || ++count < batchSize) && System.nanoTime() - startTime < nanosPerFrame) continue;
            }
        }
        if (this.isShuttingDown() && taskQueue.isEmpty()) {
            this.state = 5;
            this.terminationPromise.trySetResult(null);
        }
    }

    @Override
    public boolean needMoreUpdate() {
        return !this.taskQueue.isEmpty();
    }

    @Override
    public void execute(Runnable command) {
        if (this.isShutdown()) {
            if (command instanceof IFutureTask) {
                IFutureTask promiseTask = (IFutureTask)command;
                promiseTask.future().trySetCancelled(3);
            }
            return;
        }
        this.taskQueue.offer(command);
    }

    @Override
    public void shutdown() {
        if (this.state < 3) {
            this.state = 3;
        }
    }

    @Override
    @Nonnull
    public List<Runnable> shutdownNow() {
        ArrayList<Runnable> result = new ArrayList<Runnable>(this.taskQueue);
        this.taskQueue.clear();
        this.state = 5;
        this.terminationPromise.trySetResult(null);
        return result;
    }

    @Override
    public boolean isShuttingDown() {
        return this.state >= 3;
    }

    @Override
    public boolean isShutdown() {
        return this.state >= 4;
    }

    @Override
    public boolean isTerminated() {
        return this.state == 5;
    }

    @Override
    public IFuture<?> terminationFuture() {
        return this.terminationFuture;
    }
}

