/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.sequential;

import cn.wjybxx.concurrent.AggregateOptions;
import cn.wjybxx.concurrent.IFuture;
import cn.wjybxx.concurrent.IPromise;
import cn.wjybxx.concurrent.TaskInsufficientException;
import cn.wjybxx.sequential.UniPromise;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class UniFutureCombiner {
    private ChildListener childrenListener = new ChildListener();
    private final Executor executor;
    private IPromise<Object> aggregatePromise;
    private int futureCount;
    private static final Object NIL = new Object();

    public UniFutureCombiner(Executor executor) {
        this.executor = Objects.requireNonNull(executor);
    }

    public UniFutureCombiner add(IFuture<?> future) {
        Objects.requireNonNull(future);
        ChildListener childrenListener = this.childrenListener;
        if (childrenListener == null) {
            throw new IllegalStateException("Adding futures is not allowed after finished adding");
        }
        ++this.futureCount;
        future.onCompleted(childrenListener, 0);
        return this;
    }

    public int futureCount() {
        return this.futureCount;
    }

    public UniFutureCombiner setAggregatePromise(IPromise<Object> aggregatePromise) {
        this.aggregatePromise = aggregatePromise;
        return this;
    }

    public void clear() {
        this.futureCount = 0;
        this.childrenListener = new ChildListener();
    }

    public IPromise<Object> anyOf() {
        return this.finish(AggregateOptions.anyOf());
    }

    public IPromise<Object> selectN(int successRequire, boolean failFast) {
        return this.finish(AggregateOptions.selectN(successRequire, failFast));
    }

    public IPromise<Object> selectAll() {
        return this.selectN(this.futureCount(), true);
    }

    public IPromise<Object> selectAll(boolean failFast) {
        return this.selectN(this.futureCount(), failFast);
    }

    private IPromise<Object> finish(AggregateOptions options) {
        Objects.requireNonNull(options);
        ChildListener childrenListener = this.childrenListener;
        if (childrenListener == null) {
            throw new IllegalStateException("Already finished");
        }
        this.childrenListener = null;
        IPromise<Object> aggregatePromise = this.aggregatePromise;
        if (aggregatePromise == null) {
            aggregatePromise = new UniPromise<Object>(this.executor);
        } else {
            this.aggregatePromise = null;
        }
        childrenListener.futureCount = this.futureCount;
        childrenListener.options = options;
        childrenListener.aggregatePromise = aggregatePromise;
        childrenListener.checkComplete();
        return aggregatePromise;
    }

    public UniFutureCombiner addAll(IFuture<?> ... futures) {
        for (IFuture<?> future : futures) {
            this.add(future);
        }
        return this;
    }

    public UniFutureCombiner addAll(Collection<? extends IFuture<?>> futures) {
        for (IFuture<?> future : futures) {
            this.add(future);
        }
        return this;
    }

    private static Object encodeValue(Object val) {
        return val == null ? NIL : val;
    }

    private static Object decodeValue(Object r) {
        return r == NIL ? null : r;
    }

    private static class ChildListener
    implements Consumer<IFuture<?>> {
        private int succeedCount;
        private int doneCount;
        private Object result;
        private Throwable cause;
        private int futureCount;
        private AggregateOptions options;
        private IPromise<Object> aggregatePromise;

        private ChildListener() {
        }

        @Override
        public void accept(IFuture<?> future) {
            if (future.isFailed()) {
                this.accept(null, future.exceptionNow(false));
            } else {
                this.accept(future.resultNow(), null);
            }
        }

        public void accept(Object r, Throwable throwable) {
            if (throwable == null) {
                this.result = UniFutureCombiner.encodeValue(r);
                ++this.succeedCount;
            } else if (this.cause == null) {
                this.cause = throwable;
            }
            ++this.doneCount;
            IPromise<Object> aggregatePromise = this.aggregatePromise;
            if (aggregatePromise != null && !aggregatePromise.isDone() && this.checkComplete()) {
                this.result = null;
                this.cause = null;
            }
        }

        boolean checkComplete() {
            int doneCount = this.doneCount;
            int succeedCount = this.succeedCount;
            if (this.futureCount == 0) {
                return this.aggregatePromise.trySetResult(null);
            }
            if (this.options.isAnyOf()) {
                if (doneCount == 0) {
                    return false;
                }
                if (this.result != null) {
                    return this.aggregatePromise.trySetResult(UniFutureCombiner.decodeValue(this.result));
                }
                return this.aggregatePromise.trySetException(this.cause);
            }
            if (!this.options.failFast && doneCount < this.futureCount) {
                return false;
            }
            int successRequire = this.options.successRequire;
            if (succeedCount >= successRequire) {
                return this.aggregatePromise.trySetResult(null);
            }
            if (succeedCount + (this.futureCount - doneCount) < successRequire) {
                if (this.cause == null) {
                    this.cause = TaskInsufficientException.create(this.futureCount, doneCount, succeedCount, successRequire);
                }
                return this.aggregatePromise.trySetException(this.cause);
            }
            return false;
        }
    }
}

