/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.AlertException;
import cn.wjybxx.disruptor.ConsumerBarrier;
import cn.wjybxx.disruptor.ProducerBarrier;
import cn.wjybxx.disruptor.Sequence;
import cn.wjybxx.disruptor.SequenceBarrier;
import cn.wjybxx.disruptor.Util;
import cn.wjybxx.disruptor.WaitStrategy;
import java.util.Objects;
import java.util.concurrent.TimeoutException;

public class MultiConsumerBarrier
implements ConsumerBarrier {
    private final ProducerBarrier producerBarrier;
    private final WaitStrategy waitStrategy;
    private final Sequence groupSequence = new Sequence(-1L);
    private final Sequence[] memberSequences;
    private final SequenceBarrier[] dependentBarriers;
    private volatile boolean alerted = false;

    public MultiConsumerBarrier(ProducerBarrier producerBarrier, int memberCount, WaitStrategy waitStrategy, SequenceBarrier ... dependentBarriers) {
        Objects.requireNonNull(dependentBarriers, "dependentBarriers");
        Util.checkNullElements(dependentBarriers, "dependentBarriers");
        if (dependentBarriers.length == 0) {
            dependentBarriers = new SequenceBarrier[]{producerBarrier};
        }
        this.memberSequences = new Sequence[memberCount];
        for (int i = 0; i < memberCount; ++i) {
            this.memberSequences[i] = new Sequence();
        }
        this.producerBarrier = Objects.requireNonNull(producerBarrier);
        this.waitStrategy = Objects.requireNonNull(waitStrategy);
        this.dependentBarriers = dependentBarriers;
    }

    @Override
    public long waitFor(long sequence) throws AlertException, InterruptedException, TimeoutException {
        this.checkAlert();
        long availableSequence = this.waitStrategy.waitFor(sequence, this.producerBarrier, this);
        if (availableSequence < sequence) {
            return availableSequence;
        }
        return this.producerBarrier.getHighestPublishedSequence(sequence, availableSequence);
    }

    @Override
    public boolean isAlerted() {
        return this.alerted;
    }

    @Override
    public void alert() {
        this.alerted = true;
        this.producerBarrier.signalAllWhenBlocking();
    }

    @Override
    public void clearAlert() {
        this.alerted = false;
    }

    @Override
    public void checkAlert() throws AlertException {
        if (this.alerted) {
            throw AlertException.INSTANCE;
        }
    }

    @Override
    @Deprecated
    public void claim(long sequence) {
        this.groupSequence.setRelease(sequence);
        for (Sequence memberSequence : this.memberSequences) {
            memberSequence.setRelease(sequence);
        }
    }

    @Override
    public Sequence memberSequence(int index) {
        return this.memberSequences[index];
    }

    @Override
    public Sequence groupSequence() {
        return this.groupSequence;
    }

    @Override
    public long sequence() {
        return Util.getMinimumSequence(this.memberSequences, this.groupSequence.getVolatile());
    }

    @Override
    public long dependentSequence() {
        return Util.getMinimumSequence(this.dependentBarriers);
    }

    @Override
    public long minimumSequence() {
        return Util.getMinimumSequence(this.dependentBarriers, this.groupSequence.getVolatile());
    }

    @Override
    public void addDependentBarriers(SequenceBarrier ... barriersToTrack) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeDependentBarrier(SequenceBarrier barrier) {
        return false;
    }
}

