/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.ConsumerBarrier;
import cn.wjybxx.disruptor.EventFactory;
import cn.wjybxx.disruptor.EventSequencer;
import cn.wjybxx.disruptor.EventSequencerBuilder;
import cn.wjybxx.disruptor.MultiProducerSequencer;
import cn.wjybxx.disruptor.ProducerBarrier;
import cn.wjybxx.disruptor.ProducerType;
import cn.wjybxx.disruptor.RingBuffer;
import cn.wjybxx.disruptor.RingBufferSequencer;
import cn.wjybxx.disruptor.SequenceBarrier;
import cn.wjybxx.disruptor.Sequencer;
import cn.wjybxx.disruptor.SingleProducerSequencer;
import cn.wjybxx.disruptor.WaitStrategy;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class RingBufferEventSequencer<E>
implements EventSequencer<E> {
    private final RingBuffer<E> buffer;
    private final RingBufferSequencer sequencer;

    public RingBufferEventSequencer(Builder<E> builder) {
        Objects.requireNonNull(builder);
        this.buffer = new RingBuffer(builder.getFactory(), builder.getBufferSize());
        this.sequencer = builder.getProducerType() == ProducerType.MULTI ? new MultiProducerSequencer(builder.getBufferSize(), builder.getProducerSleepNanos(), builder.getWaitStrategy(), builder.getBlocker()) : new SingleProducerSequencer(builder.getBufferSize(), builder.getProducerSleepNanos(), builder.getWaitStrategy(), builder.getBlocker());
    }

    public RingBuffer<E> getBuffer() {
        return this.buffer;
    }

    @Override
    public final E get(long sequence) {
        return this.buffer.elementAt(sequence);
    }

    @Override
    public final E producerGet(long sequence) {
        return this.buffer.elementAt(sequence);
    }

    @Override
    public final E consumerGet(long sequence) {
        return this.buffer.elementAt(sequence);
    }

    @Override
    public void producerSet(long sequence, E data) {
        Objects.requireNonNull(data);
        this.buffer.setElement(sequence, data);
    }

    @Override
    public void consumerSet(long sequence, E data) {
        this.buffer.setElement(sequence, data);
    }

    @Override
    public int capacity() {
        return this.buffer.getBufferSize();
    }

    @Override
    public long remainingCapacity() {
        return this.sequencer.remainingCapacity();
    }

    @Override
    public Sequencer sequencer() {
        return this.sequencer;
    }

    @Override
    public ProducerBarrier producerBarrier() {
        return this.sequencer;
    }

    @Override
    public void addGatingBarriers(SequenceBarrier ... gatingBarriers) {
        this.sequencer.addGatingBarriers(gatingBarriers);
    }

    @Override
    public boolean removeGatingBarrier(SequenceBarrier gatingBarrier) {
        return this.sequencer.removeGatingBarrier(gatingBarrier);
    }

    @Override
    public ConsumerBarrier newSingleConsumerBarrier(SequenceBarrier ... barriersToTrack) {
        return this.sequencer.newSingleConsumerBarrier(barriersToTrack);
    }

    @Override
    public ConsumerBarrier newSingleConsumerBarrier(WaitStrategy waitStrategy, SequenceBarrier ... barriersToTrack) {
        return this.sequencer.newSingleConsumerBarrier(waitStrategy, barriersToTrack);
    }

    @Override
    public ConsumerBarrier newMultiConsumerBarrier(int workerCount, SequenceBarrier ... barriersToTrack) {
        return this.sequencer.newMultiConsumerBarrier(workerCount, barriersToTrack);
    }

    @Override
    public ConsumerBarrier newMultiConsumerBarrier(int workerCount, WaitStrategy waitStrategy, SequenceBarrier ... barriersToTrack) {
        return this.sequencer.newMultiConsumerBarrier(workerCount, waitStrategy, barriersToTrack);
    }

    @Override
    public boolean hasAvailableCapacity(int requiredCapacity) {
        return this.sequencer.hasAvailableCapacity(requiredCapacity);
    }

    @Override
    public long next() {
        return this.sequencer.next(1);
    }

    @Override
    public long next(int n) {
        return this.sequencer.next(n);
    }

    @Override
    public long tryNext() {
        return this.sequencer.tryNext(1);
    }

    @Override
    public long tryNext(int n) {
        return this.sequencer.tryNext(n);
    }

    @Override
    public long nextInterruptibly() throws InterruptedException {
        return this.sequencer.nextInterruptibly(1);
    }

    @Override
    public long nextInterruptibly(int n) throws InterruptedException {
        return this.sequencer.nextInterruptibly(n);
    }

    @Override
    public long tryNext(int n, long timeout, TimeUnit unit) {
        return this.sequencer.tryNext(n, timeout, unit);
    }

    @Override
    public void publish(long sequence) {
        this.sequencer.publish(sequence);
    }

    @Override
    public void publish(long lo, long hi) {
        this.sequencer.publish(lo, hi);
    }

    public static <E> Builder<E> newMultiProducer() {
        return new Builder().setProducerType(ProducerType.MULTI);
    }

    public static <E> Builder<E> newMultiProducer(EventFactory<? extends E> factory) {
        return new Builder().setProducerType(ProducerType.MULTI).setFactory((EventFactory)factory);
    }

    public static <E> Builder<E> newSingleProducer() {
        return new Builder().setProducerType(ProducerType.SINGLE);
    }

    public static <E> Builder<E> newSingleProducer(EventFactory<? extends E> factory) {
        return new Builder().setProducerType(ProducerType.SINGLE).setFactory((EventFactory)factory);
    }

    public static class Builder<E>
    extends EventSequencerBuilder<E> {
        private ProducerType producerType = ProducerType.MULTI;
        private int bufferSize = 8192;

        @Override
        public RingBufferEventSequencer<E> build() {
            return new RingBufferEventSequencer(this);
        }

        public ProducerType getProducerType() {
            return this.producerType;
        }

        public Builder<E> setProducerType(ProducerType producerType) {
            this.producerType = Objects.requireNonNull(producerType);
            return this;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public Builder<E> setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        @Override
        public Builder<E> setFactory(EventFactory<? extends E> factory) {
            return (Builder)super.setFactory(factory);
        }

        @Override
        public Builder<E> setProducerSleepNanos(long producerSleepNanos) {
            return (Builder)super.setProducerSleepNanos(producerSleepNanos);
        }

        @Override
        public Builder<E> setWaitStrategy(WaitStrategy waitStrategy) {
            return (Builder)super.setWaitStrategy(waitStrategy);
        }

        @Override
        public Builder<E> enableBlocker() {
            return (Builder)super.enableBlocker();
        }

        @Override
        public Builder<E> disableBlocker() {
            return (Builder)super.disableBlocker();
        }
    }
}

