/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.EventFactory;
import cn.wjybxx.disruptor.RingBufferPad;
import cn.wjybxx.disruptor.Util;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;

abstract class RingBufferFields<E>
extends RingBufferPad {
    private static final int BUFFER_PAD = 16;
    private final long indexMask;
    private final Object[] entries;
    final int bufferSize;
    private static final VarHandle VH_ELEMENTS = MethodHandles.arrayElementVarHandle(Object[].class);

    public RingBufferFields(EventFactory<? extends E> eventFactory, int bufferSize) {
        Objects.requireNonNull(eventFactory, "eventFactory");
        if (!Util.isPowerOfTwo(bufferSize)) {
            throw new IllegalArgumentException("bufferSize must be a power of 2");
        }
        this.entries = new Object[bufferSize + 32];
        this.bufferSize = bufferSize;
        this.indexMask = bufferSize - 1;
        this.fill(eventFactory);
    }

    private void fill(EventFactory<? extends E> eventFactory) {
        for (int i = 0; i < this.bufferSize; ++i) {
            this.entries[16 + i] = eventFactory.newInstance();
        }
    }

    protected final E elementAt(long sequence) {
        int index = (int)(sequence & this.indexMask);
        return (E)VH_ELEMENTS.get(this.entries, 16 + index);
    }

    protected final void setElement(long sequence, E event) {
        int index = (int)(sequence & this.indexMask);
        VH_ELEMENTS.set(this.entries, 16 + index, event);
    }

    protected final Stream<E> toStream() {
        Object[] elements = this.entries;
        return Arrays.asList(elements).subList(16, 16 + this.bufferSize).stream();
    }
}

