/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.ProducerBarrier;
import cn.wjybxx.disruptor.Sequence;
import cn.wjybxx.disruptor.SequenceBarrier;
import cn.wjybxx.disruptor.SequenceBlocker;
import cn.wjybxx.disruptor.Sequencer;
import cn.wjybxx.disruptor.Util;
import cn.wjybxx.disruptor.WaitStrategy;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class RingBufferSequencer
implements Sequencer,
ProducerBarrier {
    protected final Sequence cursor = new Sequence(-1L);
    protected volatile SequenceBarrier[] gatingBarriers = new SequenceBarrier[0];
    protected final int bufferSize;
    protected final long sleepNanos;
    private final WaitStrategy waitStrategy;
    protected final SequenceBlocker blocker;
    private static final VarHandle VH_GATING_BARRIERS;

    public RingBufferSequencer(int bufferSize, long sleepNanos, WaitStrategy waitStrategy, @Nullable SequenceBlocker blocker) {
        this.bufferSize = bufferSize;
        this.sleepNanos = sleepNanos;
        this.waitStrategy = Objects.requireNonNull(waitStrategy);
        this.blocker = blocker;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public abstract long remainingCapacity();

    @Override
    @Deprecated
    public void claim(long sequence) {
        if (!this.cursor.compareAndSet(-1L, sequence)) {
            throw new IllegalStateException();
        }
    }

    @Override
    public final ProducerBarrier getProducerBarrier() {
        return this;
    }

    @Override
    @Nullable
    public final SequenceBlocker getBlocker() {
        return this.blocker;
    }

    @Override
    @Nonnull
    public final WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    @Override
    public final void signalAllWhenBlocking() {
        if (this.blocker != null) {
            this.blocker.signalAll();
        }
    }

    @Override
    public long tryNext(int n, long timeout, TimeUnit unit) {
        return Util.tryNext(n, timeout, unit, this, this.sleepNanos);
    }

    @Override
    public final Sequence groupSequence() {
        return this.cursor;
    }

    @Override
    public long sequence() {
        return this.cursor.getVolatile();
    }

    @Override
    public final long dependentSequence() {
        return Util.getMinimumSequence(this.gatingBarriers, Long.MAX_VALUE);
    }

    @Override
    public final long minimumSequence() {
        return Util.getMinimumSequence(this.gatingBarriers, this.cursor.getVolatile());
    }

    @Override
    public void addDependentBarriers(SequenceBarrier ... barriersToTrack) {
        Util.addBarriers(VH_GATING_BARRIERS, this, barriersToTrack);
    }

    @Override
    public boolean removeDependentBarrier(SequenceBarrier barrier) {
        return Util.removeBarrier(VH_GATING_BARRIERS, this, barrier);
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            VH_GATING_BARRIERS = l.findVarHandle(RingBufferSequencer.class, "gatingBarriers", SequenceBarrier[].class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

