/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.AlertException;
import cn.wjybxx.disruptor.ConsumerBarrier;
import cn.wjybxx.disruptor.ProducerBarrier;
import cn.wjybxx.disruptor.WaitStrategy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;

public class SleepingWaitStrategy
implements WaitStrategy {
    private static final int SPIN_TRIES = 100;
    private static final int YIELD_TRIES = 100;
    private static final int SLEEP_NANOS = 1000;
    private final int spinTries;
    private final int yieldTries;
    private final long sleepTimeNs;

    public SleepingWaitStrategy() {
        this(100, 100, 1000L, TimeUnit.NANOSECONDS);
    }

    public SleepingWaitStrategy(int spinTries, int yieldTries, long sleepTime, TimeUnit unit) {
        this.spinTries = spinTries;
        this.yieldTries = yieldTries;
        this.sleepTimeNs = unit.toNanos(sleepTime);
    }

    @Override
    public long waitFor(long sequence, ProducerBarrier producerBarrier, ConsumerBarrier barrier) throws TimeoutException, AlertException, InterruptedException {
        long availableSequence;
        int counter = this.spinTries + this.yieldTries;
        while ((availableSequence = barrier.dependentSequence()) < sequence) {
            barrier.checkAlert();
            if (counter > this.yieldTries) {
                --counter;
                continue;
            }
            if (counter > 0) {
                --counter;
                Thread.yield();
                continue;
            }
            LockSupport.parkNanos(this.sleepTimeNs);
        }
        return availableSequence;
    }
}

