/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.RingBufferSequencer;
import cn.wjybxx.disruptor.Sequence;
import cn.wjybxx.disruptor.SequenceBarrier;
import cn.wjybxx.disruptor.SequenceBlocker;
import cn.wjybxx.disruptor.Util;
import cn.wjybxx.disruptor.WaitStrategy;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.locks.LockSupport;
import javax.annotation.Nullable;

public class MultiProducerSequencer
extends RingBufferSequencer {
    private static final VarHandle VH_PUBLISHED_ELEMENTS = MethodHandles.arrayElementVarHandle(long[].class);
    protected final Sequence gatingSequenceCache = new Sequence(-1L);
    private final long[] published;
    private final int indexMask;

    public MultiProducerSequencer(int bufferSize, long sleepNanos, WaitStrategy waitStrategy, @Nullable SequenceBlocker blocker) {
        super(bufferSize, sleepNanos, waitStrategy, blocker);
        this.indexMask = bufferSize - 1;
        this.published = new long[bufferSize];
        this.initPublished(-1L);
    }

    @Override
    public void claim(long sequence) {
        super.claim(sequence);
        this.initPublished(sequence);
    }

    private void initPublished(long value) {
        Arrays.fill(this.published, value);
    }

    private static int indexOfSequence(long sequence, int indexMask) {
        return (int)((long)indexMask & sequence);
    }

    protected final void setPublished(long sequence) {
        int index = MultiProducerSequencer.indexOfSequence(sequence, this.indexMask);
        VH_PUBLISHED_ELEMENTS.setRelease(this.published, index, sequence);
    }

    protected final void setPublished(long lo, long hi) {
        long[] published = this.published;
        int indexMask = this.indexMask;
        VarHandle varHandle = VH_PUBLISHED_ELEMENTS;
        for (long seq = lo; seq <= hi; ++seq) {
            int index = MultiProducerSequencer.indexOfSequence(seq, indexMask);
            varHandle.setRelease(published, index, seq);
        }
    }

    @Override
    public void publish(long sequence) {
        this.setPublished(sequence);
        this.signalAllWhenBlocking();
    }

    @Override
    public void publish(long lo, long hi) {
        this.setPublished(lo, hi);
        this.signalAllWhenBlocking();
    }

    @Override
    public boolean isPublished(long sequence) {
        int index = MultiProducerSequencer.indexOfSequence(sequence, this.indexMask);
        long flag = VH_PUBLISHED_ELEMENTS.getVolatile(this.published, index);
        return flag == sequence;
    }

    @Override
    public long getHighestPublishedSequence(long lowerBound, long availableSequence) {
        long[] published = this.published;
        int indexMask = this.indexMask;
        VarHandle varHandle = VH_PUBLISHED_ELEMENTS;
        for (long sequence = lowerBound; sequence <= availableSequence; ++sequence) {
            int index = MultiProducerSequencer.indexOfSequence(sequence, indexMask);
            long flag = varHandle.getVolatile(published, index);
            if (flag == sequence) continue;
            return sequence - 1L;
        }
        return availableSequence;
    }

    @Override
    public long remainingCapacity() {
        long consumed = Util.getMinimumSequence(this.gatingBarriers, this.cursor.getVolatile());
        long produced = this.cursor.getVolatile();
        return (long)this.getBufferSize() - (produced - consumed);
    }

    @Override
    public boolean hasAvailableCapacity(int requiredCapacity) {
        if (requiredCapacity < 0) {
            throw new IllegalArgumentException();
        }
        return this.hasAvailableCapacity(this.gatingBarriers, requiredCapacity, this.cursor.getVolatile());
    }

    private boolean hasAvailableCapacity(SequenceBarrier[] gatingBarriers, int requiredCapacity, long cursorValue) {
        long wrapPoint = cursorValue + (long)requiredCapacity - (long)this.bufferSize;
        long cachedGatingSequence = this.gatingSequenceCache.getVolatile();
        if (wrapPoint > cachedGatingSequence || cachedGatingSequence > cursorValue) {
            long minSequence = Util.getMinimumSequence(gatingBarriers, cursorValue);
            this.gatingSequenceCache.setRelease(minSequence);
            return wrapPoint <= minSequence;
        }
        return true;
    }

    @Override
    public long next() {
        try {
            return this.nextImpl(1, false);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long next(int n) {
        try {
            return this.nextImpl(n, false);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long nextInterruptibly() throws InterruptedException {
        return this.nextImpl(1, true);
    }

    @Override
    public long nextInterruptibly(int n) throws InterruptedException {
        return this.nextImpl(n, true);
    }

    private long nextImpl(int n, boolean interruptible) throws InterruptedException {
        long next;
        if (n < 1 || n > this.bufferSize) {
            throw new IllegalArgumentException("n: " + n);
        }
        boolean interrupted = false;
        while (true) {
            long cachedGatingSequence;
            long current;
            long wrapPoint;
            if ((wrapPoint = (next = (current = this.cursor.getVolatile()) + (long)n) - (long)this.bufferSize) > (cachedGatingSequence = this.gatingSequenceCache.getVolatile()) || cachedGatingSequence > current) {
                long gatingSequence = Util.getMinimumSequence(this.gatingBarriers, current);
                if (wrapPoint > gatingSequence) {
                    if (this.sleepNanos <= 0L) {
                        Thread.onSpinWait();
                        continue;
                    }
                    if (interruptible) {
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                    } else {
                        interrupted |= Thread.interrupted();
                    }
                    LockSupport.parkNanos(this.sleepNanos);
                    continue;
                }
                this.gatingSequenceCache.setRelease(gatingSequence);
                continue;
            }
            if (this.cursor.compareAndSet(current, next)) break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return next;
    }

    @Override
    public long tryNext() {
        return this.tryNext(1);
    }

    @Override
    public long tryNext(int n) {
        long next;
        long current;
        if (n < 1 || n > this.bufferSize) {
            throw new IllegalArgumentException("n: " + n);
        }
        do {
            current = this.cursor.getVolatile();
            next = current + (long)n;
            if (this.hasAvailableCapacity(this.gatingBarriers, n, current)) continue;
            return -1L;
        } while (!this.cursor.compareAndSet(current, next));
        return next;
    }
}

