/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.ProducerBarrier;
import cn.wjybxx.disruptor.Sequence;
import cn.wjybxx.disruptor.SequenceBarrier;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public final class Util {
    public static boolean isPowerOfTwo(int x) {
        return x > 0 && (x & x - 1) == 0;
    }

    public static int nextPowerOfTwo(int num) {
        if (num < 1) {
            return 1;
        }
        return 1 << 32 - Integer.numberOfLeadingZeros(num - 1);
    }

    public static long getMinimumSequence(Sequence[] sequences) {
        int n = sequences.length;
        if (n == 1) {
            return sequences[0].getVolatile();
        }
        long minimum = Long.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            long value = sequences[i].getVolatile();
            minimum = Math.min(minimum, value);
        }
        return minimum;
    }

    public static long getMinimumSequence(Sequence[] sequences, long minimum) {
        int n = sequences.length;
        if (n == 1) {
            return Math.min(minimum, sequences[0].getVolatile());
        }
        for (int i = 0; i < n; ++i) {
            long value = sequences[i].getVolatile();
            minimum = Math.min(minimum, value);
        }
        return minimum;
    }

    public static long getMinimumSequence(SequenceBarrier[] barriers) {
        int n = barriers.length;
        if (n == 1) {
            return barriers[0].sequence();
        }
        long minimum = Long.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            long value = barriers[i].sequence();
            minimum = Math.min(minimum, value);
        }
        return minimum;
    }

    public static long getMinimumSequence(SequenceBarrier[] barriers, long minimum) {
        int n = barriers.length;
        if (n == 1) {
            return Math.min(minimum, barriers[0].sequence());
        }
        for (int i = 0; i < n; ++i) {
            long value = barriers[i].sequence();
            minimum = Math.min(minimum, value);
        }
        return minimum;
    }

    public static <T extends SequenceBarrier> void addBarriers(VarHandle varHandle, T current, SequenceBarrier ... barriersToAdd) {
        long cursorSequence;
        SequenceBarrier[] newBarriers;
        SequenceBarrier[] oldBarriers;
        Util.checkNullElements(barriersToAdd, "barriersToAdd");
        do {
            oldBarriers = varHandle.get(current);
            newBarriers = Arrays.copyOf(oldBarriers, oldBarriers.length + barriersToAdd.length);
            cursorSequence = current.sequence();
            int index = oldBarriers.length;
            SequenceBarrier[] sequenceBarrierArray = barriersToAdd;
            int n = sequenceBarrierArray.length;
            for (int i = 0; i < n; ++i) {
                SequenceBarrier barrier = sequenceBarrierArray[i];
                barrier.claim(cursorSequence);
                newBarriers[index++] = barrier;
            }
        } while (!varHandle.compareAndSet(current, oldBarriers, newBarriers));
        cursorSequence = current.sequence();
        for (SequenceBarrier barrier : barriersToAdd) {
            barrier.claim(cursorSequence);
        }
    }

    public static <T extends SequenceBarrier> boolean removeBarrier(VarHandle varHandle, T current, SequenceBarrier barrier) {
        SequenceBarrier[] oldBarriers;
        int numToRemove;
        while (0 != (numToRemove = Util.countMatching(oldBarriers = varHandle.get(current), barrier))) {
            int oldSize = oldBarriers.length;
            SequenceBarrier[] newBarriers = new SequenceBarrier[oldSize - numToRemove];
            int pos = 0;
            for (int i = 0; i < oldSize; ++i) {
                SequenceBarrier testSequence = oldBarriers[i];
                if (barrier == testSequence) continue;
                newBarriers[pos++] = testSequence;
            }
            if (!varHandle.compareAndSet(current, oldBarriers, newBarriers)) continue;
        }
        return numToRemove != 0;
    }

    private static <T> int countMatching(T[] values, T toMatch) {
        int numToRemove = 0;
        for (T value : values) {
            if (value != toMatch) continue;
            ++numToRemove;
        }
        return numToRemove;
    }

    public static long tryNext(int n, long timeout, TimeUnit unit, ProducerBarrier barrier, long sleepNanos) {
        long sequence = barrier.tryNext(n);
        if (sequence != -1L) {
            return sequence;
        }
        long nanoTime = System.nanoTime();
        long deadline = nanoTime + unit.toNanos(timeout);
        if (sleepNanos <= 0L) {
            do {
                Thread.onSpinWait();
                sequence = barrier.tryNext(n);
                if (sequence == -1L) continue;
                return sequence;
            } while (System.nanoTime() < deadline);
        } else {
            boolean interrupted = false;
            do {
                long parkNanos = Math.min(sleepNanos, deadline - nanoTime);
                interrupted |= Thread.interrupted();
                LockSupport.parkNanos(parkNanos);
                sequence = barrier.tryNext(n);
                if (sequence == -1L) continue;
                return sequence;
            } while ((nanoTime = System.nanoTime()) < deadline);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return -1L;
    }

    public static void checkNullElements(Object[] array, String desc) {
        for (Object element : array) {
            if (element != null) continue;
            Util.throwArgumentException("array contains null elements", "%s contains null elements", desc);
        }
    }

    private static void throwArgumentException(String defaultMsg, String formatMsg, String desc) {
        if (desc == null) {
            throw new IllegalArgumentException(defaultMsg);
        }
        throw new IllegalArgumentException(String.format(formatMsg, desc));
    }
}

