/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.ConsumerBarrier;
import cn.wjybxx.disruptor.EventFactory;
import cn.wjybxx.disruptor.EventSequencer;
import cn.wjybxx.disruptor.EventSequencerBuilder;
import cn.wjybxx.disruptor.MpUnboundedBuffer;
import cn.wjybxx.disruptor.MpUnboundedBufferSequencer;
import cn.wjybxx.disruptor.ProducerBarrier;
import cn.wjybxx.disruptor.SequenceBarrier;
import cn.wjybxx.disruptor.Sequencer;
import cn.wjybxx.disruptor.WaitStrategy;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class MpUnboundedEventSequencer<E>
implements EventSequencer<E> {
    private final MpUnboundedBuffer<E> buffer;
    private final MpUnboundedBufferSequencer<E> sequencer;

    public MpUnboundedEventSequencer(Builder<E> builder) {
        Objects.requireNonNull(builder);
        this.buffer = new MpUnboundedBuffer(builder.getChunkSize(), builder.getMaxPooledChunks(), builder.getFactory());
        this.sequencer = new MpUnboundedBufferSequencer<E>(this.buffer, builder.getWaitStrategy(), builder.getBlocker());
    }

    public MpUnboundedBuffer<E> getBuffer() {
        return this.buffer;
    }

    public boolean inSameChunk(long seq1, long seq2) {
        return this.buffer.inSameChunk(seq1, seq2);
    }

    public boolean tryMoveHeadToNext() {
        return this.buffer.tryMoveHeadToNext(this.sequencer.minimumSequence());
    }

    public boolean tryMoveHeadToNext(long gatingSequence) {
        return this.buffer.tryMoveHeadToNext(gatingSequence);
    }

    @Override
    public final E get(long sequence) {
        return this.buffer.get(sequence);
    }

    @Override
    public final E producerGet(long sequence) {
        return this.buffer.producerGet(sequence);
    }

    @Override
    public final E consumerGet(long sequence) {
        return this.buffer.consumerGet(sequence);
    }

    @Override
    public void producerSet(long sequence, E data) {
        this.buffer.producerSet(sequence, data);
    }

    @Override
    public void consumerSet(long sequence, E data) {
        this.buffer.consumerSet(sequence, data);
    }

    @Override
    public int capacity() {
        return -1;
    }

    @Override
    public long remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Sequencer sequencer() {
        return this.sequencer;
    }

    @Override
    public ProducerBarrier producerBarrier() {
        return this.sequencer;
    }

    @Override
    public void addGatingBarriers(SequenceBarrier ... gatingBarriers) {
        this.sequencer.addGatingBarriers(gatingBarriers);
    }

    @Override
    public boolean removeGatingBarrier(SequenceBarrier gatingBarrier) {
        return this.sequencer.removeGatingBarrier(gatingBarrier);
    }

    @Override
    public ConsumerBarrier newSingleConsumerBarrier(SequenceBarrier ... barriersToTrack) {
        return this.sequencer.newSingleConsumerBarrier(barriersToTrack);
    }

    @Override
    public ConsumerBarrier newSingleConsumerBarrier(WaitStrategy waitStrategy, SequenceBarrier ... barriersToTrack) {
        return this.sequencer.newSingleConsumerBarrier(waitStrategy, barriersToTrack);
    }

    @Override
    public ConsumerBarrier newMultiConsumerBarrier(int workerCount, SequenceBarrier ... barriersToTrack) {
        return this.sequencer.newMultiConsumerBarrier(workerCount, barriersToTrack);
    }

    @Override
    public ConsumerBarrier newMultiConsumerBarrier(int workerCount, WaitStrategy waitStrategy, SequenceBarrier ... barriersToTrack) {
        return this.sequencer.newMultiConsumerBarrier(workerCount, waitStrategy, barriersToTrack);
    }

    @Override
    public boolean hasAvailableCapacity(int requiredCapacity) {
        return this.sequencer.hasAvailableCapacity(requiredCapacity);
    }

    @Override
    public long next() {
        return this.sequencer.next(1);
    }

    @Override
    public long next(int n) {
        return this.sequencer.next(n);
    }

    @Override
    public long tryNext() {
        return this.sequencer.tryNext(1);
    }

    @Override
    public long tryNext(int n) {
        return this.sequencer.tryNext(n);
    }

    @Override
    public long nextInterruptibly() throws InterruptedException {
        return this.sequencer.nextInterruptibly(1);
    }

    @Override
    public long nextInterruptibly(int n) throws InterruptedException {
        return this.sequencer.nextInterruptibly(n);
    }

    @Override
    public long tryNext(int n, long timeout, TimeUnit unit) {
        return this.sequencer.tryNext(n, timeout, unit);
    }

    @Override
    public void publish(long sequence) {
        this.sequencer.publish(sequence);
    }

    @Override
    public void publish(long lo, long hi) {
        this.sequencer.publish(lo, hi);
    }

    public static <E> Builder<E> newBuilder() {
        return new Builder();
    }

    public static <E> Builder<E> newBuilder(EventFactory<? extends E> factory) {
        return new Builder().setFactory((EventFactory)factory);
    }

    public static class Builder<E>
    extends EventSequencerBuilder<E> {
        private int chunkSize = 1024;
        private int maxPooledChunks = 8;

        @Override
        public MpUnboundedEventSequencer<E> build() {
            return new MpUnboundedEventSequencer(this);
        }

        public int getChunkSize() {
            return this.chunkSize;
        }

        public Builder<E> setChunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public int getMaxPooledChunks() {
            return this.maxPooledChunks;
        }

        public Builder<E> setMaxPooledChunks(int maxPooledChunks) {
            this.maxPooledChunks = maxPooledChunks;
            return this;
        }

        @Override
        public Builder<E> setFactory(EventFactory<? extends E> factory) {
            return (Builder)super.setFactory(factory);
        }

        @Override
        public Builder<E> setProducerSleepNanos(long producerSleepNanos) {
            return (Builder)super.setProducerSleepNanos(producerSleepNanos);
        }

        @Override
        public Builder<E> setWaitStrategy(WaitStrategy waitStrategy) {
            return (Builder)super.setWaitStrategy(waitStrategy);
        }

        @Override
        public Builder<E> enableBlocker() {
            return (Builder)super.enableBlocker();
        }

        @Override
        public Builder<E> disableBlocker() {
            return (Builder)super.disableBlocker();
        }
    }
}

