/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.AlertException;
import cn.wjybxx.disruptor.ConsumerBarrier;
import cn.wjybxx.disruptor.ProducerBarrier;
import cn.wjybxx.disruptor.StacklessTimeoutException;
import cn.wjybxx.disruptor.WaitStrategy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;

public class TimeoutSleepingWaitStrategy
implements WaitStrategy {
    public static final TimeoutSleepingWaitStrategy INSTANCE = new TimeoutSleepingWaitStrategy();
    private static final int SPIN_TRIES = 10;
    private static final int YIELD_TRIES = 10;
    private static final int SLEEP_TRIES = 10;
    private static final int SLEEP_NANOS = 100000;
    private final int spinTries;
    private final int yieldTries;
    private final int sleepTries;
    private final long sleepTimeNs;

    public TimeoutSleepingWaitStrategy() {
        this(10, 10, 10, 100000L, TimeUnit.NANOSECONDS);
    }

    public TimeoutSleepingWaitStrategy(int spinTries, int yieldTries, int sleepTries, long sleepTime, TimeUnit unit) {
        this.spinTries = spinTries;
        this.yieldTries = yieldTries;
        this.sleepTries = sleepTries;
        this.sleepTimeNs = unit.toNanos(sleepTime);
    }

    @Override
    public long waitFor(long sequence, ProducerBarrier producerBarrier, ConsumerBarrier barrier) throws TimeoutException, AlertException, InterruptedException {
        long availableSequence;
        int counter = this.spinTries + this.yieldTries + this.sleepTries;
        int yieldThreshold = this.yieldTries + this.sleepTries;
        while ((availableSequence = barrier.dependentSequence()) < sequence) {
            barrier.checkAlert();
            if (counter > yieldThreshold) {
                --counter;
                continue;
            }
            if (counter > this.sleepTries) {
                --counter;
                Thread.yield();
                continue;
            }
            if (counter > 0) {
                --counter;
                LockSupport.parkNanos(this.sleepTimeNs);
                continue;
            }
            throw StacklessTimeoutException.INST;
        }
        return availableSequence;
    }
}

