/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.DataProvider;
import cn.wjybxx.disruptor.EventFactory;
import cn.wjybxx.disruptor.MpUnboundedBufferChunk;
import cn.wjybxx.disruptor.MpUnboundedBufferFields;
import cn.wjybxx.disruptor.Util;
import java.util.Objects;

public final class MpUnboundedBuffer<E>
extends MpUnboundedBufferFields<E>
implements DataProvider<E> {
    private final int chunkMask;
    private final int chunkShift;
    private final int maxPooledChunks;
    private final EventFactory<? extends E> factory;

    public MpUnboundedBuffer(int chunkSize, int maxPooledChunks, EventFactory<? extends E> factory) {
        if (maxPooledChunks < 0) {
            throw new IllegalArgumentException("Expecting a positive maxPooledChunks, but got:" + maxPooledChunks);
        }
        chunkSize = Util.nextPowerOfTwo(chunkSize);
        this.chunkMask = chunkSize - 1;
        this.chunkShift = Integer.numberOfTrailingZeros(chunkSize);
        this.maxPooledChunks = maxPooledChunks;
        this.factory = Objects.requireNonNull(factory, "factory");
        MpUnboundedBufferChunk<? extends E> firstChunk = new MpUnboundedBufferChunk<E>(chunkSize, 0L, null);
        firstChunk.fill(factory);
        this.soTailChunk(firstChunk);
        this.soHeadChunk(firstChunk);
        this.soProducerChunk(firstChunk);
    }

    public void claim(long sequence) {
        if (this.lvHeadChunk() != this.lvTailChunk()) {
            throw new IllegalStateException();
        }
        long seqChunkIndex = sequence >> this.chunkShift;
        this.lvHeadChunk().soChunkIndex(seqChunkIndex);
    }

    public int chunkSize() {
        return this.chunkMask + 1;
    }

    public int maxPooledChunks() {
        return this.maxPooledChunks;
    }

    public long chunkIndexForSequence(long sequence) {
        assert (sequence >= 0L);
        return sequence >> this.chunkShift;
    }

    public boolean inSameChunk(long seq1, long seq2) {
        int chunkShift = this.chunkShift;
        return seq1 >> chunkShift == seq2 >> chunkShift;
    }

    @Override
    public E get(long sequence) {
        return this.consumerGet(sequence);
    }

    @Override
    public E producerGet(long sequence) {
        if (sequence < 0L) {
            throw new IllegalArgumentException();
        }
        int seqChunkOffset = (int)(sequence & (long)this.chunkMask);
        long seqChunkIndex = sequence >> this.chunkShift;
        MpUnboundedBufferChunk pChunk = this.lvProducerChunk();
        if (pChunk.lvChunkIndex() != seqChunkIndex) {
            pChunk = this.producerChunkForIndex(pChunk, seqChunkIndex);
        }
        return pChunk.lvElement(seqChunkOffset);
    }

    @Override
    public E consumerGet(long sequence) {
        if (sequence < 0L) {
            throw new IllegalArgumentException();
        }
        int seqChunkOffset = (int)(sequence & (long)this.chunkMask);
        long seqChunkIndex = sequence >> this.chunkShift;
        MpUnboundedBufferChunk cChunk = this.lvHeadChunk();
        if (cChunk.lvChunkIndex() != seqChunkIndex) {
            cChunk = this.consumerChunkForIndex(cChunk, seqChunkIndex);
        }
        return cChunk.lvElement(seqChunkOffset);
    }

    @Override
    public void producerSet(long sequence, E data) {
        Objects.requireNonNull(data);
        if (sequence < 0L) {
            throw new IllegalArgumentException();
        }
        int seqChunkOffset = (int)(sequence & (long)this.chunkMask);
        long seqChunkIndex = sequence >> this.chunkShift;
        MpUnboundedBufferChunk<E> pChunk = this.lvProducerChunk();
        if (pChunk.lvChunkIndex() != seqChunkIndex) {
            pChunk = this.producerChunkForIndex(pChunk, seqChunkIndex);
        }
        pChunk.spElement(seqChunkOffset, data);
    }

    @Override
    public void consumerSet(long sequence, E data) {
        if (sequence < 0L) {
            throw new IllegalArgumentException();
        }
        int seqChunkOffset = (int)(sequence & (long)this.chunkMask);
        long seqChunkIndex = sequence >> this.chunkShift;
        MpUnboundedBufferChunk<E> cChunk = this.lvHeadChunk();
        if (cChunk.lvChunkIndex() != seqChunkIndex) {
            cChunk = this.consumerChunkForIndex(cChunk, seqChunkIndex);
        }
        cChunk.spElement(seqChunkOffset, data);
    }

    public MpUnboundedBufferChunk<E> producerChunkForSequence(long sequence) {
        if (sequence < 0L) {
            throw new IllegalArgumentException();
        }
        long seqChunkIndex = sequence >> this.chunkShift;
        MpUnboundedBufferChunk pChunk = this.lvProducerChunk();
        if (pChunk.lvChunkIndex() != seqChunkIndex) {
            pChunk = this.producerChunkForIndex(pChunk, seqChunkIndex);
        }
        return pChunk;
    }

    public MpUnboundedBufferChunk<E> consumerChunkForSequence(long sequence) {
        if (sequence < 0L) {
            throw new IllegalArgumentException();
        }
        long seqChunkIndex = sequence >> this.chunkShift;
        MpUnboundedBufferChunk cChunk = this.lvHeadChunk();
        if (cChunk.lvChunkIndex() != seqChunkIndex) {
            cChunk = this.consumerChunkForIndex(cChunk, seqChunkIndex);
        }
        return cChunk;
    }

    private MpUnboundedBufferChunk<E> consumerChunkForIndex(MpUnboundedBufferChunk<E> initialChunk, long requiredChunkIndex) {
        MpUnboundedBufferChunk<E> currentChunk = initialChunk;
        while (true) {
            long currentChunkIndex;
            if (currentChunk == null) {
                Thread.onSpinWait();
                currentChunk = this.lvHeadChunk();
            }
            if ((currentChunkIndex = currentChunk.lvChunkIndex()) == requiredChunkIndex) {
                return currentChunk;
            }
            if (currentChunkIndex < 0L || currentChunkIndex > requiredChunkIndex) {
                currentChunk = null;
                continue;
            }
            currentChunk = currentChunk.lvNext();
        }
    }

    private MpUnboundedBufferChunk<E> producerChunkForIndex(MpUnboundedBufferChunk<E> initialChunk, long requiredChunkIndex) {
        long jumpBackward;
        MpUnboundedBufferChunk<E> currentChunk = initialChunk;
        while (true) {
            if (currentChunk == null) {
                currentChunk = this.lvProducerChunk();
            }
            if (currentChunk == ROTATION) {
                Thread.onSpinWait();
                currentChunk = null;
                continue;
            }
            long currentChunkIndex = currentChunk.lvChunkIndex();
            jumpBackward = currentChunkIndex - requiredChunkIndex;
            if (jumpBackward >= 0L) break;
            currentChunk = this.appendNextChunks(currentChunk, currentChunkIndex, -jumpBackward);
        }
        for (long i = 0L; i < jumpBackward; ++i) {
            currentChunk = currentChunk.lvPrev();
        }
        assert (currentChunk.lvChunkIndex() == requiredChunkIndex);
        return currentChunk;
    }

    private MpUnboundedBufferChunk<E> appendNextChunks(MpUnboundedBufferChunk<E> currentChunk, long currentChunkIndex, long chunksToAppend) {
        if (!this.casProducerChunk(currentChunk, ROTATION)) {
            return null;
        }
        for (long i = 1L; i <= chunksToAppend; ++i) {
            MpUnboundedBufferChunk<E> newChunk = this.newOrPooledChunk(currentChunk, currentChunkIndex + i);
            currentChunk.soNext(newChunk);
            currentChunk = newChunk;
        }
        this.soProducerChunk(currentChunk);
        return currentChunk;
    }

    private MpUnboundedBufferChunk<E> newOrPooledChunk(MpUnboundedBufferChunk<E> prevChunk, long nextChunkIndex) {
        MpUnboundedBufferChunk<E> tailChunk;
        while (true) {
            if ((tailChunk = this.lvTailChunk()) == ROTATION) {
                Thread.onSpinWait();
                continue;
            }
            if (nextChunkIndex <= tailChunk.lvChunkIndex()) {
                MpUnboundedBufferChunk<E> nextChunk = prevChunk.lvNext();
                assert (nextChunk != null && nextChunk.lvChunkIndex() == nextChunkIndex);
                return nextChunk;
            }
            if (this.casTailChunk(tailChunk, ROTATION)) break;
            Thread.onSpinWait();
        }
        MpUnboundedBufferChunk<Object> nextChunk = new MpUnboundedBufferChunk<Object>(this.chunkSize(), nextChunkIndex, prevChunk);
        nextChunk.fill(this.factory);
        nextChunk.soPrev(tailChunk);
        tailChunk.soNext(nextChunk);
        this.soTailChunk(nextChunk);
        return nextChunk;
    }

    public boolean tryMoveHeadToNext(long gatingSequence) {
        MpUnboundedBufferChunk producerChunk;
        MpUnboundedBufferChunk headChunk = this.lvHeadChunk();
        if (!MpUnboundedBuffer.isRecyclable(headChunk, gatingSequence, producerChunk = this.lvProducerChunk())) {
            return false;
        }
        if (!this.tryLockHead()) {
            return false;
        }
        headChunk = this.lvHeadChunk();
        if (!MpUnboundedBuffer.isRecyclable(headChunk, gatingSequence, producerChunk = this.lvProducerChunk())) {
            this.unlockHead();
            return false;
        }
        MpUnboundedBufferChunk nextChunk = headChunk.lvNext();
        nextChunk.soPrev(null);
        while (MpUnboundedBuffer.isRecyclable(nextChunk, gatingSequence, producerChunk)) {
            nextChunk = nextChunk.lvNext();
            nextChunk.soPrev(null);
        }
        this.soHeadChunk(nextChunk);
        this.recycleChunks(headChunk, nextChunk);
        this.unlockHead();
        return true;
    }

    private static boolean isRecyclable(MpUnboundedBufferChunk<?> chunk, long gatingSequence, MpUnboundedBufferChunk<?> producerChunk) {
        return chunk.maxSequence() <= gatingSequence && chunk.lvChunkIndex() < producerChunk.lvChunkIndex();
    }

    private void recycleChunks(MpUnboundedBufferChunk<E> headChunk, MpUnboundedBufferChunk<E> nextChunk) {
        MpUnboundedBufferChunk freeChunk;
        block4: {
            long recyclable;
            MpUnboundedBufferChunk tailChunk;
            freeChunk = headChunk;
            while (true) {
                if ((tailChunk = this.lvTailChunk()) == ROTATION) {
                    Thread.onSpinWait();
                    continue;
                }
                recyclable = (long)this.maxPooledChunks - (tailChunk.lvChunkIndex() - nextChunk.lvChunkIndex()) - 1L;
                if (recyclable <= 0L) break block4;
                if (this.casTailChunk(tailChunk, ROTATION)) break;
                Thread.onSpinWait();
            }
            for (long i = 0L; i < recyclable && freeChunk != nextChunk; ++i) {
                MpUnboundedBufferChunk<E> tempNext = freeChunk.lvNext();
                freeChunk.soNext(null);
                freeChunk.soChunkIndex(tailChunk.lvChunkIndex() + 1L);
                freeChunk.soPrev(tailChunk);
                tailChunk.soNext(freeChunk);
                tailChunk = freeChunk;
                freeChunk = tempNext;
            }
            this.soTailChunk(tailChunk);
        }
        while (freeChunk != nextChunk) {
            MpUnboundedBufferChunk<E> tempNext = freeChunk.lvNext();
            freeChunk.soNext(null);
            freeChunk.clear();
            freeChunk = tempNext;
        }
    }
}

