/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.RhsPadding;
import cn.wjybxx.disruptor.Value;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

public final class Sequence
extends RhsPadding {
    private static final long INITIAL_VALUE = -1L;
    private static final VarHandle VH_VALUE;

    public Sequence() {
        this(-1L);
    }

    public Sequence(long initialValue) {
        VH_VALUE.setRelease(this, initialValue);
    }

    public long getVolatile() {
        return this.value;
    }

    public void setVolatile(long value) {
        VH_VALUE.setVolatile(this, value);
    }

    public long getAcquire() {
        return VH_VALUE.getAcquire(this);
    }

    public void setRelease(long value) {
        VH_VALUE.setRelease(this, value);
    }

    public long getPlain() {
        return VH_VALUE.get(this);
    }

    public void setPlain(long value) {
        VH_VALUE.set(this, value);
    }

    public boolean compareAndSet(long expectedValue, long newValue) {
        return VH_VALUE.compareAndSet(this, expectedValue, newValue);
    }

    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    public long getAndIncrement() {
        return this.getAndAdd(1L);
    }

    public long decrementAndGet() {
        return this.addAndGet(-1L);
    }

    public long getAndDecrement() {
        return this.getAndAdd(-1L);
    }

    public long addAndGet(long increment) {
        long prev = VH_VALUE.getAndAdd(this, increment);
        return prev + increment;
    }

    public long getAndAdd(long increment) {
        return VH_VALUE.getAndAdd(this, increment);
    }

    public String toString() {
        return Long.toString(this.getVolatile());
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            VH_VALUE = l.findVarHandle(Value.class, "value", Long.TYPE);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

