/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.EventFactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.locks.LockSupport;

public final class MpUnboundedBufferChunk<E> {
    static final int NOT_USED = -1;
    private final Object[] buffer;
    private final long[] published;
    private volatile long chunkIndex;
    private volatile MpUnboundedBufferChunk<E> prev;
    private volatile MpUnboundedBufferChunk<E> next;
    private static final VarHandle VH_INDEX;
    private static final VarHandle VH_PREV;
    private static final VarHandle VH_NEXT;
    private static final VarHandle VH_ELEMENTS;
    private static final VarHandle VH_PUBLISHED;

    public MpUnboundedBufferChunk(int length, long chunkIndex, MpUnboundedBufferChunk<E> prev) {
        this.buffer = new Object[length];
        this.published = new long[length];
        if (chunkIndex == 0L) {
            Arrays.fill(this.published, -1L);
        }
        this.spChunkIndex(chunkIndex);
        this.soPrev(prev);
    }

    private long lpChunkIndex() {
        return VH_INDEX.get(this);
    }

    private void spChunkIndex(long index) {
        VH_INDEX.set(this, index);
    }

    final long lvChunkIndex() {
        return this.chunkIndex;
    }

    final void soChunkIndex(long index) {
        VH_INDEX.setRelease(this, index);
    }

    final MpUnboundedBufferChunk<E> lvNext() {
        return this.next;
    }

    final void soNext(MpUnboundedBufferChunk<E> value) {
        VH_NEXT.setRelease(this, value);
    }

    final MpUnboundedBufferChunk<E> lvPrev() {
        return this.prev;
    }

    final void soPrev(MpUnboundedBufferChunk<E> value) {
        VH_PREV.setRelease(this, value);
    }

    public final void spElement(int index, E e) {
        VH_ELEMENTS.set(this.buffer, index, e);
    }

    public final void soElement(int index, E e) {
        VH_ELEMENTS.setRelease(this.buffer, index, e);
    }

    public final E lvElement(int index) {
        return (E)VH_ELEMENTS.getVolatile(this.buffer, index);
    }

    public final E lpElement(int index) {
        return (E)VH_ELEMENTS.get(this.buffer, index);
    }

    public final void publish(int index) {
        VH_PUBLISHED.setRelease(this.published, index, this.lpChunkIndex());
    }

    public final void publish(int low, int high) {
        long[] published = this.published;
        long chunkIndex = this.lpChunkIndex();
        while (low <= high) {
            VH_PUBLISHED.setRelease(published, low++, chunkIndex);
        }
    }

    public final boolean isPublished(int index) {
        long flag = VH_PUBLISHED.getVolatile(this.published, index);
        return flag == this.lpChunkIndex();
    }

    public final int getHighestPublishedSequence(int low, int high) {
        long[] published = this.published;
        long chunkIndex = this.lpChunkIndex();
        for (int index = low; index <= high; ++index) {
            long flag = VH_PUBLISHED.getVolatile(published, index);
            if (flag == chunkIndex) continue;
            return index - 1;
        }
        return high;
    }

    public final long minSequence() {
        int length = this.buffer.length;
        return VH_INDEX.get(this) * (long)length;
    }

    public final long maxSequence() {
        int length = this.buffer.length;
        return VH_INDEX.get(this) * (long)length + (long)(length - 1);
    }

    public final int length() {
        return this.buffer.length;
    }

    public final void fill(EventFactory<? extends E> factory) {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = factory.newInstance();
        }
    }

    public final void clear() {
        Arrays.fill(this.buffer, null);
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            VH_INDEX = l.findVarHandle(MpUnboundedBufferChunk.class, "chunkIndex", Long.TYPE);
            VH_PREV = l.findVarHandle(MpUnboundedBufferChunk.class, "prev", MpUnboundedBufferChunk.class);
            VH_NEXT = l.findVarHandle(MpUnboundedBufferChunk.class, "next", MpUnboundedBufferChunk.class);
            VH_ELEMENTS = MethodHandles.arrayElementVarHandle(Object[].class);
            VH_PUBLISHED = MethodHandles.arrayElementVarHandle(long[].class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        Class<LockSupport> clazz = LockSupport.class;
    }
}

