/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.SequenceBlocker;
import cn.wjybxx.disruptor.SingleProducerSequencerFields;
import cn.wjybxx.disruptor.Util;
import cn.wjybxx.disruptor.WaitStrategy;
import java.util.concurrent.locks.LockSupport;
import javax.annotation.Nullable;

public class SingleProducerSequencer
extends SingleProducerSequencerFields {
    private long p1;
    private long p2;
    private long p3;
    private long p4;
    private long p5;
    private long p6;
    private long p7;

    public SingleProducerSequencer(int bufferSize, long sleepNanos, WaitStrategy waitStrategy, @Nullable SequenceBlocker blocker) {
        super(bufferSize, sleepNanos, waitStrategy, blocker);
    }

    @Override
    public void claim(long sequence) {
        super.claim(sequence);
        this.produced = sequence;
        this.cachedGating = sequence;
    }

    @Override
    public long remainingCapacity() {
        long produced = this.produced;
        long consumed = Util.getMinimumSequence(this.gatingBarriers, produced);
        return (long)this.bufferSize - (produced - consumed);
    }

    @Override
    public boolean hasAvailableCapacity(int requiredCapacity) {
        if (requiredCapacity < 0) {
            throw new IllegalArgumentException();
        }
        return this.hasAvailableCapacity(requiredCapacity, false);
    }

    private boolean hasAvailableCapacity(int requiredCapacity, boolean doStore) {
        long produced = this.produced;
        long wrapPoint = produced + (long)requiredCapacity - (long)this.bufferSize;
        long cachedGatingSequence = this.cachedGating;
        if (wrapPoint > cachedGatingSequence) {
            long minSequence;
            if (doStore) {
                this.cursor.setVolatile(produced);
            }
            this.cachedGating = minSequence = Util.getMinimumSequence(this.gatingBarriers, produced);
            return wrapPoint <= minSequence;
        }
        return true;
    }

    @Override
    public long next() {
        try {
            return this.nextImpl(1, false);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long next(int n) {
        try {
            return this.nextImpl(n, false);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long nextInterruptibly() throws InterruptedException {
        return this.nextImpl(1, true);
    }

    @Override
    public long nextInterruptibly(int n) throws InterruptedException {
        return this.nextImpl(n, true);
    }

    private long nextImpl(int n, boolean interruptible) throws InterruptedException {
        assert (this.produced == this.cursor.getVolatile()) : "Unpublished";
        if (n < 1 || n > this.bufferSize) {
            throw new IllegalArgumentException("n: " + n);
        }
        long produced = this.produced;
        long nextSequence = produced + (long)n;
        long wrapPoint = nextSequence - (long)this.bufferSize;
        long cachedGatingSequence = this.cachedGating;
        if (wrapPoint > cachedGatingSequence) {
            long minSequence;
            this.cursor.setVolatile(produced);
            boolean interrupted = false;
            while (wrapPoint > (minSequence = Util.getMinimumSequence(this.gatingBarriers, produced))) {
                if (this.sleepNanos <= 0L) {
                    Thread.onSpinWait();
                    continue;
                }
                if (interruptible) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                } else {
                    interrupted |= Thread.interrupted();
                }
                LockSupport.parkNanos(this.sleepNanos);
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            this.cachedGating = minSequence;
        }
        this.produced = nextSequence;
        return nextSequence;
    }

    @Override
    public long tryNext() {
        return this.tryNext(1);
    }

    @Override
    public long tryNext(int n) {
        long nextSequence;
        assert (this.produced == this.cursor.getVolatile()) : "Unpublished";
        if (n < 1 || n > this.bufferSize) {
            throw new IllegalArgumentException("n: " + n);
        }
        if (!this.hasAvailableCapacity(n, true)) {
            return -1L;
        }
        this.produced = nextSequence = this.produced + (long)n;
        return nextSequence;
    }

    @Override
    public void publish(long sequence) {
        this.cursor.setRelease(sequence);
        this.signalAllWhenBlocking();
    }

    @Override
    public void publish(long lo, long hi) {
        this.publish(hi);
    }

    @Override
    public boolean isPublished(long sequence) {
        return sequence <= this.cursor.getVolatile();
    }

    @Override
    public long getHighestPublishedSequence(long nextSequence, long availableSequence) {
        return availableSequence;
    }
}

