/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.DataProvider;
import cn.wjybxx.disruptor.EventFactory;
import cn.wjybxx.disruptor.EventSequencer;
import cn.wjybxx.disruptor.EventSequencerBuilder;
import cn.wjybxx.disruptor.MpUnboundedBuffer;
import cn.wjybxx.disruptor.MpUnboundedBufferSequencer;
import cn.wjybxx.disruptor.ProducerBarrier;
import cn.wjybxx.disruptor.Sequencer;
import cn.wjybxx.disruptor.WaitStrategy;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class MpUnboundedEventSequencer<T>
implements EventSequencer<T> {
    private final MpUnboundedBuffer<T> buffer;
    private final MpUnboundedBufferSequencer<T> sequencer;

    private MpUnboundedEventSequencer(Builder<T> builder) {
        Objects.requireNonNull(builder);
        this.buffer = new MpUnboundedBuffer(builder.getFactory(), builder.getChunkSize(), builder.getMaxPooledChunks());
        this.sequencer = new MpUnboundedBufferSequencer<T>(this.buffer, builder.getWaitStrategy(), builder.getBlocker());
    }

    public MpUnboundedBuffer<T> getBuffer() {
        return this.buffer;
    }

    public boolean inSameChunk(long seq1, long seq2) {
        return this.buffer.inSameChunk(seq1, seq2);
    }

    public boolean tryMoveHeadToNext() {
        return this.buffer.tryMoveHeadToNext(this.sequencer.minimumSequence());
    }

    public boolean tryMoveHeadToNext(long gatingSequence) {
        return this.buffer.tryMoveHeadToNext(gatingSequence);
    }

    @Override
    public final T get(long sequence) {
        return this.buffer.get(sequence);
    }

    @Override
    public final T producerGet(long sequence) {
        return this.buffer.producerGet(sequence);
    }

    @Override
    public final T consumerGet(long sequence) {
        return this.buffer.consumerGet(sequence);
    }

    @Override
    public void producerSet(long sequence, T data) {
        this.buffer.producerSet(sequence, data);
    }

    @Override
    public void consumerSet(long sequence, T data) {
        this.buffer.consumerSet(sequence, data);
    }

    @Override
    public int capacity() {
        return -1;
    }

    @Override
    public long remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Sequencer sequencer() {
        return this.sequencer;
    }

    @Override
    public ProducerBarrier producerBarrier() {
        return this.sequencer;
    }

    @Override
    public DataProvider<T> dataProvider() {
        return this.buffer;
    }

    @Override
    public boolean hasAvailableCapacity(int requiredCapacity) {
        return this.sequencer.hasAvailableCapacity(requiredCapacity);
    }

    @Override
    public long next() {
        return this.sequencer.next(1);
    }

    @Override
    public long next(int n) {
        return this.sequencer.next(n);
    }

    @Override
    public long tryNext() {
        return this.sequencer.tryNext(1);
    }

    @Override
    public long tryNext(int n) {
        return this.sequencer.tryNext(n);
    }

    @Override
    public long nextInterruptibly() throws InterruptedException {
        return this.sequencer.nextInterruptibly(1);
    }

    @Override
    public long nextInterruptibly(int n) throws InterruptedException {
        return this.sequencer.nextInterruptibly(n);
    }

    @Override
    public long tryNext(int n, long timeout, TimeUnit unit) {
        return this.sequencer.tryNext(n, timeout, unit);
    }

    @Override
    public void publish(long sequence) {
        this.sequencer.publish(sequence);
    }

    @Override
    public void publish(long lo, long hi) {
        this.sequencer.publish(lo, hi);
    }

    public static <T> Builder<T> newBuilder(EventFactory<? extends T> factory) {
        return new Builder<T>(factory);
    }

    public static class Builder<T>
    extends EventSequencerBuilder<T> {
        private int chunkSize = 1024;
        private int maxPooledChunks = 8;

        public Builder(EventFactory<? extends T> factory) {
            super(factory);
        }

        @Override
        public MpUnboundedEventSequencer<T> build() {
            return new MpUnboundedEventSequencer(this);
        }

        public int getChunkSize() {
            return this.chunkSize;
        }

        public Builder<T> setChunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public int getMaxPooledChunks() {
            return this.maxPooledChunks;
        }

        public Builder<T> setMaxPooledChunks(int maxPooledChunks) {
            this.maxPooledChunks = maxPooledChunks;
            return this;
        }

        @Override
        public Builder<T> setProducerSleepNanos(long producerSleepNanos) {
            return (Builder)super.setProducerSleepNanos(producerSleepNanos);
        }

        @Override
        public Builder<T> setWaitStrategy(WaitStrategy waitStrategy) {
            return (Builder)super.setWaitStrategy(waitStrategy);
        }

        @Override
        public Builder<T> enableBlocker() {
            return (Builder)super.enableBlocker();
        }

        @Override
        public Builder<T> disableBlocker() {
            return (Builder)super.disableBlocker();
        }
    }
}

