/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.DataProvider;
import cn.wjybxx.disruptor.EventFactory;
import cn.wjybxx.disruptor.EventSequencer;
import cn.wjybxx.disruptor.EventSequencerBuilder;
import cn.wjybxx.disruptor.MultiProducerSequencer;
import cn.wjybxx.disruptor.ProducerBarrier;
import cn.wjybxx.disruptor.ProducerType;
import cn.wjybxx.disruptor.RingBuffer;
import cn.wjybxx.disruptor.RingBufferSequencer;
import cn.wjybxx.disruptor.Sequencer;
import cn.wjybxx.disruptor.SingleProducerSequencer;
import cn.wjybxx.disruptor.WaitStrategy;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class RingBufferEventSequencer<T>
implements EventSequencer<T> {
    private final RingBuffer<T> buffer;
    private final RingBufferSequencer sequencer;

    private RingBufferEventSequencer(Builder<T> builder) {
        Objects.requireNonNull(builder);
        this.buffer = new RingBuffer(builder.getFactory(), builder.getBufferSize());
        this.sequencer = builder.getProducerType() == ProducerType.MULTI ? new MultiProducerSequencer(builder.getBufferSize(), builder.getProducerSleepNanos(), builder.getWaitStrategy(), builder.getBlocker()) : new SingleProducerSequencer(builder.getBufferSize(), builder.getProducerSleepNanos(), builder.getWaitStrategy(), builder.getBlocker());
    }

    public RingBuffer<T> getBuffer() {
        return this.buffer;
    }

    @Override
    public final T get(long sequence) {
        return this.buffer.getElement(sequence);
    }

    @Override
    public final T producerGet(long sequence) {
        return this.buffer.getElement(sequence);
    }

    @Override
    public final T consumerGet(long sequence) {
        return this.buffer.getElement(sequence);
    }

    @Override
    public void producerSet(long sequence, T data) {
        Objects.requireNonNull(data);
        this.buffer.setElement(sequence, data);
    }

    @Override
    public void consumerSet(long sequence, T data) {
        this.buffer.setElement(sequence, data);
    }

    @Override
    public int capacity() {
        return this.buffer.getBufferSize();
    }

    @Override
    public long remainingCapacity() {
        return this.sequencer.remainingCapacity();
    }

    @Override
    public Sequencer sequencer() {
        return this.sequencer;
    }

    @Override
    public ProducerBarrier producerBarrier() {
        return this.sequencer;
    }

    @Override
    public DataProvider<T> dataProvider() {
        return this.buffer;
    }

    @Override
    public boolean hasAvailableCapacity(int requiredCapacity) {
        return this.sequencer.hasAvailableCapacity(requiredCapacity);
    }

    @Override
    public long next() {
        return this.sequencer.next(1);
    }

    @Override
    public long next(int n) {
        return this.sequencer.next(n);
    }

    @Override
    public long tryNext() {
        return this.sequencer.tryNext(1);
    }

    @Override
    public long tryNext(int n) {
        return this.sequencer.tryNext(n);
    }

    @Override
    public long nextInterruptibly() throws InterruptedException {
        return this.sequencer.nextInterruptibly(1);
    }

    @Override
    public long nextInterruptibly(int n) throws InterruptedException {
        return this.sequencer.nextInterruptibly(n);
    }

    @Override
    public long tryNext(int n, long timeout, TimeUnit unit) {
        return this.sequencer.tryNext(n, timeout, unit);
    }

    @Override
    public void publish(long sequence) {
        this.sequencer.publish(sequence);
    }

    @Override
    public void publish(long lo, long hi) {
        this.sequencer.publish(lo, hi);
    }

    public static <T> Builder<T> newMultiProducer(EventFactory<? extends T> factory) {
        return new Builder<T>(factory).setProducerType(ProducerType.MULTI);
    }

    public static <T> Builder<T> newSingleProducer(EventFactory<? extends T> factory) {
        return new Builder<T>(factory).setProducerType(ProducerType.SINGLE);
    }

    public static class Builder<T>
    extends EventSequencerBuilder<T> {
        private ProducerType producerType = ProducerType.MULTI;
        private int bufferSize = 8192;

        public Builder(EventFactory<? extends T> factory) {
            super(factory);
        }

        @Override
        public RingBufferEventSequencer<T> build() {
            return new RingBufferEventSequencer(this);
        }

        public ProducerType getProducerType() {
            return this.producerType;
        }

        public Builder<T> setProducerType(ProducerType producerType) {
            this.producerType = Objects.requireNonNull(producerType);
            return this;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public Builder<T> setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        @Override
        public Builder<T> setProducerSleepNanos(long producerSleepNanos) {
            return (Builder)super.setProducerSleepNanos(producerSleepNanos);
        }

        @Override
        public Builder<T> setWaitStrategy(WaitStrategy waitStrategy) {
            return (Builder)super.setWaitStrategy(waitStrategy);
        }

        @Override
        public Builder<T> enableBlocker() {
            return (Builder)super.enableBlocker();
        }

        @Override
        public Builder<T> disableBlocker() {
            return (Builder)super.disableBlocker();
        }
    }
}

