/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.ConsumerBarrier;
import cn.wjybxx.disruptor.MultiConsumerBarrier;
import cn.wjybxx.disruptor.ProducerBarrier;
import cn.wjybxx.disruptor.SequenceBarrier;
import cn.wjybxx.disruptor.SingleConsumerBarrier;
import cn.wjybxx.disruptor.WaitStrategy;
import javax.annotation.Nonnull;

public interface Sequencer {
    default public void addGatingBarriers(SequenceBarrier ... gatingBarriers) {
        this.getProducerBarrier().addDependentBarriers(gatingBarriers);
    }

    default public boolean removeGatingBarrier(SequenceBarrier gatingBarrier) {
        return this.getProducerBarrier().removeDependentBarrier(gatingBarrier);
    }

    @Nonnull
    public WaitStrategy getWaitStrategy();

    public ProducerBarrier getProducerBarrier();

    default public ConsumerBarrier newSingleConsumerBarrier(SequenceBarrier ... barriersToTrack) {
        return new SingleConsumerBarrier(this.getProducerBarrier(), this.getWaitStrategy(), barriersToTrack);
    }

    default public ConsumerBarrier newSingleConsumerBarrier(WaitStrategy waitStrategy, SequenceBarrier ... barriersToTrack) {
        if (waitStrategy == null) {
            waitStrategy = this.getWaitStrategy();
        }
        return new SingleConsumerBarrier(this.getProducerBarrier(), waitStrategy, barriersToTrack);
    }

    default public ConsumerBarrier newMultiConsumerBarrier(int workerCount, SequenceBarrier ... barriersToTrack) {
        return new MultiConsumerBarrier(this.getProducerBarrier(), workerCount, this.getWaitStrategy(), barriersToTrack);
    }

    default public ConsumerBarrier newMultiConsumerBarrier(int workerCount, WaitStrategy waitStrategy, SequenceBarrier ... barriersToTrack) {
        if (waitStrategy == null) {
            waitStrategy = this.getWaitStrategy();
        }
        return new MultiConsumerBarrier(this.getProducerBarrier(), workerCount, waitStrategy, barriersToTrack);
    }
}

