/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.AlertException;
import cn.wjybxx.disruptor.ConsumerBarrier;
import cn.wjybxx.disruptor.ProducerBarrier;
import cn.wjybxx.disruptor.WaitStrategy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;

public class SleepingWaitStrategy
implements WaitStrategy {
    private final int spinTries;
    private final int yieldTries;
    private final long sleepTimeNs;

    public SleepingWaitStrategy() {
        this.spinTries = 100;
        this.yieldTries = 100;
        this.sleepTimeNs = 1000L;
    }

    public SleepingWaitStrategy(int spinTries, int yieldTries, long sleepTime, TimeUnit unit) {
        this.spinTries = spinTries;
        this.yieldTries = yieldTries;
        this.sleepTimeNs = unit.toNanos(sleepTime);
    }

    @Override
    public long waitFor(long sequence, ProducerBarrier producerBarrier, ConsumerBarrier barrier) throws TimeoutException, AlertException, InterruptedException {
        long availableSequence;
        int counter = this.spinTries + this.yieldTries;
        while ((availableSequence = barrier.dependentSequence()) < sequence) {
            barrier.checkAlert();
            if (counter > this.yieldTries) {
                --counter;
                Thread.onSpinWait();
                continue;
            }
            if (counter > 0) {
                --counter;
                Thread.yield();
                continue;
            }
            LockSupport.parkNanos(this.sleepTimeNs);
        }
        return availableSequence;
    }
}

