/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.AlertException;
import cn.wjybxx.disruptor.ConsumerBarrier;
import cn.wjybxx.disruptor.ProducerBarrier;
import cn.wjybxx.disruptor.WaitStrategy;
import java.util.concurrent.TimeoutException;

public class YieldingWaitStrategy
implements WaitStrategy {
    private final int spinTries;

    public YieldingWaitStrategy() {
        this.spinTries = 100;
    }

    public YieldingWaitStrategy(int spinTries) {
        this.spinTries = spinTries;
    }

    @Override
    public long waitFor(long sequence, ProducerBarrier producerBarrier, ConsumerBarrier barrier) throws TimeoutException, AlertException, InterruptedException {
        long availableSequence;
        int counter = this.spinTries;
        while ((availableSequence = barrier.dependentSequence()) < sequence) {
            barrier.checkAlert();
            if (counter > 0) {
                --counter;
                Thread.onSpinWait();
                continue;
            }
            Thread.yield();
        }
        return availableSequence;
    }
}

