/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.MpUnboundedBuffer;
import cn.wjybxx.disruptor.MpUnboundedBufferChunk;
import cn.wjybxx.disruptor.ProducerBarrier;
import cn.wjybxx.disruptor.Sequence;
import cn.wjybxx.disruptor.SequenceBarrier;
import cn.wjybxx.disruptor.SequenceBlocker;
import cn.wjybxx.disruptor.Sequencer;
import cn.wjybxx.disruptor.Util;
import cn.wjybxx.disruptor.WaitStrategy;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MpUnboundedBufferSequencer<T>
implements ProducerBarrier,
Sequencer {
    private final Sequence cursor = new Sequence();
    private volatile SequenceBarrier[] gatingBarriers = new SequenceBarrier[0];
    private final MpUnboundedBuffer<T> buffer;
    private final WaitStrategy waitStrategy;
    private final SequenceBlocker blocker;
    private static final VarHandle VH_GATING_BARRIERS;

    public MpUnboundedBufferSequencer(MpUnboundedBuffer<T> buffer, WaitStrategy waitStrategy, @Nullable SequenceBlocker blocker) {
        this.buffer = Objects.requireNonNull(buffer, "buffer");
        this.waitStrategy = Objects.requireNonNull(waitStrategy, "waitStrategy");
        this.blocker = blocker;
    }

    @Override
    @Deprecated
    public void claim(long sequence) {
        if (!this.cursor.compareAndSet(-1L, sequence)) {
            throw new IllegalStateException();
        }
        this.buffer.claim(sequence);
    }

    @Override
    public void publish(long sequence) {
        MpUnboundedBufferChunk<T> chunk = this.buffer.producerChunkForSequence(sequence);
        chunk.publish((int)(sequence - chunk.minSequence()));
    }

    @Override
    public void publish(long lo, long hi) {
        long minSequence;
        MpUnboundedBufferChunk<T> chunk = this.buffer.producerChunkForSequence(lo);
        while (hi > chunk.maxSequence()) {
            minSequence = chunk.minSequence();
            chunk.publish((int)(lo - minSequence), chunk.length() - 1);
            lo = minSequence + (long)chunk.length();
            if ((chunk = chunk.lvNext()) != null) continue;
            chunk = this.buffer.producerChunkForSequence(lo);
        }
        minSequence = chunk.minSequence();
        chunk.publish((int)(lo - minSequence), (int)(hi - minSequence));
    }

    @Override
    public boolean isPublished(long sequence) {
        MpUnboundedBufferChunk<T> chunk = this.buffer.consumerChunkForSequence(sequence);
        return chunk.isPublished((int)(sequence - chunk.minSequence()));
    }

    @Override
    public long getHighestPublishedSequence(long lo, long hi) {
        int maxIndex;
        long minSequence;
        MpUnboundedBufferChunk<T> chunk = this.buffer.consumerChunkForSequence(lo);
        while (hi > chunk.maxSequence()) {
            minSequence = chunk.minSequence();
            int highestIndex = chunk.getHighestPublished((int)(lo - minSequence), maxIndex = chunk.length() - 1);
            if (highestIndex != maxIndex) {
                return minSequence + (long)highestIndex;
            }
            if ((chunk = chunk.lvNext()) == null) {
                return minSequence + (long)highestIndex;
            }
            lo = minSequence + (long)maxIndex + 1L;
        }
        minSequence = chunk.minSequence();
        maxIndex = (int)(hi - minSequence);
        return minSequence + (long)chunk.getHighestPublished((int)(lo - minSequence), maxIndex);
    }

    @Override
    public boolean hasAvailableCapacity(int requiredCapacity) {
        if (requiredCapacity < 0) {
            throw new IllegalArgumentException("requiredCapacity: " + requiredCapacity);
        }
        return true;
    }

    @Override
    public long next() {
        return this.nextImpl(1);
    }

    @Override
    public long next(int n) {
        return this.nextImpl(n);
    }

    @Override
    public long nextInterruptibly() {
        return this.nextImpl(1);
    }

    @Override
    public long nextInterruptibly(int n) {
        return this.nextImpl(n);
    }

    @Override
    public long tryNext() {
        return this.nextImpl(1);
    }

    @Override
    public long tryNext(int n) {
        return this.nextImpl(n);
    }

    @Override
    public long tryNext(int n, long timeout, TimeUnit unit) {
        return this.nextImpl(n);
    }

    private long nextImpl(int n) {
        long next;
        long current;
        if (n < 1) {
            throw new IllegalArgumentException("n: " + n);
        }
        while (!this.cursor.compareAndSet(current = this.cursor.getVolatile(), next = current + (long)n)) {
        }
        if (!this.buffer.inSameChunk(current, next)) {
            this.buffer.tryMoveHeadToNext(Util.getMinimumSequence(this.gatingBarriers, current));
            this.buffer.producerChunkForSequence(next);
        }
        return next;
    }

    @Override
    public ProducerBarrier getProducerBarrier() {
        return this;
    }

    @Override
    @Nonnull
    public WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    @Override
    @Nullable
    public SequenceBlocker getBlocker() {
        return this.blocker;
    }

    @Override
    public void signalAllWhenBlocking() {
        if (this.blocker != null) {
            this.blocker.signalAll();
        }
    }

    @Override
    public Sequence groupSequence() {
        return this.cursor;
    }

    @Override
    public long sequence() {
        return this.cursor.getVolatile();
    }

    @Override
    public long dependentSequence() {
        return Util.getMinimumSequence(this.gatingBarriers, Long.MAX_VALUE);
    }

    @Override
    public long minimumSequence() {
        return Util.getMinimumSequence(this.gatingBarriers, this.cursor.getVolatile());
    }

    @Override
    public void addDependentBarriers(SequenceBarrier ... barriersToTrack) {
        Util.addBarriers(VH_GATING_BARRIERS, this, barriersToTrack);
    }

    @Override
    public boolean removeDependentBarrier(SequenceBarrier barrier) {
        return Util.removeBarrier(VH_GATING_BARRIERS, this, barrier);
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            VH_GATING_BARRIERS = l.findVarHandle(MpUnboundedBufferSequencer.class, "gatingBarriers", SequenceBarrier[].class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

