/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.EventFactory;
import cn.wjybxx.disruptor.EventSequencer;
import cn.wjybxx.disruptor.SequenceBlocker;
import cn.wjybxx.disruptor.TimeoutSleepingWaitStrategy;
import cn.wjybxx.disruptor.WaitStrategy;
import java.util.Objects;

public abstract class EventSequencerBuilder<T> {
    private final EventFactory<? extends T> factory;
    private long producerSleepNanos = 1L;
    private WaitStrategy waitStrategy = TimeoutSleepingWaitStrategy.INSTANCE;
    private SequenceBlocker blocker;

    public EventSequencerBuilder(EventFactory<? extends T> factory) {
        this.factory = Objects.requireNonNull(factory);
    }

    public abstract EventSequencer<T> build();

    public EventFactory<? extends T> getFactory() {
        return this.factory;
    }

    public long getProducerSleepNanos() {
        return this.producerSleepNanos;
    }

    public EventSequencerBuilder<T> setProducerSleepNanos(long producerSleepNanos) {
        this.producerSleepNanos = producerSleepNanos;
        return this;
    }

    public WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    public EventSequencerBuilder<T> setWaitStrategy(WaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
        return this;
    }

    public SequenceBlocker getBlocker() {
        return this.blocker;
    }

    public EventSequencerBuilder<T> enableBlocker() {
        this.blocker = new SequenceBlocker();
        return this;
    }

    public EventSequencerBuilder<T> disableBlocker() {
        this.blocker = null;
        return this;
    }
}

