/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.DataProvider;
import cn.wjybxx.disruptor.EventFactory;
import cn.wjybxx.disruptor.Util;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;

public final class RingBuffer<E>
implements DataProvider<E> {
    private static final int BUFFER_PAD = 16;
    private long p1;
    private long p2;
    private long p3;
    private long p4;
    private long p5;
    private long p6;
    private long p7;
    private final long indexMask;
    private final Object[] entries;
    private final long bufferSize;
    private long p11;
    private long p12;
    private long p13;
    private long p14;
    private long p15;
    private long p16;
    private long p17;

    public RingBuffer(EventFactory<? extends E> eventFactory, int bufferSize) {
        Objects.requireNonNull(eventFactory, "eventFactory");
        if (!Util.isPowerOfTwo(bufferSize)) {
            throw new IllegalArgumentException("bufferSize must be a power of 2");
        }
        this.entries = new Object[bufferSize + 32];
        this.bufferSize = bufferSize;
        this.indexMask = bufferSize - 1;
        this.fill(eventFactory);
    }

    private void fill(EventFactory<? extends E> eventFactory) {
        int i = 0;
        while ((long)i < this.bufferSize) {
            this.entries[16 + i] = eventFactory.newInstance();
            ++i;
        }
    }

    E getElement(long sequence) {
        if (sequence < 0L) {
            throw new IllegalArgumentException("sequence: " + sequence);
        }
        int index = (int)(sequence & this.indexMask);
        return (E)this.entries[16 + index];
    }

    void setElement(long sequence, E event) {
        if (sequence < 0L) {
            throw new IllegalArgumentException("sequence: " + sequence);
        }
        int index = (int)(sequence & this.indexMask);
        this.entries[16 + index] = event;
    }

    public int getBufferSize() {
        return (int)this.bufferSize;
    }

    public Stream<E> stream() {
        Object[] elements = this.entries;
        return Arrays.asList(elements).subList(16, 16 + (int)this.bufferSize).stream();
    }

    @Override
    public E get(long sequence) {
        return this.getElement(sequence);
    }

    @Override
    public E producerGet(long sequence) {
        return this.getElement(sequence);
    }

    @Override
    public E consumerGet(long sequence) {
        return this.getElement(sequence);
    }

    @Override
    public void producerSet(long sequence, E data) {
        Objects.requireNonNull(data);
        this.setElement(sequence, data);
    }

    @Override
    public void consumerSet(long sequence, E data) {
        this.setElement(sequence, data);
    }
}

