/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.AlertException;
import cn.wjybxx.disruptor.ConsumerBarrier;
import cn.wjybxx.disruptor.ProducerBarrier;
import cn.wjybxx.disruptor.SequenceBlocker;
import cn.wjybxx.disruptor.WaitStrategy;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public class TimeoutBlockingWaitStrategy
implements WaitStrategy {
    private final long timeoutInNanos;

    public TimeoutBlockingWaitStrategy(long timeout, TimeUnit units) {
        this.timeoutInNanos = units.toNanos(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitFor(long sequence, ProducerBarrier producerBarrier, ConsumerBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence;
        SequenceBlocker blocker = Objects.requireNonNull(producerBarrier.getBlocker(), "blocker is null");
        long nanos = this.timeoutInNanos;
        if (producerBarrier.sequence() < sequence) {
            blocker.lock();
            try {
                while (producerBarrier.sequence() < sequence) {
                    barrier.checkAlert();
                    if ((nanos = blocker.awaitNanos(nanos)) > 0L) continue;
                    long l = sequence - 1L;
                    return l;
                }
            }
            finally {
                blocker.unlock();
            }
        }
        while ((availableSequence = barrier.dependentSequence()) < sequence) {
            barrier.checkAlert();
            LockSupport.parkNanos(100L);
        }
        return availableSequence;
    }
}

