/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.AlertException;
import cn.wjybxx.disruptor.ConsumerBarrier;
import cn.wjybxx.disruptor.ProducerBarrier;
import cn.wjybxx.disruptor.WaitStrategy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public class TimeoutSleepingWaitStrategy
implements WaitStrategy {
    public static final TimeoutSleepingWaitStrategy INSTANCE = new TimeoutSleepingWaitStrategy();
    private static final int SPIN_TRIES = 10;
    private static final int YIELD_TRIES = 10;
    private static final int SLEEP_TRIES = 10;
    private static final int SLEEP_NANOS = 100000;
    private final int spinTries;
    private final int yieldTries;
    private final int sleepTries;
    private final long sleepTimeNs;

    public TimeoutSleepingWaitStrategy() {
        this(10, 10, 10, 100000L, TimeUnit.NANOSECONDS);
    }

    public TimeoutSleepingWaitStrategy(int spinTries, int yieldTries, int sleepTries, long sleepTime, TimeUnit unit) {
        this.spinTries = spinTries;
        this.yieldTries = yieldTries;
        this.sleepTries = sleepTries;
        this.sleepTimeNs = unit.toNanos(sleepTime);
    }

    @Override
    public long waitFor(long sequence, ProducerBarrier producerBarrier, ConsumerBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence;
        int counter = this.spinTries + this.yieldTries + this.sleepTries;
        int yieldThreshold = this.yieldTries + this.sleepTries;
        long parkDeadline = System.nanoTime() + (long)this.sleepTries * this.sleepTimeNs;
        while ((availableSequence = barrier.dependentSequence()) < sequence) {
            barrier.checkAlert();
            if (counter > yieldThreshold) {
                --counter;
                Thread.onSpinWait();
                continue;
            }
            if (counter > this.sleepTries) {
                --counter;
                Thread.yield();
                continue;
            }
            if (counter > 0) {
                --counter;
                long remainNano = Math.min(parkDeadline - System.nanoTime(), this.sleepTimeNs);
                if (remainNano < 1L) {
                    return sequence - 1L;
                }
                LockSupport.parkNanos(remainNano);
                continue;
            }
            return sequence - 1L;
        }
        return availableSequence;
    }
}

