/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.AlertException;
import cn.wjybxx.disruptor.ConsumerBarrier;
import cn.wjybxx.disruptor.ProducerBarrier;
import cn.wjybxx.disruptor.SequenceBlocker;
import cn.wjybxx.disruptor.WaitStrategy;
import java.util.Objects;
import java.util.concurrent.locks.LockSupport;

public class BlockingWaitStrategy
implements WaitStrategy {
    public static final BlockingWaitStrategy INSTANCE = new BlockingWaitStrategy();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitFor(long sequence, ProducerBarrier producerBarrier, ConsumerBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence;
        SequenceBlocker blocker = Objects.requireNonNull(producerBarrier.getBlocker(), "blocker is null");
        if (producerBarrier.sequence() < sequence) {
            blocker.lock();
            try {
                while (producerBarrier.sequence() < sequence) {
                    barrier.checkAlert();
                    blocker.await();
                }
            }
            finally {
                blocker.unlock();
            }
        }
        while ((availableSequence = barrier.dependentSequence()) < sequence) {
            barrier.checkAlert();
            LockSupport.parkNanos(10L);
        }
        return availableSequence;
    }
}

