/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.disruptor;

import cn.wjybxx.disruptor.ConsumerBarrier;
import cn.wjybxx.disruptor.DataProvider;
import cn.wjybxx.disruptor.ProducerBarrier;
import cn.wjybxx.disruptor.SequenceBarrier;
import cn.wjybxx.disruptor.Sequencer;
import cn.wjybxx.disruptor.WaitStrategy;
import java.util.concurrent.TimeUnit;

public interface EventSequencer<T>
extends DataProvider<T> {
    public static final int UNBOUNDED_CAPACITY = -1;

    public int capacity();

    public long remainingCapacity();

    public Sequencer sequencer();

    public ProducerBarrier producerBarrier();

    public DataProvider<T> dataProvider();

    default public void addGatingBarriers(SequenceBarrier ... gatingBarriers) {
        this.sequencer().addGatingBarriers(gatingBarriers);
    }

    default public boolean removeGatingBarrier(SequenceBarrier gatingBarrier) {
        return this.sequencer().removeGatingBarrier(gatingBarrier);
    }

    default public ConsumerBarrier newSingleConsumerBarrier(SequenceBarrier ... barriersToTrack) {
        return this.sequencer().newSingleConsumerBarrier(barriersToTrack);
    }

    default public ConsumerBarrier newSingleConsumerBarrier(WaitStrategy waitStrategy, SequenceBarrier ... barriersToTrack) {
        return this.sequencer().newSingleConsumerBarrier(waitStrategy, barriersToTrack);
    }

    default public ConsumerBarrier newMultiConsumerBarrier(int workerCount, SequenceBarrier ... barriersToTrack) {
        return this.sequencer().newMultiConsumerBarrier(workerCount, barriersToTrack);
    }

    default public ConsumerBarrier newMultiConsumerBarrier(int workerCount, WaitStrategy waitStrategy, SequenceBarrier ... barriersToTrack) {
        return this.sequencer().newMultiConsumerBarrier(workerCount, waitStrategy, barriersToTrack);
    }

    default public boolean hasAvailableCapacity(int requiredCapacity) {
        return this.producerBarrier().hasAvailableCapacity(requiredCapacity);
    }

    default public long next() {
        return this.producerBarrier().next();
    }

    default public long next(int n) {
        return this.producerBarrier().next(n);
    }

    default public long tryNext() {
        return this.producerBarrier().tryNext();
    }

    default public long tryNext(int n) {
        return this.producerBarrier().tryNext(n);
    }

    default public long nextInterruptibly() throws InterruptedException {
        return this.producerBarrier().nextInterruptibly();
    }

    default public long nextInterruptibly(int n) throws InterruptedException {
        return this.producerBarrier().nextInterruptibly(n);
    }

    default public long tryNext(int n, long timeout, TimeUnit unit) {
        return this.producerBarrier().tryNext(n, timeout, unit);
    }

    default public void publish(long sequence) {
        this.producerBarrier().publish(sequence);
    }

    default public void publish(long lo, long hi) {
        this.producerBarrier().publish(lo, hi);
    }
}

